/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.providers.AbstractEntityProvider;
import org.jboss.resteasy.spi.ReaderException;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.WriterException;
import org.w3c.dom.Document;

@Provider
@Produces(value={"text/*+xml", "application/*+xml"})
@Consumes(value={"text/*+xml", "application/*+xml"})
public class DocumentProvider
extends AbstractEntityProvider<Document> {
    private static final Logger logger = Logger.getLogger(DocumentProvider.class);
    private final TransformerFactory transformerFactory;
    private final DocumentBuilderFactory documentBuilder = DocumentBuilderFactory.newInstance();
    private boolean expandEntityReferences = false;
    private boolean enableSecureProcessingFeature = true;
    private boolean disableDTDs = true;

    public DocumentProvider(@Context ResteasyConfiguration config) {
        String s;
        this.transformerFactory = TransformerFactory.newInstance();
        try {
            s = config.getParameter("resteasy.document.expand.entity.references");
            this.expandEntityReferences = s == null ? false : Boolean.parseBoolean(s);
        }
        catch (Exception e) {
            logger.debug("Unable to retrieve config: expandEntityReferences defaults to false");
        }
        try {
            s = config.getParameter("resteasy.document.secure.processing.feature");
            this.enableSecureProcessingFeature = s == null ? true : Boolean.parseBoolean(s);
        }
        catch (Exception e) {
            logger.debug("Unable to retrieve config: enableSecureProcessingFeature defaults to true");
        }
        try {
            s = config.getParameter("resteasy.document.secure.disableDTDs");
            this.disableDTDs = s == null ? true : Boolean.parseBoolean(s);
        }
        catch (Exception e) {
            logger.debug("Unable to retrieve config: disableDTDs defaults to true");
        }
    }

    public boolean isReadable(Class<?> clazz, Type type, Annotation[] annotation, MediaType mediaType) {
        return Document.class.isAssignableFrom(clazz);
    }

    public Document readFrom(Class<Document> clazz, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream input) throws IOException, WebApplicationException {
        try {
            this.documentBuilder.setExpandEntityReferences(this.expandEntityReferences);
            this.documentBuilder.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", this.enableSecureProcessingFeature);
            this.documentBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", this.disableDTDs);
            return this.documentBuilder.newDocumentBuilder().parse(input);
        }
        catch (Exception e) {
            throw new ReaderException(e);
        }
    }

    public boolean isWriteable(Class<?> clazz, Type type, Annotation[] annotation, MediaType mediaType) {
        return Document.class.isAssignableFrom(clazz);
    }

    public void writeTo(Document document, Class<?> clazz, Type type, Annotation[] annotation, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream output) throws IOException, WebApplicationException {
        try {
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(output);
            this.transformerFactory.newTransformer().transform(source, result);
        }
        catch (TransformerException te) {
            throw new WriterException(te);
        }
    }
}

