/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.GlobalComponentRegistryService;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactory;
import org.wildfly.clustering.web.infinispan.session.RouteLocatorService;
import org.wildfly.clustering.web.infinispan.session.SessionCacheConfigurationService;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SessionManagerFactoryBuilder;

public class InfinispanSessionManagerFactoryBuilder
implements SessionManagerFactoryBuilder {
    public static final String DEFAULT_CACHE_CONTAINER = "web";

    public ServiceBuilder<SessionManagerFactory> buildDeploymentDependency(ServiceTarget target, ServiceName name, SessionManagerConfiguration config) {
        ServiceName templateCacheServiceName = InfinispanSessionManagerFactoryBuilder.getCacheServiceName(config.getCacheName());
        String templateCacheName = templateCacheServiceName.getSimpleName();
        ServiceName containerServiceName = templateCacheServiceName.getParent();
        String containerName = containerServiceName.getSimpleName();
        String cacheName = config.getDeploymentName();
        ServiceName cacheConfigurationServiceName = CacheConfigurationService.getServiceName((String)containerName, (String)cacheName);
        ServiceName cacheServiceName = CacheService.getServiceName((String)containerName, (String)cacheName);
        SessionCacheConfigurationService.build(target, containerName, cacheName, templateCacheName).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        final InjectedValue cacheContainer = new InjectedValue();
        CacheService.Dependencies dependencies = new CacheService.Dependencies(){

            public EmbeddedCacheManager getCacheContainer() {
                return (EmbeddedCacheManager)cacheContainer.getValue();
            }

            public XAResourceRecoveryRegistry getRecoveryRegistry() {
                return null;
            }
        };
        AsynchronousService.addService((ServiceTarget)target, (ServiceName)cacheServiceName, (Service)new CacheService(cacheName, dependencies)).addAliases(new ServiceName[]{RouteLocatorService.getCacheServiceAlias(cacheName)}).addDependency(cacheConfigurationServiceName).addDependency(containerServiceName, EmbeddedCacheManager.class, (Injector)cacheContainer).addDependency(GlobalComponentRegistryService.getServiceName((String)containerName)).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        return InfinispanSessionManagerFactory.build(target, name, containerName, cacheName, config);
    }

    private static ServiceName getCacheServiceName(String cacheName) {
        ServiceName serviceName;
        ServiceName baseServiceName = EmbeddedCacheManagerService.getServiceName(null);
        if (!baseServiceName.isParentOf(serviceName = ServiceName.parse((String)(cacheName != null ? cacheName : DEFAULT_CACHE_CONTAINER)))) {
            serviceName = baseServiceName.append(serviceName);
        }
        return serviceName.length() < 4 ? serviceName.append(new String[]{"default"}) : serviceName;
    }
}

