/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.idm.query.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.federation.ldap.idm.model.IdentityType;
import org.keycloak.federation.ldap.idm.query.Condition;
import org.keycloak.federation.ldap.idm.query.IdentityQuery;
import org.keycloak.federation.ldap.idm.query.IdentityQueryBuilder;
import org.keycloak.federation.ldap.idm.query.QueryParameter;
import org.keycloak.federation.ldap.idm.query.Sort;
import org.keycloak.federation.ldap.idm.store.IdentityStore;
import org.keycloak.models.ModelException;

public class DefaultIdentityQuery<T extends IdentityType>
implements IdentityQuery<T> {
    private final Map<QueryParameter, Object[]> parameters = new LinkedHashMap<QueryParameter, Object[]>();
    private final Class<T> identityType;
    private final IdentityStore identityStore;
    private final IdentityQueryBuilder queryBuilder;
    private int offset;
    private int limit;
    private Object paginationContext;
    private QueryParameter[] sortParameters;
    private boolean sortAscending = true;
    private final Set<Condition> conditions = new LinkedHashSet<Condition>();
    private final Set<Sort> ordering = new LinkedHashSet<Sort>();

    public DefaultIdentityQuery(IdentityQueryBuilder queryBuilder, Class<T> identityType, IdentityStore identityStore) {
        this.queryBuilder = queryBuilder;
        this.identityStore = identityStore;
        this.identityType = identityType;
    }

    @Override
    public IdentityQuery<T> setParameter(QueryParameter queryParameter, Object ... value) {
        if (value == null || value.length == 0) {
            throw new ModelException("Query Parameter values null or empty");
        }
        this.parameters.put(queryParameter, value);
        if (IdentityType.CREATED_AFTER.equals(queryParameter) || IdentityType.EXPIRY_AFTER.equals(queryParameter)) {
            this.conditions.add(this.queryBuilder.greaterThanOrEqualTo(queryParameter, value[0]));
        } else if (IdentityType.CREATED_BEFORE.equals(queryParameter) || IdentityType.EXPIRY_BEFORE.equals(queryParameter)) {
            this.conditions.add(this.queryBuilder.lessThanOrEqualTo(queryParameter, value[0]));
        } else {
            this.conditions.add(this.queryBuilder.equal(queryParameter, value[0]));
        }
        return this;
    }

    @Override
    public IdentityQuery<T> where(Condition ... condition) {
        this.conditions.addAll(Arrays.asList(condition));
        return this;
    }

    @Override
    public IdentityQuery<T> sortBy(Sort ... sorts) {
        this.ordering.addAll(Arrays.asList(sorts));
        return this;
    }

    @Override
    public Set<Sort> getSorting() {
        return Collections.unmodifiableSet(this.ordering);
    }

    @Override
    public Class<T> getIdentityType() {
        return this.identityType;
    }

    @Override
    public Map<QueryParameter, Object[]> getParameters() {
        return this.parameters;
    }

    @Override
    public Object[] getParameter(QueryParameter queryParameter) {
        return this.parameters.get(queryParameter);
    }

    @Override
    public Map<QueryParameter, Object[]> getParameters(Class<?> type) {
        HashMap<QueryParameter, Object[]> typedParameters = new HashMap<QueryParameter, Object[]>();
        Set<Map.Entry<QueryParameter, Object[]>> entrySet = this.parameters.entrySet();
        for (Map.Entry<QueryParameter, Object[]> entry : entrySet) {
            if (!type.isInstance(entry.getKey())) continue;
            typedParameters.put(entry.getKey(), entry.getValue());
        }
        return typedParameters;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public Object getPaginationContext() {
        return this.paginationContext;
    }

    @Override
    public QueryParameter[] getSortParameters() {
        return this.sortParameters;
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    @Override
    public List<T> getResultList() {
        if (this.sortParameters != null) {
            for (QueryParameter parameter : this.sortParameters) {
                if (this.isSortAscending()) {
                    this.sortBy(this.queryBuilder.asc(parameter));
                    continue;
                }
                this.sortBy(this.queryBuilder.desc(parameter));
            }
        }
        ArrayList<IdentityType> result = new ArrayList<IdentityType>();
        try {
            for (IdentityType identityType : this.identityStore.fetchQueryResults(this)) {
                result.add(identityType);
            }
        }
        catch (Exception e) {
            throw new ModelException("LDAP Query failed", (Throwable)e);
        }
        return result;
    }

    @Override
    public int getResultCount() {
        return this.identityStore.countQueryResults(this);
    }

    @Override
    public IdentityQuery<T> setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public IdentityQuery<T> setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public IdentityQuery<T> setSortParameters(QueryParameter ... sortParameters) {
        this.sortParameters = sortParameters;
        return this;
    }

    @Override
    public IdentityQuery<T> setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
        return this;
    }

    @Override
    public IdentityQuery<T> setPaginationContext(Object object) {
        this.paginationContext = object;
        return this;
    }

    @Override
    public Set<Condition> getConditions() {
        return Collections.unmodifiableSet(this.conditions);
    }
}

