/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.ArrayList;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.extension.ExtensionResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.operations.SecurityActions;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

public class ApplyMissingDomainModelResourcesHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "apply-missing-domain-resources";
    protected final DomainController domainController;
    protected final HostControllerEnvironment hostControllerEnvironment;
    protected final LocalHostControllerInfo localHostInfo;
    protected final IgnoredDomainResourceRegistry ignoredResourceRegistry;
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("apply-missing-domain-resources", null).setPrivateEntry().build();

    public ApplyMissingDomainModelResourcesHandler(DomainController domainController, HostControllerEnvironment hostControllerEnvironment, LocalHostControllerInfo localHostInfo, IgnoredDomainResourceRegistry ignoredResourceRegistry) {
        this.domainController = domainController;
        this.hostControllerEnvironment = hostControllerEnvironment;
        this.localHostInfo = localHostInfo;
        this.ignoredResourceRegistry = ignoredResourceRegistry;
    }

    public static ModelNode createPiggyBackedMissingDataOperation(ModelNode missingResources) {
        ModelNode applyMissingResourcesOp = new ModelNode();
        applyMissingResourcesOp.get("operation").set(OPERATION_NAME);
        applyMissingResourcesOp.get("address").setEmptyList();
        applyMissingResourcesOp.get("domain-model").set(missingResources);
        return applyMissingResourcesOp;
    }

    public static ModelNode createPulledMissingDataOperation(ModelNode missingResources) {
        ModelNode applyMissingResourcesOp = ApplyMissingDomainModelResourcesHandler.createPiggyBackedMissingDataOperation(missingResources);
        return applyMissingResourcesOp;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress resourceAddress;
        ModelNode domainModel = operation.get("domain-model");
        Resource rootResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ArrayList<ModelNode> nonExtensions = new ArrayList<ModelNode>();
        for (ModelNode resourceDescription : domainModel.asList()) {
            resourceAddress = PathAddress.pathAddress((ModelNode)resourceDescription.require("domain-resource-address"));
            if (this.ignoredResourceRegistry.isResourceExcluded(resourceAddress)) continue;
            if (resourceAddress.size() == 1 && resourceAddress.getElement(0).getKey().equals("extension")) {
                PathElement extensionElement = resourceAddress.getElement(0);
                if (rootResource.hasChild(extensionElement)) continue;
                this.initializeExtension(extensionElement.getValue());
                this.getResource(resourceAddress, rootResource, context).writeModel(resourceDescription.get("domain-model"));
                continue;
            }
            nonExtensions.add(resourceDescription);
        }
        for (ModelNode resourceDescription : nonExtensions) {
            resourceAddress = PathAddress.pathAddress((ModelNode)resourceDescription.require("domain-resource-address"));
            Resource resource = this.getResource(resourceAddress, rootResource, context);
            resource.writeModel(resourceDescription.get("domain-resource-model"));
        }
        context.stepCompleted();
    }

    protected Resource getResource(PathAddress resourceAddress, Resource rootResource, OperationContext context) {
        if (resourceAddress.size() == 0) {
            return rootResource;
        }
        Resource temp = rootResource;
        for (PathElement element : resourceAddress) {
            if ((temp = temp.getChild(element)) != null) continue;
            String type = element.getKey();
            if (type.equals("extension")) {
                temp = new ExtensionResource(element.getValue(), this.domainController.getExtensionRegistry());
                context.addResource(resourceAddress, temp);
            }
            if (temp != null) continue;
            temp = context.createResource(resourceAddress);
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeExtension(String module) throws OperationFailedException {
        try {
            for (Extension extension : Module.loadServiceFromCallerModuleLoader((ModuleIdentifier)ModuleIdentifier.fromString((String)module), Extension.class)) {
                ClassLoader oldTccl = SecurityActions.setThreadContextClassLoader(extension.getClass());
                try {
                    extension.initializeParsers(this.domainController.getExtensionRegistry().getExtensionParsingContext(module, null));
                    extension.initialize(this.domainController.getExtensionRegistry().getExtensionContext(module, false));
                }
                finally {
                    SecurityActions.setThreadContextClassLoader(oldTccl);
                }
            }
        }
        catch (ModuleLoadException e) {
            throw DomainControllerMessages.MESSAGES.failedToLoadModule(e, module);
        }
    }
}

