/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.conf;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import twitter4j.Version;
import twitter4j.conf.Configuration;
import twitter4j.internal.logging.Logger;
import twitter4j.internal.util.z_T4JInternalStringUtil;

class ConfigurationBase
implements Configuration,
Serializable {
    private boolean debug;
    private String userAgent;
    private String user;
    private String password;
    private boolean useSSL;
    private boolean prettyDebug;
    private boolean gzipEnabled;
    private String httpProxyHost;
    private String httpProxyUser;
    private String httpProxyPassword;
    private int httpProxyPort;
    private int httpConnectionTimeout;
    private int httpReadTimeout;
    private int httpStreamingReadTimeout;
    private int httpRetryCount;
    private int httpRetryIntervalSeconds;
    private int maxTotalConnections;
    private int defaultMaxPerRoute;
    private String oAuthConsumerKey;
    private String oAuthConsumerSecret;
    private String oAuthAccessToken;
    private String oAuthAccessTokenSecret;
    private String oAuth2TokenType;
    private String oAuth2AccessToken;
    private String oAuthRequestTokenURL;
    private String oAuthAuthorizationURL;
    private String oAuthAccessTokenURL;
    private String oAuthAuthenticationURL;
    private String oAuth2TokenURL;
    private String oAuth2InvalidateTokenURL;
    private String restBaseURL;
    private String streamBaseURL;
    private String userStreamBaseURL;
    private String siteStreamBaseURL;
    private String dispatcherImpl;
    private String loggerFactory;
    private int asyncNumThreads;
    private long contributingTo;
    private boolean includeRTsEnabled = true;
    private boolean includeEntitiesEnabled = true;
    private boolean includeMyRetweetEnabled = true;
    private boolean trimUserEnabled = false;
    private boolean jsonStoreEnabled;
    private boolean mbeanEnabled;
    private boolean userStreamRepliesAllEnabled;
    private boolean stallWarningsEnabled;
    private boolean applicationOnlyAuthEnabled = false;
    private String mediaProvider;
    private String mediaProviderAPIKey;
    private Properties mediaProviderParameters;
    private String clientVersion;
    private String clientURL;
    public static final String DALVIK = "twitter4j.dalvik";
    public static final String GAE = "twitter4j.gae";
    private static final String DEFAULT_OAUTH_REQUEST_TOKEN_URL = "http://api.twitter.com/oauth/request_token";
    private static final String DEFAULT_OAUTH_AUTHORIZATION_URL = "http://api.twitter.com/oauth/authorize";
    private static final String DEFAULT_OAUTH_ACCESS_TOKEN_URL = "http://api.twitter.com/oauth/access_token";
    private static final String DEFAULT_OAUTH_AUTHENTICATION_URL = "http://api.twitter.com/oauth/authenticate";
    private static final String DEFAULT_OAUTH2_TOKEN_URL = "https://api.twitter.com/oauth2/token";
    private static final String DEFAULT_OAUTH2_INVALIDATE_TOKEN_URL = "https://api.twitter.com/oauth2/invalidate_token";
    private static final String DEFAULT_REST_BASE_URL = "http://api.twitter.com/1.1/";
    private static final String DEFAULT_STREAM_BASE_URL = "https://stream.twitter.com/1.1/";
    private static final String DEFAULT_USER_STREAM_BASE_URL = "https://userstream.twitter.com/1.1/";
    private static final String DEFAULT_SITE_STREAM_BASE_URL = "https://sitestream.twitter.com/1.1/";
    private boolean IS_DALVIK;
    private boolean IS_GAE;
    private static final long serialVersionUID = -6610497517837844232L;
    static String dalvikDetected;
    static String gaeDetected;
    Map<String, String> requestHeaders;
    private static final List<ConfigurationBase> instances;

    protected ConfigurationBase() {
        String isGAE;
        String isDalvik;
        this.setDebug(false);
        this.setUser(null);
        this.setPassword(null);
        this.setUseSSL(true);
        this.setPrettyDebugEnabled(false);
        this.setGZIPEnabled(true);
        this.setHttpProxyHost(null);
        this.setHttpProxyUser(null);
        this.setHttpProxyPassword(null);
        this.setHttpProxyPort(-1);
        this.setHttpConnectionTimeout(20000);
        this.setHttpReadTimeout(120000);
        this.setHttpStreamingReadTimeout(40000);
        this.setHttpRetryCount(0);
        this.setHttpRetryIntervalSeconds(5);
        this.setHttpMaxTotalConnections(20);
        this.setHttpDefaultMaxPerRoute(2);
        this.setOAuthConsumerKey(null);
        this.setOAuthConsumerSecret(null);
        this.setOAuthAccessToken(null);
        this.setOAuthAccessTokenSecret(null);
        this.setAsyncNumThreads(1);
        this.setContributingTo(-1L);
        this.setClientVersion(Version.getVersion());
        this.setClientURL("http://twitter4j.org/en/twitter4j-" + Version.getVersion() + ".xml");
        this.setUserAgent("twitter4j http://twitter4j.org/ /" + Version.getVersion());
        this.setJSONStoreEnabled(false);
        this.setMBeanEnabled(false);
        this.setOAuthRequestTokenURL(DEFAULT_OAUTH_REQUEST_TOKEN_URL);
        this.setOAuthAuthorizationURL(DEFAULT_OAUTH_AUTHORIZATION_URL);
        this.setOAuthAccessTokenURL(DEFAULT_OAUTH_ACCESS_TOKEN_URL);
        this.setOAuthAuthenticationURL(DEFAULT_OAUTH_AUTHENTICATION_URL);
        this.setOAuth2TokenURL(DEFAULT_OAUTH2_TOKEN_URL);
        this.setOAuth2InvalidateTokenURL(DEFAULT_OAUTH2_INVALIDATE_TOKEN_URL);
        this.setRestBaseURL(DEFAULT_REST_BASE_URL);
        this.setStreamBaseURL(DEFAULT_STREAM_BASE_URL);
        this.setUserStreamBaseURL(DEFAULT_USER_STREAM_BASE_URL);
        this.setSiteStreamBaseURL(DEFAULT_SITE_STREAM_BASE_URL);
        this.setDispatcherImpl("twitter4j.internal.async.DispatcherImpl");
        this.setLoggerFactory(null);
        this.setUserStreamRepliesAllEnabled(false);
        this.setStallWarningsEnabled(true);
        try {
            isDalvik = System.getProperty(DALVIK, dalvikDetected);
        }
        catch (SecurityException ignore) {
            isDalvik = dalvikDetected;
        }
        this.IS_DALVIK = Boolean.valueOf(isDalvik);
        try {
            isGAE = System.getProperty(GAE, gaeDetected);
        }
        catch (SecurityException ignore) {
            isGAE = gaeDetected;
        }
        this.IS_GAE = Boolean.valueOf(isGAE);
        this.setMediaProvider("TWITTER");
        this.setMediaProviderAPIKey(null);
        this.setMediaProviderParameters(null);
    }

    public void dumpConfiguration() {
        Logger log = Logger.getLogger(ConfigurationBase.class);
        if (this.debug) {
            Field[] fields;
            for (Field field : fields = ConfigurationBase.class.getDeclaredFields()) {
                try {
                    Object value = field.get(this);
                    String strValue = String.valueOf(value);
                    if (value != null && field.getName().matches("oAuthConsumerSecret|oAuthAccessTokenSecret|password")) {
                        strValue = z_T4JInternalStringUtil.maskString(String.valueOf(value));
                    }
                    log.debug(field.getName() + ": " + strValue);
                }
                catch (IllegalAccessException ignore) {
                    // empty catch block
                }
            }
        }
        if (!this.includeRTsEnabled) {
            log.warn("includeRTsEnabled is set to false. This configuration may not take effect after May 14th, 2012. https://dev.twitter.com/blog/api-housekeeping");
        }
        if (!this.includeEntitiesEnabled) {
            log.warn("includeEntitiesEnabled is set to false. This configuration may not take effect after May 14th, 2012. https://dev.twitter.com/blog/api-housekeeping");
        }
    }

    @Override
    public final boolean isDalvik() {
        return this.IS_DALVIK;
    }

    @Override
    public boolean isGAE() {
        return this.IS_GAE;
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.debug;
    }

    protected final void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public final String getUserAgent() {
        return this.userAgent;
    }

    protected final void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        this.initRequestHeaders();
    }

    @Override
    public final String getUser() {
        return this.user;
    }

    protected final void setUser(String user) {
        this.user = user;
    }

    @Override
    public final String getPassword() {
        return this.password;
    }

    protected final void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean isPrettyDebugEnabled() {
        return this.prettyDebug;
    }

    protected final void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
        this.fixRestBaseURL();
    }

    protected final void setPrettyDebugEnabled(boolean prettyDebug) {
        this.prettyDebug = prettyDebug;
    }

    protected final void setGZIPEnabled(boolean gzipEnabled) {
        this.gzipEnabled = gzipEnabled;
        this.initRequestHeaders();
    }

    @Override
    public boolean isGZIPEnabled() {
        return this.gzipEnabled;
    }

    private void initRequestHeaders() {
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("X-Twitter-Client-Version", this.getClientVersion());
        this.requestHeaders.put("X-Twitter-Client-URL", this.getClientURL());
        this.requestHeaders.put("X-Twitter-Client", "Twitter4J");
        this.requestHeaders.put("User-Agent", this.getUserAgent());
        if (this.gzipEnabled) {
            this.requestHeaders.put("Accept-Encoding", "gzip");
        }
        if (this.IS_DALVIK) {
            this.requestHeaders.put("Connection", "close");
        }
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public final String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    protected final void setHttpProxyHost(String proxyHost) {
        this.httpProxyHost = proxyHost;
    }

    @Override
    public final String getHttpProxyUser() {
        return this.httpProxyUser;
    }

    protected final void setHttpProxyUser(String proxyUser) {
        this.httpProxyUser = proxyUser;
    }

    @Override
    public final String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    protected final void setHttpProxyPassword(String proxyPassword) {
        this.httpProxyPassword = proxyPassword;
    }

    @Override
    public final int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    protected final void setHttpProxyPort(int proxyPort) {
        this.httpProxyPort = proxyPort;
    }

    @Override
    public final int getHttpConnectionTimeout() {
        return this.httpConnectionTimeout;
    }

    protected final void setHttpConnectionTimeout(int connectionTimeout) {
        this.httpConnectionTimeout = connectionTimeout;
    }

    @Override
    public final int getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    protected final void setHttpReadTimeout(int readTimeout) {
        this.httpReadTimeout = readTimeout;
    }

    @Override
    public int getHttpStreamingReadTimeout() {
        return this.httpStreamingReadTimeout;
    }

    protected final void setHttpStreamingReadTimeout(int httpStreamingReadTimeout) {
        this.httpStreamingReadTimeout = httpStreamingReadTimeout;
    }

    @Override
    public final int getHttpRetryCount() {
        return this.httpRetryCount;
    }

    protected final void setHttpRetryCount(int retryCount) {
        this.httpRetryCount = retryCount;
    }

    @Override
    public final int getHttpRetryIntervalSeconds() {
        return this.httpRetryIntervalSeconds;
    }

    protected final void setHttpRetryIntervalSeconds(int retryIntervalSeconds) {
        this.httpRetryIntervalSeconds = retryIntervalSeconds;
    }

    @Override
    public final int getHttpMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    protected final void setHttpMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    @Override
    public final int getHttpDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    protected final void setHttpDefaultMaxPerRoute(int defaultMaxPerRoute) {
        this.defaultMaxPerRoute = defaultMaxPerRoute;
    }

    @Override
    public final String getOAuthConsumerKey() {
        return this.oAuthConsumerKey;
    }

    protected final void setOAuthConsumerKey(String oAuthConsumerKey) {
        this.oAuthConsumerKey = oAuthConsumerKey;
        this.fixRestBaseURL();
    }

    @Override
    public final String getOAuthConsumerSecret() {
        return this.oAuthConsumerSecret;
    }

    protected final void setOAuthConsumerSecret(String oAuthConsumerSecret) {
        this.oAuthConsumerSecret = oAuthConsumerSecret;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuthAccessToken() {
        return this.oAuthAccessToken;
    }

    protected final void setOAuthAccessToken(String oAuthAccessToken) {
        this.oAuthAccessToken = oAuthAccessToken;
    }

    @Override
    public String getOAuthAccessTokenSecret() {
        return this.oAuthAccessTokenSecret;
    }

    protected final void setOAuthAccessTokenSecret(String oAuthAccessTokenSecret) {
        this.oAuthAccessTokenSecret = oAuthAccessTokenSecret;
    }

    @Override
    public String getOAuth2TokenType() {
        return this.oAuth2TokenType;
    }

    protected final void setOAuth2TokenType(String oAuth2TokenType) {
        this.oAuth2TokenType = oAuth2TokenType;
    }

    @Override
    public String getOAuth2AccessToken() {
        return this.oAuth2AccessToken;
    }

    protected final void setOAuth2AccessToken(String oAuth2AccessToken) {
        this.oAuth2AccessToken = oAuth2AccessToken;
    }

    @Override
    public final int getAsyncNumThreads() {
        return this.asyncNumThreads;
    }

    protected final void setAsyncNumThreads(int asyncNumThreads) {
        this.asyncNumThreads = asyncNumThreads;
    }

    @Override
    public final long getContributingTo() {
        return this.contributingTo;
    }

    protected final void setContributingTo(long contributingTo) {
        this.contributingTo = contributingTo;
    }

    @Override
    public final String getClientVersion() {
        return this.clientVersion;
    }

    protected final void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
        this.initRequestHeaders();
    }

    @Override
    public final String getClientURL() {
        return this.clientURL;
    }

    protected final void setClientURL(String clientURL) {
        this.clientURL = clientURL;
        this.initRequestHeaders();
    }

    @Override
    public String getRestBaseURL() {
        return this.restBaseURL;
    }

    protected final void setRestBaseURL(String restBaseURL) {
        this.restBaseURL = restBaseURL;
        this.fixRestBaseURL();
    }

    private void fixRestBaseURL() {
        if (DEFAULT_REST_BASE_URL.equals(ConfigurationBase.fixURL(false, this.restBaseURL))) {
            this.restBaseURL = ConfigurationBase.fixURL(this.useSSL, this.restBaseURL);
        }
        if (DEFAULT_OAUTH_ACCESS_TOKEN_URL.equals(ConfigurationBase.fixURL(false, this.oAuthAccessTokenURL))) {
            this.oAuthAccessTokenURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthAccessTokenURL);
        }
        if (DEFAULT_OAUTH_AUTHENTICATION_URL.equals(ConfigurationBase.fixURL(false, this.oAuthAuthenticationURL))) {
            this.oAuthAuthenticationURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthAuthenticationURL);
        }
        if (DEFAULT_OAUTH_AUTHORIZATION_URL.equals(ConfigurationBase.fixURL(false, this.oAuthAuthorizationURL))) {
            this.oAuthAuthorizationURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthAuthorizationURL);
        }
        if (DEFAULT_OAUTH_REQUEST_TOKEN_URL.equals(ConfigurationBase.fixURL(false, this.oAuthRequestTokenURL))) {
            this.oAuthRequestTokenURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthRequestTokenURL);
        }
    }

    @Override
    public String getStreamBaseURL() {
        return this.streamBaseURL;
    }

    protected final void setStreamBaseURL(String streamBaseURL) {
        this.streamBaseURL = streamBaseURL;
    }

    @Override
    public String getUserStreamBaseURL() {
        return this.userStreamBaseURL;
    }

    protected final void setUserStreamBaseURL(String siteStreamBaseURL) {
        this.userStreamBaseURL = siteStreamBaseURL;
    }

    @Override
    public String getSiteStreamBaseURL() {
        return this.siteStreamBaseURL;
    }

    protected final void setSiteStreamBaseURL(String siteStreamBaseURL) {
        this.siteStreamBaseURL = siteStreamBaseURL;
    }

    @Override
    public String getOAuthRequestTokenURL() {
        return this.oAuthRequestTokenURL;
    }

    protected final void setOAuthRequestTokenURL(String oAuthRequestTokenURL) {
        this.oAuthRequestTokenURL = oAuthRequestTokenURL;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuthAuthorizationURL() {
        return this.oAuthAuthorizationURL;
    }

    protected final void setOAuthAuthorizationURL(String oAuthAuthorizationURL) {
        this.oAuthAuthorizationURL = oAuthAuthorizationURL;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuthAccessTokenURL() {
        return this.oAuthAccessTokenURL;
    }

    protected final void setOAuthAccessTokenURL(String oAuthAccessTokenURL) {
        this.oAuthAccessTokenURL = oAuthAccessTokenURL;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuthAuthenticationURL() {
        return this.oAuthAuthenticationURL;
    }

    protected final void setOAuthAuthenticationURL(String oAuthAuthenticationURL) {
        this.oAuthAuthenticationURL = oAuthAuthenticationURL;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuth2TokenURL() {
        return this.oAuth2TokenURL;
    }

    protected final void setOAuth2TokenURL(String oAuth2TokenURL) {
        this.oAuth2TokenURL = oAuth2TokenURL;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuth2InvalidateTokenURL() {
        return this.oAuth2InvalidateTokenURL;
    }

    protected final void setOAuth2InvalidateTokenURL(String oAuth2InvalidateTokenURL) {
        this.oAuth2InvalidateTokenURL = oAuth2InvalidateTokenURL;
        this.fixRestBaseURL();
    }

    @Override
    public String getDispatcherImpl() {
        return this.dispatcherImpl;
    }

    protected final void setDispatcherImpl(String dispatcherImpl) {
        this.dispatcherImpl = dispatcherImpl;
    }

    @Override
    public String getLoggerFactory() {
        return this.loggerFactory;
    }

    @Override
    public boolean isIncludeRTsEnabled() {
        return this.includeRTsEnabled;
    }

    @Override
    public boolean isIncludeEntitiesEnabled() {
        return this.includeEntitiesEnabled;
    }

    protected final void setLoggerFactory(String loggerImpl) {
        this.loggerFactory = loggerImpl;
    }

    protected final void setIncludeRTsEnbled(boolean enabled) {
        this.includeRTsEnabled = enabled;
    }

    protected final void setIncludeEntitiesEnbled(boolean enabled) {
        this.includeEntitiesEnabled = enabled;
    }

    @Override
    public boolean isIncludeMyRetweetEnabled() {
        return this.includeMyRetweetEnabled;
    }

    public void setIncludeMyRetweetEnabled(boolean enabled) {
        this.includeMyRetweetEnabled = enabled;
    }

    @Override
    public boolean isTrimUserEnabled() {
        return this.trimUserEnabled;
    }

    public void setTrimUserEnabled(boolean enabled) {
        this.trimUserEnabled = enabled;
    }

    @Override
    public boolean isJSONStoreEnabled() {
        return this.jsonStoreEnabled;
    }

    protected final void setJSONStoreEnabled(boolean enabled) {
        this.jsonStoreEnabled = enabled;
    }

    @Override
    public boolean isMBeanEnabled() {
        return this.mbeanEnabled;
    }

    protected final void setMBeanEnabled(boolean enabled) {
        this.mbeanEnabled = enabled;
    }

    @Override
    public boolean isUserStreamRepliesAllEnabled() {
        return this.userStreamRepliesAllEnabled;
    }

    protected final void setUserStreamRepliesAllEnabled(boolean enabled) {
        this.userStreamRepliesAllEnabled = enabled;
    }

    @Override
    public boolean isStallWarningsEnabled() {
        return this.stallWarningsEnabled;
    }

    protected final void setStallWarningsEnabled(boolean stallWarningsEnabled) {
        this.stallWarningsEnabled = stallWarningsEnabled;
    }

    @Override
    public boolean isApplicationOnlyAuthEnabled() {
        return this.applicationOnlyAuthEnabled;
    }

    protected final void setApplicationOnlyAuthEnabled(boolean applicationOnlyAuthEnabled) {
        this.applicationOnlyAuthEnabled = applicationOnlyAuthEnabled;
    }

    @Override
    public String getMediaProvider() {
        return this.mediaProvider;
    }

    protected final void setMediaProvider(String mediaProvider) {
        this.mediaProvider = mediaProvider;
    }

    @Override
    public String getMediaProviderAPIKey() {
        return this.mediaProviderAPIKey;
    }

    protected final void setMediaProviderAPIKey(String mediaProviderAPIKey) {
        this.mediaProviderAPIKey = mediaProviderAPIKey;
    }

    @Override
    public Properties getMediaProviderParameters() {
        return this.mediaProviderParameters;
    }

    protected final void setMediaProviderParameters(Properties props) {
        this.mediaProviderParameters = props;
    }

    static String fixURL(boolean useSSL, String url) {
        if (null == url) {
            return null;
        }
        int index = url.indexOf("://");
        if (-1 == index) {
            throw new IllegalArgumentException("url should contain '://'");
        }
        String hostAndLater = url.substring(index + 3);
        if (useSSL) {
            return "https://" + hostAndLater;
        }
        return "http://" + hostAndLater;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationBase that = (ConfigurationBase)o;
        if (this.IS_DALVIK != that.IS_DALVIK) {
            return false;
        }
        if (this.IS_GAE != that.IS_GAE) {
            return false;
        }
        if (this.asyncNumThreads != that.asyncNumThreads) {
            return false;
        }
        if (this.contributingTo != that.contributingTo) {
            return false;
        }
        if (this.debug != that.debug) {
            return false;
        }
        if (this.defaultMaxPerRoute != that.defaultMaxPerRoute) {
            return false;
        }
        if (this.gzipEnabled != that.gzipEnabled) {
            return false;
        }
        if (this.httpConnectionTimeout != that.httpConnectionTimeout) {
            return false;
        }
        if (this.httpProxyPort != that.httpProxyPort) {
            return false;
        }
        if (this.httpReadTimeout != that.httpReadTimeout) {
            return false;
        }
        if (this.httpRetryCount != that.httpRetryCount) {
            return false;
        }
        if (this.httpRetryIntervalSeconds != that.httpRetryIntervalSeconds) {
            return false;
        }
        if (this.httpStreamingReadTimeout != that.httpStreamingReadTimeout) {
            return false;
        }
        if (this.includeEntitiesEnabled != that.includeEntitiesEnabled) {
            return false;
        }
        if (this.includeMyRetweetEnabled != that.includeMyRetweetEnabled) {
            return false;
        }
        if (this.trimUserEnabled != that.trimUserEnabled) {
            return false;
        }
        if (this.includeRTsEnabled != that.includeRTsEnabled) {
            return false;
        }
        if (this.jsonStoreEnabled != that.jsonStoreEnabled) {
            return false;
        }
        if (this.maxTotalConnections != that.maxTotalConnections) {
            return false;
        }
        if (this.mbeanEnabled != that.mbeanEnabled) {
            return false;
        }
        if (this.prettyDebug != that.prettyDebug) {
            return false;
        }
        if (this.stallWarningsEnabled != that.stallWarningsEnabled) {
            return false;
        }
        if (this.applicationOnlyAuthEnabled != that.applicationOnlyAuthEnabled) {
            return false;
        }
        if (this.useSSL != that.useSSL) {
            return false;
        }
        if (this.userStreamRepliesAllEnabled != that.userStreamRepliesAllEnabled) {
            return false;
        }
        if (this.clientURL != null ? !this.clientURL.equals(that.clientURL) : that.clientURL != null) {
            return false;
        }
        if (this.clientVersion != null ? !this.clientVersion.equals(that.clientVersion) : that.clientVersion != null) {
            return false;
        }
        if (this.dispatcherImpl != null ? !this.dispatcherImpl.equals(that.dispatcherImpl) : that.dispatcherImpl != null) {
            return false;
        }
        if (this.httpProxyHost != null ? !this.httpProxyHost.equals(that.httpProxyHost) : that.httpProxyHost != null) {
            return false;
        }
        if (this.httpProxyPassword != null ? !this.httpProxyPassword.equals(that.httpProxyPassword) : that.httpProxyPassword != null) {
            return false;
        }
        if (this.httpProxyUser != null ? !this.httpProxyUser.equals(that.httpProxyUser) : that.httpProxyUser != null) {
            return false;
        }
        if (this.loggerFactory != null ? !this.loggerFactory.equals(that.loggerFactory) : that.loggerFactory != null) {
            return false;
        }
        if (this.mediaProvider != null ? !this.mediaProvider.equals(that.mediaProvider) : that.mediaProvider != null) {
            return false;
        }
        if (this.mediaProviderAPIKey != null ? !this.mediaProviderAPIKey.equals(that.mediaProviderAPIKey) : that.mediaProviderAPIKey != null) {
            return false;
        }
        if (this.mediaProviderParameters != null ? !this.mediaProviderParameters.equals(that.mediaProviderParameters) : that.mediaProviderParameters != null) {
            return false;
        }
        if (this.oAuthAccessToken != null ? !this.oAuthAccessToken.equals(that.oAuthAccessToken) : that.oAuthAccessToken != null) {
            return false;
        }
        if (this.oAuthAccessTokenSecret != null ? !this.oAuthAccessTokenSecret.equals(that.oAuthAccessTokenSecret) : that.oAuthAccessTokenSecret != null) {
            return false;
        }
        if (this.oAuth2TokenType != null ? !this.oAuth2TokenType.equals(that.oAuth2TokenType) : that.oAuth2TokenType != null) {
            return false;
        }
        if (this.oAuth2AccessToken != null ? !this.oAuth2AccessToken.equals(that.oAuth2AccessToken) : that.oAuth2AccessToken != null) {
            return false;
        }
        if (this.oAuthAccessTokenURL != null ? !this.oAuthAccessTokenURL.equals(that.oAuthAccessTokenURL) : that.oAuthAccessTokenURL != null) {
            return false;
        }
        if (this.oAuthAuthenticationURL != null ? !this.oAuthAuthenticationURL.equals(that.oAuthAuthenticationURL) : that.oAuthAuthenticationURL != null) {
            return false;
        }
        if (this.oAuthAuthorizationURL != null ? !this.oAuthAuthorizationURL.equals(that.oAuthAuthorizationURL) : that.oAuthAuthorizationURL != null) {
            return false;
        }
        if (this.oAuth2TokenURL != null ? !this.oAuth2TokenURL.equals(that.oAuth2TokenURL) : that.oAuth2TokenURL != null) {
            return false;
        }
        if (this.oAuth2InvalidateTokenURL != null ? !this.oAuth2InvalidateTokenURL.equals(that.oAuth2InvalidateTokenURL) : that.oAuth2InvalidateTokenURL != null) {
            return false;
        }
        if (this.oAuthConsumerKey != null ? !this.oAuthConsumerKey.equals(that.oAuthConsumerKey) : that.oAuthConsumerKey != null) {
            return false;
        }
        if (this.oAuthConsumerSecret != null ? !this.oAuthConsumerSecret.equals(that.oAuthConsumerSecret) : that.oAuthConsumerSecret != null) {
            return false;
        }
        if (this.oAuthRequestTokenURL != null ? !this.oAuthRequestTokenURL.equals(that.oAuthRequestTokenURL) : that.oAuthRequestTokenURL != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.requestHeaders != null ? !this.requestHeaders.equals(that.requestHeaders) : that.requestHeaders != null) {
            return false;
        }
        if (this.restBaseURL != null ? !this.restBaseURL.equals(that.restBaseURL) : that.restBaseURL != null) {
            return false;
        }
        if (this.siteStreamBaseURL != null ? !this.siteStreamBaseURL.equals(that.siteStreamBaseURL) : that.siteStreamBaseURL != null) {
            return false;
        }
        if (this.streamBaseURL != null ? !this.streamBaseURL.equals(that.streamBaseURL) : that.streamBaseURL != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        if (this.userAgent != null ? !this.userAgent.equals(that.userAgent) : that.userAgent != null) {
            return false;
        }
        return !(this.userStreamBaseURL != null ? !this.userStreamBaseURL.equals(that.userStreamBaseURL) : that.userStreamBaseURL != null);
    }

    public int hashCode() {
        int result = this.debug ? 1 : 0;
        result = 31 * result + (this.userAgent != null ? this.userAgent.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.useSSL ? 1 : 0);
        result = 31 * result + (this.prettyDebug ? 1 : 0);
        result = 31 * result + (this.gzipEnabled ? 1 : 0);
        result = 31 * result + (this.httpProxyHost != null ? this.httpProxyHost.hashCode() : 0);
        result = 31 * result + (this.httpProxyUser != null ? this.httpProxyUser.hashCode() : 0);
        result = 31 * result + (this.httpProxyPassword != null ? this.httpProxyPassword.hashCode() : 0);
        result = 31 * result + this.httpProxyPort;
        result = 31 * result + this.httpConnectionTimeout;
        result = 31 * result + this.httpReadTimeout;
        result = 31 * result + this.httpStreamingReadTimeout;
        result = 31 * result + this.httpRetryCount;
        result = 31 * result + this.httpRetryIntervalSeconds;
        result = 31 * result + this.maxTotalConnections;
        result = 31 * result + this.defaultMaxPerRoute;
        result = 31 * result + (this.oAuthConsumerKey != null ? this.oAuthConsumerKey.hashCode() : 0);
        result = 31 * result + (this.oAuthConsumerSecret != null ? this.oAuthConsumerSecret.hashCode() : 0);
        result = 31 * result + (this.oAuthAccessToken != null ? this.oAuthAccessToken.hashCode() : 0);
        result = 31 * result + (this.oAuthAccessTokenSecret != null ? this.oAuthAccessTokenSecret.hashCode() : 0);
        result = 31 * result + (this.oAuth2TokenType != null ? this.oAuth2TokenType.hashCode() : 0);
        result = 31 * result + (this.oAuth2AccessToken != null ? this.oAuth2AccessToken.hashCode() : 0);
        result = 31 * result + (this.oAuthRequestTokenURL != null ? this.oAuthRequestTokenURL.hashCode() : 0);
        result = 31 * result + (this.oAuthAuthorizationURL != null ? this.oAuthAuthorizationURL.hashCode() : 0);
        result = 31 * result + (this.oAuthAccessTokenURL != null ? this.oAuthAccessTokenURL.hashCode() : 0);
        result = 31 * result + (this.oAuthAuthenticationURL != null ? this.oAuthAuthenticationURL.hashCode() : 0);
        result = 31 * result + (this.oAuth2TokenURL != null ? this.oAuth2TokenURL.hashCode() : 0);
        result = 31 * result + (this.oAuth2InvalidateTokenURL != null ? this.oAuth2InvalidateTokenURL.hashCode() : 0);
        result = 31 * result + (this.restBaseURL != null ? this.restBaseURL.hashCode() : 0);
        result = 31 * result + (this.streamBaseURL != null ? this.streamBaseURL.hashCode() : 0);
        result = 31 * result + (this.userStreamBaseURL != null ? this.userStreamBaseURL.hashCode() : 0);
        result = 31 * result + (this.siteStreamBaseURL != null ? this.siteStreamBaseURL.hashCode() : 0);
        result = 31 * result + (this.dispatcherImpl != null ? this.dispatcherImpl.hashCode() : 0);
        result = 31 * result + (this.loggerFactory != null ? this.loggerFactory.hashCode() : 0);
        result = 31 * result + this.asyncNumThreads;
        result = 31 * result + (int)(this.contributingTo ^ this.contributingTo >>> 32);
        result = 31 * result + (this.includeRTsEnabled ? 1 : 0);
        result = 31 * result + (this.includeEntitiesEnabled ? 1 : 0);
        result = 31 * result + (this.includeMyRetweetEnabled ? 1 : 0);
        result = 31 * result + (this.trimUserEnabled ? 1 : 0);
        result = 31 * result + (this.jsonStoreEnabled ? 1 : 0);
        result = 31 * result + (this.mbeanEnabled ? 1 : 0);
        result = 31 * result + (this.userStreamRepliesAllEnabled ? 1 : 0);
        result = 31 * result + (this.stallWarningsEnabled ? 1 : 0);
        result = 31 * result + (this.applicationOnlyAuthEnabled ? 1 : 0);
        result = 31 * result + (this.mediaProvider != null ? this.mediaProvider.hashCode() : 0);
        result = 31 * result + (this.mediaProviderAPIKey != null ? this.mediaProviderAPIKey.hashCode() : 0);
        result = 31 * result + (this.mediaProviderParameters != null ? this.mediaProviderParameters.hashCode() : 0);
        result = 31 * result + (this.clientVersion != null ? this.clientVersion.hashCode() : 0);
        result = 31 * result + (this.clientURL != null ? this.clientURL.hashCode() : 0);
        result = 31 * result + (this.IS_DALVIK ? 1 : 0);
        result = 31 * result + (this.IS_GAE ? 1 : 0);
        result = 31 * result + (this.requestHeaders != null ? this.requestHeaders.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ConfigurationBase{debug=" + this.debug + ", userAgent='" + this.userAgent + '\'' + ", user='" + this.user + '\'' + ", password='" + this.password + '\'' + ", useSSL=" + this.useSSL + ", prettyDebug=" + this.prettyDebug + ", gzipEnabled=" + this.gzipEnabled + ", httpProxyHost='" + this.httpProxyHost + '\'' + ", httpProxyUser='" + this.httpProxyUser + '\'' + ", httpProxyPassword='" + this.httpProxyPassword + '\'' + ", httpProxyPort=" + this.httpProxyPort + ", httpConnectionTimeout=" + this.httpConnectionTimeout + ", httpReadTimeout=" + this.httpReadTimeout + ", httpStreamingReadTimeout=" + this.httpStreamingReadTimeout + ", httpRetryCount=" + this.httpRetryCount + ", httpRetryIntervalSeconds=" + this.httpRetryIntervalSeconds + ", maxTotalConnections=" + this.maxTotalConnections + ", defaultMaxPerRoute=" + this.defaultMaxPerRoute + ", oAuthConsumerKey='" + this.oAuthConsumerKey + '\'' + ", oAuthConsumerSecret='" + this.oAuthConsumerSecret + '\'' + ", oAuthAccessToken='" + this.oAuthAccessToken + '\'' + ", oAuthAccessTokenSecret='" + this.oAuthAccessTokenSecret + '\'' + ", oAuth2TokenType='" + this.oAuth2TokenType + '\'' + ", oAuth2AccessToken='" + this.oAuth2AccessToken + '\'' + ", oAuthRequestTokenURL='" + this.oAuthRequestTokenURL + '\'' + ", oAuthAuthorizationURL='" + this.oAuthAuthorizationURL + '\'' + ", oAuthAccessTokenURL='" + this.oAuthAccessTokenURL + '\'' + ", oAuthAuthenticationURL='" + this.oAuthAuthenticationURL + '\'' + ", oAuth2TokenURL='" + this.oAuth2TokenURL + '\'' + ", oAuth2InvalidateTokenURL='" + this.oAuth2InvalidateTokenURL + '\'' + ", restBaseURL='" + this.restBaseURL + '\'' + ", streamBaseURL='" + this.streamBaseURL + '\'' + ", userStreamBaseURL='" + this.userStreamBaseURL + '\'' + ", siteStreamBaseURL='" + this.siteStreamBaseURL + '\'' + ", dispatcherImpl='" + this.dispatcherImpl + '\'' + ", loggerFactory='" + this.loggerFactory + '\'' + ", asyncNumThreads=" + this.asyncNumThreads + ", contributingTo=" + this.contributingTo + ", includeRTsEnabled=" + this.includeRTsEnabled + ", includeEntitiesEnabled=" + this.includeEntitiesEnabled + ", includeMyRetweetEnabled=" + this.includeMyRetweetEnabled + ", trimUserEnabled=" + this.trimUserEnabled + ", jsonStoreEnabled=" + this.jsonStoreEnabled + ", mbeanEnabled=" + this.mbeanEnabled + ", userStreamRepliesAllEnabled=" + this.userStreamRepliesAllEnabled + ", stallWarningsEnabled=" + this.stallWarningsEnabled + ", applicationOnlyAuthEnabled=" + this.applicationOnlyAuthEnabled + ", mediaProvider='" + this.mediaProvider + '\'' + ", mediaProviderAPIKey='" + this.mediaProviderAPIKey + '\'' + ", mediaProviderParameters=" + this.mediaProviderParameters + ", clientVersion='" + this.clientVersion + '\'' + ", clientURL='" + this.clientURL + '\'' + ", IS_DALVIK=" + this.IS_DALVIK + ", IS_GAE=" + this.IS_GAE + ", requestHeaders=" + this.requestHeaders + '}';
    }

    private static void cacheInstance(ConfigurationBase conf) {
        if (!instances.contains(conf)) {
            instances.add(conf);
        }
    }

    protected void cacheInstance() {
        ConfigurationBase.cacheInstance(this);
    }

    private static ConfigurationBase getInstance(ConfigurationBase configurationBase) {
        int index = instances.indexOf(configurationBase);
        if (index == -1) {
            instances.add(configurationBase);
            return configurationBase;
        }
        return instances.get(index);
    }

    protected Object readResolve() throws ObjectStreamException {
        return ConfigurationBase.getInstance(this);
    }

    static {
        try {
            Class.forName("dalvik.system.VMRuntime");
            dalvikDetected = "true";
        }
        catch (ClassNotFoundException cnfe) {
            dalvikDetected = "false";
        }
        try {
            Class.forName("com.google.appengine.api.urlfetch.URLFetchService");
            gaeDetected = "true";
        }
        catch (ClassNotFoundException cnfe) {
            gaeDetected = "false";
        }
        instances = new ArrayList<ConfigurationBase>();
    }
}

