/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.support;

import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.InitializationContext;

public abstract class DelegatingCacheLoader
implements CacheLoader {
    protected CacheLoader actual;
    protected InitializationContext ctx;

    @Override
    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        if (this.actual instanceof DelegatingCacheLoader) {
            this.actual.init(ctx);
        }
    }

    @Override
    public void start() {
        if (this.actual instanceof DelegatingCacheLoader) {
            this.actual.start();
        }
    }

    @Override
    public void stop() {
        if (this.actual instanceof DelegatingCacheLoader) {
            this.actual.stop();
        }
    }

    protected DelegatingCacheLoader(CacheLoader actual) {
        this.actual = actual;
    }

    public boolean contains(Object key) {
        return this.actual != null && this.actual.contains(key);
    }

    public MarshalledEntry load(Object key) {
        return this.actual != null ? this.actual.load(key) : null;
    }

    public CacheLoader undelegate() {
        CacheLoader cl = this;
        while ((cl = cl.actual) instanceof DelegatingCacheLoader) {
        }
        return cl;
    }
}

