/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.handler;

import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.picketlink.common.random.DefaultSecureRandomProvider;
import org.picketlink.common.random.SecureRandomProvider;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.credential.encoder.PasswordEncoder;
import org.picketlink.idm.credential.encoder.SHAPasswordEncoder;
import org.picketlink.idm.credential.handler.AbstractCredentialHandler;
import org.picketlink.idm.credential.handler.annotations.SupportsCredentials;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.credential.storage.EncodedPasswordStorage;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;

@SupportsCredentials(credentialClass={UsernamePasswordCredentials.class, Password.class}, credentialStorage=EncodedPasswordStorage.class)
public class PasswordCredentialHandler<S extends CredentialStore<?>, V extends UsernamePasswordCredentials, U extends Password>
extends AbstractCredentialHandler<S, V, U> {
    private static final String DEFAULT_SALT_ALGORITHM = "SHA1PRNG";
    public static final String PASSWORD_ENCODER = "PASSWORD_ENCODER";
    public static final String SECURE_RANDOM_PROVIDER = "SECURE_RANDOM_PROVIDER";
    public static final String RENEW_RANDOM_NUMBER_GENERATOR_INTERVAL = "RENEW_RANDOM_NUMBER_GENERATOR_INTERVAL";
    public static final String ALGORITHM_RANDOM_NUMBER = "ALGORITHM_RANDOM_NUMBER";
    public static final String KEY_LENGTH_RANDOM_NUMBER = "KEY_LENGTH_RANDOM_NUMBER";
    private PasswordEncoder passwordEncoder = new SHAPasswordEncoder(512);
    private final Lock lock = new ReentrantLock();
    private Integer renewRandomNumberGeneratorInterval = -1;
    private AtomicLong lastRenewTime = new AtomicLong();
    private SecureRandomProvider secureRandomProvider;
    private SecureRandom secureRandom;

    @Override
    public void setup(S store) {
        super.setup(store);
        Map<String, Object> options = store.getConfig().getCredentialHandlerProperties();
        if (options != null) {
            Object secureRandomProvider;
            Object renewRandomNumberGeneratorInterval;
            Object providedEncoder = options.get(PASSWORD_ENCODER);
            if (providedEncoder != null) {
                if (PasswordEncoder.class.isInstance(providedEncoder)) {
                    this.passwordEncoder = (PasswordEncoder)providedEncoder;
                } else {
                    throw new SecurityConfigurationException("The password encoder [" + providedEncoder + "] must be an instance of " + PasswordEncoder.class.getName());
                }
            }
            if ((renewRandomNumberGeneratorInterval = options.get(RENEW_RANDOM_NUMBER_GENERATOR_INTERVAL)) != null) {
                this.renewRandomNumberGeneratorInterval = Integer.valueOf(renewRandomNumberGeneratorInterval.toString());
            }
            if ((secureRandomProvider = options.get(SECURE_RANDOM_PROVIDER)) != null) {
                this.secureRandomProvider = (SecureRandomProvider)secureRandomProvider;
            } else {
                Object keyLengthRandomNumber;
                Object saltAlgorithm = options.get(ALGORITHM_RANDOM_NUMBER);
                if (saltAlgorithm == null) {
                    saltAlgorithm = DEFAULT_SALT_ALGORITHM;
                }
                if ((keyLengthRandomNumber = options.get(KEY_LENGTH_RANDOM_NUMBER)) == null) {
                    keyLengthRandomNumber = 0;
                }
                this.secureRandomProvider = new DefaultSecureRandomProvider(saltAlgorithm.toString(), Integer.valueOf(keyLengthRandomNumber.toString()).intValue());
            }
        }
        this.secureRandom = this.createSecureRandom();
    }

    @Override
    protected Account getAccount(IdentityContext context, V credentials) {
        return this.getAccount(context, (V)((UsernamePasswordCredentials)credentials).getUsername());
    }

    @Override
    protected CredentialStorage getCredentialStorage(IdentityContext context, Account account, V credentials, S store) {
        return store.retrieveCurrentCredential(context, account, EncodedPasswordStorage.class);
    }

    @Override
    protected boolean validateCredential(IdentityContext context, CredentialStorage storage, V credentials) {
        EncodedPasswordStorage hash = (EncodedPasswordStorage)storage;
        if (hash != null) {
            String rawPassword = new String(((UsernamePasswordCredentials)credentials).getPassword().getValue());
            return this.passwordEncoder.verify(this.saltPassword(rawPassword, hash.getSalt()), hash.getEncodedHash());
        }
        return false;
    }

    @Override
    public void update(IdentityContext context, Account account, U password, S store, Date effectiveDate, Date expiryDate) {
        EncodedPasswordStorage hash = new EncodedPasswordStorage();
        if (((Password)password).getValue() == null || StringUtil.isNullOrEmpty((String)((Password)password).getValue().toString())) {
            throw IDMMessages.MESSAGES.credentialInvalidPassword();
        }
        String rawPassword = new String(((Password)password).getValue());
        String passwordSalt = this.generateSalt();
        hash.setSalt(passwordSalt);
        hash.setEncodedHash(this.passwordEncoder.encode(this.saltPassword(rawPassword, passwordSalt)));
        if (effectiveDate != null) {
            hash.setEffectiveDate(effectiveDate);
        }
        hash.setExpiryDate(expiryDate);
        store.storeCredential(context, account, hash);
    }

    protected SecureRandomProvider getSecureRandomProvider() {
        return this.secureRandomProvider;
    }

    private String saltPassword(String rawPassword, String salt) {
        return salt + rawPassword;
    }

    private String generateSalt() {
        return String.valueOf(this.getSecureRandom().nextLong());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renewSecureRandom() {
        if (this.isSecureRandomOutDated() && this.lock.tryLock()) {
            try {
                this.lastRenewTime.set(new Date().getTime());
                this.secureRandom = this.createSecureRandom();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private SecureRandom createSecureRandom() {
        try {
            return this.getSecureRandomProvider().getSecureRandom();
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error getting SecureRandom instance from provider [" + this.secureRandomProvider + "].", e);
        }
    }

    private SecureRandom getSecureRandom() {
        this.renewSecureRandom();
        return this.secureRandom;
    }

    private boolean isSecureRandomOutDated() {
        if (this.renewRandomNumberGeneratorInterval == -1) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(this.lastRenewTime.get()));
        calendar.add(14, this.renewRandomNumberGeneratorInterval);
        return calendar.getTime().compareTo(new Date()) <= 0;
    }
}

