/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.FMParserConstants;
import freemarker.core.MessageUtil;
import freemarker.core.TemplateObject;
import freemarker.core.Token;
import freemarker.template.Template;
import freemarker.template.utility.SecurityUtilities;
import freemarker.template.utility.StringUtil;
import java.io.IOException;

public class ParseException
extends IOException
implements FMParserConstants {
    public Token currentToken;
    private static volatile Boolean jbossToolsMode;
    private boolean messageAndDescriptionRendered;
    private String message;
    private String description;
    public int columnNumber;
    public int lineNumber;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = SecurityUtilities.getSystemProperty("line.separator", "\n");
    protected boolean specialConstructor;
    private final Throwable cause;
    private String templateName;
    static /* synthetic */ Class class$freemarker$core$ParseException;

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.cause = null;
        this.currentToken = currentTokenVal;
        this.specialConstructor = true;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
        this.lineNumber = this.currentToken.next.beginLine;
        this.columnNumber = this.currentToken.next.beginColumn;
    }

    protected ParseException() {
        this.cause = null;
    }

    public ParseException(String description, int lineNumber, int columnNumber) {
        this(description, (Template)null, lineNumber, columnNumber, null);
    }

    public ParseException(String description, Template template, int lineNumber, int columnNumber) {
        this(description, template, lineNumber, columnNumber, null);
    }

    public ParseException(String description, Template template, int lineNumber, int columnNumber, Throwable cause) {
        this(description, template == null ? null : template.getName(), lineNumber, columnNumber, cause);
    }

    public ParseException(String description, Template template, Token tk) {
        this(description, template, tk, null);
    }

    public ParseException(String description, Template template, Token tk, Throwable cause) {
        this(description, template == null ? null : template.getName(), tk.beginLine, tk.beginColumn, cause);
    }

    public ParseException(String description, TemplateObject tobj) {
        this(description, tobj, null);
    }

    public ParseException(String description, TemplateObject tobj, Throwable cause) {
        this(description, tobj.getTemplate() == null ? null : tobj.getTemplate().getName(), tobj.beginLine, tobj.beginColumn, cause);
    }

    private ParseException(String description, String templateName, int lineNumber, int columnNumber, Throwable cause) {
        super(description);
        this.cause = cause;
        this.description = description;
        this.templateName = templateName;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
        ParseException parseException = this;
        synchronized (parseException) {
            this.messageAndDescriptionRendered = false;
            this.message = null;
        }
    }

    public Throwable getCause() {
        return this.cause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage() {
        ParseException parseException = this;
        synchronized (parseException) {
            if (this.messageAndDescriptionRendered) {
                return this.message;
            }
        }
        this.renderMessageAndDescription();
        parseException = this;
        synchronized (parseException) {
            return this.message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDescription() {
        ParseException parseException = this;
        synchronized (parseException) {
            if (this.messageAndDescriptionRendered) {
                return this.description;
            }
        }
        this.renderMessageAndDescription();
        parseException = this;
        synchronized (parseException) {
            return this.description;
        }
    }

    public String getEditorMessage() {
        return this.getDescription();
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderMessageAndDescription() {
        String desc = this.getOrRenderDescription();
        String prefix = !this.isInJBossToolsMode() ? "Parsing error " + MessageUtil.formatLocationForSimpleParsingError(this.templateName, this.lineNumber, this.columnNumber) + ":\n" : "[col. " + this.columnNumber + "] ";
        String msg = prefix + desc;
        desc = msg.substring(prefix.length());
        ParseException parseException = this;
        synchronized (parseException) {
            this.message = msg;
            this.description = desc;
            this.messageAndDescriptionRendered = true;
        }
    }

    private boolean isInJBossToolsMode() {
        if (jbossToolsMode == null) {
            try {
                jbossToolsMode = (class$freemarker$core$ParseException == null ? (class$freemarker$core$ParseException = ParseException.class$("freemarker.core.ParseException")) : class$freemarker$core$ParseException).getClassLoader().toString().indexOf("[org.jboss.ide.eclipse.freemarker:") != -1 ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (Throwable e) {
                jbossToolsMode = Boolean.FALSE;
            }
        }
        return jbossToolsMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOrRenderDescription() {
        String tokenErrDesc;
        ParseException parseException = this;
        synchronized (parseException) {
            if (this.description != null) {
                return this.description;
            }
        }
        if (this.currentToken != null) {
            tokenErrDesc = this.getCustomTokenErrorDescription();
            if (tokenErrDesc == null) {
                StringBuffer expected = new StringBuffer();
                int maxSize = 0;
                for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
                    if (i != 0) {
                        expected.append(this.eol);
                    }
                    expected.append("    ");
                    if (maxSize < this.expectedTokenSequences[i].length) {
                        maxSize = this.expectedTokenSequences[i].length;
                    }
                    for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                        if (j != 0) {
                            expected.append(' ');
                        }
                        expected.append(this.tokenImage[this.expectedTokenSequences[i][j]]);
                    }
                }
                tokenErrDesc = "Encountered \"";
                Token tok = this.currentToken.next;
                for (int i = 0; i < maxSize; ++i) {
                    if (i != 0) {
                        tokenErrDesc = tokenErrDesc + " ";
                    }
                    if (tok.kind == 0) {
                        tokenErrDesc = tokenErrDesc + this.tokenImage[0];
                        break;
                    }
                    tokenErrDesc = tokenErrDesc + this.add_escapes(tok.image);
                    tok = tok.next;
                }
                tokenErrDesc = tokenErrDesc + "\", but ";
                tokenErrDesc = this.expectedTokenSequences.length == 1 ? tokenErrDesc + "was expecting:" + this.eol : tokenErrDesc + "was expecting one of:" + this.eol;
                tokenErrDesc = tokenErrDesc + expected;
            }
        } else {
            tokenErrDesc = null;
        }
        return tokenErrDesc;
    }

    private String getCustomTokenErrorDescription() {
        Token nextToken = this.currentToken.next;
        int kind = nextToken.kind;
        if (kind == 0) {
            for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
                String name;
                int[] sequence = this.expectedTokenSequences[i];
                switch (sequence[0]) {
                    case 35: {
                        name = "#foreach";
                        break;
                    }
                    case 32: {
                        name = "#list";
                        break;
                    }
                    case 43: {
                        name = "#switch";
                        break;
                    }
                    case 31: {
                        name = "#if";
                        break;
                    }
                    case 41: {
                        name = "#compress";
                        break;
                    }
                    case 39: 
                    case 40: {
                        name = "#macro or #function";
                        break;
                    }
                    case 42: {
                        name = "#transform";
                        break;
                    }
                    case 60: {
                        name = "#escape";
                        break;
                    }
                    case 62: {
                        name = "#noescape";
                        break;
                    }
                    case 38: {
                        name = "#assign";
                        break;
                    }
                    case 36: {
                        name = "#local";
                        break;
                    }
                    case 37: {
                        name = "#global";
                        break;
                    }
                    case 34: {
                        name = "#attempt";
                        break;
                    }
                    case 116: {
                        name = "{";
                        break;
                    }
                    case 112: {
                        name = "[";
                        break;
                    }
                    case 114: {
                        name = "(";
                        break;
                    }
                    case 64: {
                        name = "@...";
                        break;
                    }
                    default: {
                        name = null;
                    }
                }
                if (name == null) continue;
                if (!name.startsWith("#") && !name.startsWith("@")) {
                    name = StringUtil.jQuote(name);
                }
                return "Unclosed " + name + " when the end of the file was reached.";
            }
            return "Unexpected end of file reached.";
        }
        if (kind == 31 || kind == 9 || kind == 44) {
            return "Unexpected directive, " + StringUtil.jQuote(nextToken) + ". Check whether you have a valid #if-#elseif-#else structure.";
        }
        return null;
    }

    protected String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

