/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.claims;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.IdentityMapper;
import org.apache.cxf.sts.claims.Claim;
import org.apache.cxf.sts.claims.ClaimCollection;
import org.apache.cxf.sts.claims.ClaimsHandler;
import org.apache.cxf.sts.claims.ClaimsMapper;
import org.apache.cxf.sts.claims.ClaimsParameters;
import org.apache.cxf.sts.claims.ClaimsParser;
import org.apache.cxf.sts.claims.RequestClaim;
import org.apache.cxf.sts.claims.RequestClaimCollection;
import org.apache.cxf.sts.token.realm.RealmSupport;
import org.apache.cxf.sts.token.realm.Relationship;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.xml.XMLObject;
import org.w3c.dom.Element;

public class ClaimsManager {
    private static final Logger LOG = LogUtils.getL7dLogger(ClaimsManager.class);
    private List<ClaimsParser> claimParsers;
    private List<ClaimsHandler> claimHandlers;
    private List<URI> supportedClaimTypes = new ArrayList<URI>();
    private boolean stopProcessingOnException = true;
    private IdentityMapper identityMapper;

    public IdentityMapper getIdentityMapper() {
        return this.identityMapper;
    }

    public void setIdentityMapper(IdentityMapper identityMapper) {
        this.identityMapper = identityMapper;
    }

    public boolean isStopProcessingOnException() {
        return this.stopProcessingOnException;
    }

    public void setStopProcessingOnException(boolean stopProcessingOnException) {
        this.stopProcessingOnException = stopProcessingOnException;
    }

    public List<URI> getSupportedClaimTypes() {
        return this.supportedClaimTypes;
    }

    public List<ClaimsParser> getClaimParsers() {
        return this.claimParsers;
    }

    public List<ClaimsHandler> getClaimHandlers() {
        return this.claimHandlers;
    }

    public void setClaimParsers(List<ClaimsParser> claimParsers) {
        this.claimParsers = claimParsers;
    }

    public void setClaimHandlers(List<ClaimsHandler> claimHandlers) {
        this.claimHandlers = claimHandlers;
        if (claimHandlers == null) {
            this.supportedClaimTypes.clear();
        } else {
            for (ClaimsHandler handler : claimHandlers) {
                this.supportedClaimTypes.addAll(handler.getSupportedClaimTypes());
            }
        }
    }

    public ClaimCollection retrieveClaimValues(RequestClaimCollection primaryClaims, RequestClaimCollection secondaryClaims, ClaimsParameters parameters) {
        if (primaryClaims == null && secondaryClaims == null) {
            return null;
        }
        if (primaryClaims != null && secondaryClaims == null) {
            return this.retrieveClaimValues(primaryClaims, parameters);
        }
        if (secondaryClaims != null && primaryClaims == null) {
            return this.retrieveClaimValues(secondaryClaims, parameters);
        }
        if (primaryClaims.getDialect() != null && primaryClaims.getDialect().equals(secondaryClaims.getDialect())) {
            RequestClaimCollection mergedClaims = this.mergeClaims(primaryClaims, secondaryClaims);
            return this.retrieveClaimValues(mergedClaims, parameters);
        }
        ClaimCollection claims = this.retrieveClaimValues(primaryClaims, parameters);
        ClaimCollection claims2 = this.retrieveClaimValues(secondaryClaims, parameters);
        ClaimCollection returnedClaims = new ClaimCollection();
        if (claims != null) {
            returnedClaims.addAll(claims);
        }
        if (claims2 != null) {
            returnedClaims.addAll(claims2);
        }
        return returnedClaims;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClaimCollection retrieveClaimValues(RequestClaimCollection claims, ClaimsParameters parameters) {
        Relationship relationship = null;
        if (parameters.getAdditionalProperties() != null) {
            relationship = (Relationship)parameters.getAdditionalProperties().get(Relationship.class.getName());
        }
        if (claims == null || claims.size() == 0) {
            return null;
        }
        if (relationship == null || relationship.getType().equals("FederatedIdentity")) {
            if (this.claimHandlers == null || this.claimHandlers.size() == 0) {
                return null;
            }
            Principal originalPrincipal = parameters.getPrincipal();
            ClaimCollection returnCollection = new ClaimCollection();
            for (ClaimsHandler handler : this.claimHandlers) {
                RequestClaimCollection supportedClaims = this.filterHandlerClaims(claims, handler.getSupportedClaimTypes());
                if (supportedClaims.isEmpty()) continue;
                if (handler instanceof RealmSupport) {
                    RealmSupport handlerRealmSupport = (RealmSupport)((Object)handler);
                    if (handlerRealmSupport.getSupportedRealms() != null && handlerRealmSupport.getSupportedRealms().size() > 0 && handlerRealmSupport.getSupportedRealms().indexOf(parameters.getRealm()) == -1) {
                        if (!LOG.isLoggable(Level.FINER)) continue;
                        LOG.finer("Handler '" + handler.getClass().getName() + "' doesn't support" + " realm '" + parameters.getRealm() + "'");
                        continue;
                    }
                    if (handlerRealmSupport.getHandlerRealm() != null && !handlerRealmSupport.getHandlerRealm().equalsIgnoreCase(parameters.getRealm())) {
                        Principal targetPrincipal = null;
                        try {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Mapping user '" + parameters.getPrincipal().getName() + "' [" + parameters.getRealm() + "] to realm '" + handlerRealmSupport.getHandlerRealm() + "'");
                            }
                            targetPrincipal = this.doMapping(parameters.getRealm(), parameters.getPrincipal(), handlerRealmSupport.getHandlerRealm());
                        }
                        catch (Exception ex) {
                            LOG.log(Level.WARNING, "Failed to map user '" + parameters.getPrincipal().getName() + "' [" + parameters.getRealm() + "] to realm '" + handlerRealmSupport.getHandlerRealm() + "'", ex);
                            throw new STSException("Failed to map user for claims handler", STSException.REQUEST_FAILED);
                        }
                        if (targetPrincipal == null) {
                            LOG.log(Level.WARNING, "Null. Failed to map user '" + parameters.getPrincipal().getName() + "' [" + parameters.getRealm() + "] to realm '" + handlerRealmSupport.getHandlerRealm() + "'");
                            throw new STSException("Failed to map user for claims handler", STSException.REQUEST_FAILED);
                        }
                        if (LOG.isLoggable(Level.INFO)) {
                            LOG.info("Principal '" + targetPrincipal.getName() + "' passed to handler '" + handler.getClass().getName() + "'");
                        }
                        parameters.setPrincipal(targetPrincipal);
                    } else if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("Handler '" + handler.getClass().getName() + "' doesn't require" + " identity mapping '" + parameters.getRealm() + "'");
                    }
                }
                ClaimCollection claimCollection = null;
                try {
                    claimCollection = handler.retrieveClaimValues(supportedClaims, parameters);
                }
                catch (RuntimeException ex) {
                    LOG.log(Level.INFO, "Failed retrieving claims from ClaimsHandler " + handler.getClass().getName(), ex);
                    if (this.isStopProcessingOnException()) {
                        throw ex;
                    }
                }
                finally {
                    parameters.setPrincipal(originalPrincipal);
                }
                if (claimCollection == null || claimCollection.size() == 0) continue;
                returnCollection.addAll(claimCollection);
            }
            this.validateClaimValues(claims, returnCollection);
            return returnCollection;
        }
        ClaimsMapper claimsMapper = relationship.getClaimsMapper();
        if (claimsMapper == null) {
            LOG.log(Level.SEVERE, "ClaimsMapper required to federate claims but not configured.");
            throw new STSException("ClaimsMapper required to federate claims but not configured", STSException.BAD_REQUEST);
        }
        AssertionWrapper assertion = (AssertionWrapper)parameters.getAdditionalProperties().get(AssertionWrapper.class.getName());
        List<Claim> claimList = null;
        claimList = assertion.getSamlVersion().equals(SAMLVersion.VERSION_20) ? this.parseClaimsInAssertion(assertion.getSaml2()) : this.parseClaimsInAssertion(assertion.getSaml1());
        ClaimCollection sourceClaims = new ClaimCollection();
        sourceClaims.addAll(claimList);
        ClaimCollection targetClaims = claimsMapper.mapClaims(relationship.getSourceRealm(), sourceClaims, relationship.getTargetRealm(), parameters);
        this.validateClaimValues(claims, targetClaims);
        return targetClaims;
    }

    private RequestClaimCollection filterHandlerClaims(RequestClaimCollection claims, List<URI> handlerClaimTypes) {
        RequestClaimCollection supportedClaims = new RequestClaimCollection();
        supportedClaims.setDialect(claims.getDialect());
        for (RequestClaim claim : claims) {
            if (!handlerClaimTypes.contains(claim.getClaimType())) continue;
            supportedClaims.add(claim);
        }
        return supportedClaims;
    }

    private boolean validateClaimValues(RequestClaimCollection requestedClaims, ClaimCollection claims) {
        for (RequestClaim claim : requestedClaims) {
            URI claimType = claim.getClaimType();
            boolean found = false;
            if (claim.isOptional()) continue;
            for (Claim c : claims) {
                if (!c.getClaimType().equals(claimType)) continue;
                found = true;
                break;
            }
            if (found) continue;
            LOG.warning("Mandatory claim not found: " + claim.getClaimType());
            throw new STSException("Mandatory claim '" + claim.getClaimType() + "' not found");
        }
        return true;
    }

    protected List<Claim> parseClaimsInAssertion(Assertion assertion) {
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements == null || attributeStatements.isEmpty()) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("No attribute statements found");
            }
            return Collections.emptyList();
        }
        ClaimCollection collection = new ClaimCollection();
        for (org.opensaml.saml1.core.AttributeStatement statement : attributeStatements) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("parsing statement: " + statement.getElementQName());
            }
            List attributes = statement.getAttributes();
            for (org.opensaml.saml1.core.Attribute attribute : attributes) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("parsing attribute: " + attribute.getAttributeName());
                }
                Claim c = new Claim();
                c.setIssuer(assertion.getIssuer());
                c.setClaimType(URI.create(attribute.getAttributeName()));
                try {
                    c.setClaimType(new URI(attribute.getAttributeName()));
                }
                catch (URISyntaxException e) {
                    LOG.warning("Invalid attribute name in attributestatement: " + e.getMessage());
                    continue;
                }
                for (XMLObject attributeValue : attribute.getAttributeValues()) {
                    Element attributeValueElement = attributeValue.getDOM();
                    String value = attributeValueElement.getTextContent();
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest(" [" + value + "]");
                    }
                    c.addValue(value);
                }
                collection.add(c);
            }
        }
        return collection;
    }

    protected List<Claim> parseClaimsInAssertion(org.opensaml.saml2.core.Assertion assertion) {
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements == null || attributeStatements.isEmpty()) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("No attribute statements found");
            }
            return Collections.emptyList();
        }
        ArrayList<Claim> collection = new ArrayList<Claim>();
        for (AttributeStatement statement : attributeStatements) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("parsing statement: " + statement.getElementQName());
            }
            List attributes = statement.getAttributes();
            for (Attribute attribute : attributes) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("parsing attribute: " + attribute.getName());
                }
                Claim c = new Claim();
                c.setClaimType(URI.create(attribute.getName()));
                c.setIssuer(assertion.getIssuer().getNameQualifier());
                for (XMLObject attributeValue : attribute.getAttributeValues()) {
                    Element attributeValueElement = attributeValue.getDOM();
                    String value = attributeValueElement.getTextContent();
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest(" [" + value + "]");
                    }
                    c.addValue(value);
                }
                collection.add(c);
            }
        }
        return collection;
    }

    private RequestClaimCollection mergeClaims(RequestClaimCollection primaryClaims, RequestClaimCollection secondaryClaims) {
        RequestClaimCollection parsedClaims = new RequestClaimCollection();
        parsedClaims.addAll(secondaryClaims);
        RequestClaimCollection mergedClaims = new RequestClaimCollection();
        mergedClaims.setDialect(primaryClaims.getDialect());
        for (RequestClaim claim : primaryClaims) {
            RequestClaim matchingClaim = null;
            for (RequestClaim secondaryClaim : parsedClaims) {
                if (!secondaryClaim.getClaimType().equals(claim.getClaimType())) continue;
                matchingClaim = secondaryClaim;
                break;
            }
            if (matchingClaim == null) {
                mergedClaims.add(claim);
                continue;
            }
            RequestClaim mergedClaim = new RequestClaim();
            mergedClaim.setClaimType(claim.getClaimType());
            if (claim.getClaimValue() != null) {
                mergedClaim.setClaimValue(claim.getClaimValue());
                if (matchingClaim.getClaimValue() != null) {
                    LOG.log(Level.WARNING, "Secondary claim value " + matchingClaim.getClaimValue() + " ignored in favour of primary claim value");
                }
            } else if (matchingClaim.getClaimValue() != null) {
                mergedClaim.setClaimValue(matchingClaim.getClaimValue());
            }
            mergedClaims.add(mergedClaim);
            parsedClaims.remove(matchingClaim);
        }
        mergedClaims.addAll(parsedClaims);
        return mergedClaims;
    }

    protected Principal doMapping(String sourceRealm, Principal sourcePrincipal, String targetRealm) {
        return this.identityMapper.mapPrincipal(sourceRealm, sourcePrincipal, targetRealm);
    }
}

