/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.event.map;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.claims.RequestClaim;
import org.apache.cxf.sts.event.AbstractSTSEvent;
import org.apache.cxf.sts.event.AbstractSTSFailureEvent;
import org.apache.cxf.sts.event.STSEventListener;
import org.apache.cxf.sts.event.TokenCancellerParametersSupport;
import org.apache.cxf.sts.event.TokenProviderParametersSupport;
import org.apache.cxf.sts.event.TokenRenewerParametersSupport;
import org.apache.cxf.sts.event.TokenValidatorParametersSupport;
import org.apache.cxf.sts.event.map.KEYS;
import org.apache.cxf.sts.event.map.MapEvent;
import org.apache.cxf.sts.event.map.MapEventListener;
import org.apache.cxf.sts.token.canceller.TokenCancellerParameters;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.sts.token.renewer.TokenRenewerParameters;
import org.apache.cxf.sts.token.validator.TokenValidatorParameters;

public class EventMapper
implements STSEventListener {
    private static final Logger LOG = LogUtils.getL7dLogger(EventMapper.class);
    private MapEventListener mapEventListener;

    public EventMapper(MapEventListener mapEventListener) {
        this.mapEventListener = mapEventListener;
    }

    @Override
    public void handleSTSEvent(AbstractSTSEvent event) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(KEYS.TIME.name(), new Date(event.getTimestamp()));
        map.put(KEYS.OPERATION.name(), event.getOperation());
        map.put(KEYS.DURATION.name(), String.valueOf(event.getDuration()) + "ms");
        if (event instanceof AbstractSTSFailureEvent) {
            map.put(KEYS.STATUS.name(), "FAILURE");
            Exception ex = ((AbstractSTSFailureEvent)event).getException();
            map.put(KEYS.EXCEPTION.name(), ex);
        } else {
            map.put(KEYS.STATUS.name(), "SUCCESS");
        }
        if (event instanceof TokenProviderParametersSupport) {
            this.handleEvent((TokenProviderParametersSupport)((Object)event), map);
        } else if (event instanceof TokenValidatorParametersSupport) {
            this.handleEvent((TokenValidatorParametersSupport)((Object)event), map);
        } else if (event instanceof TokenCancellerParametersSupport) {
            this.handleEvent((TokenCancellerParametersSupport)((Object)event), map);
        } else if (event instanceof TokenRenewerParametersSupport) {
            this.handleEvent((TokenRenewerParametersSupport)((Object)event), map);
        } else {
            LOG.warning("Unknown STS event: " + event.getClass());
        }
        MapEvent mapEvent = new MapEvent("org/apache/cxf/sts", map);
        this.mapEventListener.onEvent(mapEvent);
    }

    protected void handleEvent(TokenProviderParametersSupport event, Map<String, Object> map) {
        ArrayList<String> claims;
        TokenProviderParameters params = event.getTokenParameters();
        try {
            HttpServletRequest req = (HttpServletRequest)params.getWebServiceContext().getMessageContext().get((Object)"HTTP.REQUEST");
            map.put(KEYS.REMOTE_HOST.name(), req.getRemoteHost());
            map.put(KEYS.REMOTE_PORT.name(), String.valueOf(req.getRemotePort()));
            map.put(KEYS.URL.name(), (String)params.getWebServiceContext().getMessageContext().get((Object)"org.apache.cxf.request.url"));
        }
        catch (Exception ex) {
            map.put(KEYS.REMOTE_HOST.name(), "N.A.");
            map.put(KEYS.REMOTE_PORT.name(), "N.A.");
            map.put(KEYS.URL.name(), "N.A.");
        }
        if (params.getTokenRequirements() != null) {
            map.put(KEYS.TOKENTYPE.name(), params.getTokenRequirements().getTokenType());
            if (params.getTokenRequirements().getOnBehalfOf() != null) {
                map.put(KEYS.ONBEHALFOF_PRINCIPAL.name(), params.getTokenRequirements().getOnBehalfOf().getPrincipal().getName());
            }
            if (params.getTokenRequirements().getActAs() != null) {
                map.put(KEYS.ACTAS_PRINCIPAL.name(), params.getTokenRequirements().getActAs().getPrincipal().getName());
            }
        } else {
            map.put(KEYS.TOKENTYPE.name(), "N.A.");
        }
        if (params.getPrincipal() != null) {
            map.put(KEYS.WS_SEC_PRINCIPAL.name(), params.getPrincipal().getName());
        }
        map.put(KEYS.REALM.name(), params.getRealm());
        map.put(KEYS.APPLIESTO.name(), params.getAppliesToAddress());
        if (params.getRequestedPrimaryClaims() != null) {
            claims = new ArrayList<String>();
            for (RequestClaim claim : params.getRequestedPrimaryClaims()) {
                claims.add(claim.getClaimType().toString());
            }
            map.put(KEYS.CLAIMS_PRIMARY.name(), ((Object)claims).toString());
        }
        if (params.getRequestedSecondaryClaims() != null) {
            claims = new ArrayList();
            for (RequestClaim claim : params.getRequestedSecondaryClaims()) {
                claims.add(claim.getClaimType().toString());
            }
            map.put(KEYS.CLAIMS_SECONDARY.name(), ((Object)claims).toString());
        }
    }

    protected void handleEvent(TokenValidatorParametersSupport event, Map<String, Object> map) {
        TokenValidatorParameters params = event.getTokenParameters();
        HttpServletRequest req = (HttpServletRequest)params.getWebServiceContext().getMessageContext().get((Object)"HTTP.REQUEST");
        map.put(KEYS.REMOTE_HOST.name(), req.getRemoteHost());
        map.put(KEYS.REMOTE_PORT.name(), String.valueOf(req.getRemotePort()));
        map.put(KEYS.URL.name(), (String)params.getWebServiceContext().getMessageContext().get((Object)"org.apache.cxf.request.url"));
        map.put(KEYS.TOKENTYPE.name(), params.getTokenRequirements().getTokenType());
        if (params.getTokenRequirements().getActAs() != null) {
            map.put(KEYS.VALIDATE_PRINCIPAL.name(), params.getTokenRequirements().getValidateTarget().getPrincipal().getName());
        }
        if (params.getPrincipal() != null) {
            map.put(KEYS.WS_SEC_PRINCIPAL.name(), params.getPrincipal().getName());
        }
        map.put(KEYS.REALM.name(), params.getRealm());
    }

    protected void handleEvent(TokenCancellerParametersSupport event, Map<String, Object> map) {
        TokenCancellerParameters params = event.getTokenParameters();
        HttpServletRequest req = (HttpServletRequest)params.getWebServiceContext().getMessageContext().get((Object)"HTTP.REQUEST");
        map.put(KEYS.REMOTE_HOST.name(), req.getRemoteHost());
        map.put(KEYS.REMOTE_PORT.name(), String.valueOf(req.getRemotePort()));
        map.put(KEYS.URL.name(), (String)params.getWebServiceContext().getMessageContext().get((Object)"org.apache.cxf.request.url"));
        map.put(KEYS.TOKENTYPE.name(), params.getTokenRequirements().getTokenType());
        if (params.getTokenRequirements().getActAs() != null) {
            map.put(KEYS.CANCEL_PRINCIPAL.name(), params.getTokenRequirements().getCancelTarget().getPrincipal().getName());
        }
        if (params.getPrincipal() != null) {
            map.put(KEYS.WS_SEC_PRINCIPAL.name(), params.getPrincipal().getName());
        }
    }

    protected void handleEvent(TokenRenewerParametersSupport event, Map<String, Object> map) {
        TokenRenewerParameters params = event.getTokenParameters();
        HttpServletRequest req = (HttpServletRequest)params.getWebServiceContext().getMessageContext().get((Object)"HTTP.REQUEST");
        map.put(KEYS.REMOTE_HOST.name(), req.getRemoteHost());
        map.put(KEYS.REMOTE_PORT.name(), String.valueOf(req.getRemotePort()));
        map.put(KEYS.URL.name(), (String)params.getWebServiceContext().getMessageContext().get((Object)"org.apache.cxf.request.url"));
        map.put(KEYS.TOKENTYPE.name(), params.getTokenRequirements().getTokenType());
        if (params.getTokenRequirements().getRenewTarget() != null) {
            map.put(KEYS.RENEW_PRINCIPAL.name(), params.getTokenRequirements().getRenewTarget().getPrincipal().getName());
        }
        if (params.getPrincipal() != null) {
            map.put(KEYS.WS_SEC_PRINCIPAL.name(), params.getPrincipal().getName());
        }
        map.put(KEYS.REALM.name(), params.getRealm());
        map.put(KEYS.APPLIESTO.name(), params.getAppliesToAddress());
    }
}

