/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import org.jboss.logging.Logger;
import org.jboss.threads.InterruptHandler;
import org.jboss.threads.ThreadNameInfo;

public final class JBossThread
extends Thread {
    private static final Logger log = Logger.getLogger((String)"org.jboss.threads");
    private static final Logger ihlog = Logger.getLogger((String)"org.jboss.threads.interrupt-handler");
    private volatile InterruptHandler interruptHandler;
    private ThreadNameInfo threadNameInfo;

    public JBossThread(Runnable target) {
        super(target);
    }

    public JBossThread(Runnable target, String name) {
        super(target, name);
    }

    public JBossThread(ThreadGroup group, Runnable target) throws SecurityException {
        super(group, target);
    }

    public JBossThread(ThreadGroup group, Runnable target, String name) throws SecurityException {
        super(group, target, name);
    }

    public JBossThread(ThreadGroup group, Runnable target, String name, long stackSize) throws SecurityException {
        super(group, target, name, stackSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() {
        ihlog.tracef("Interrupting thread \"%s\"", (Object)this);
        try {
            super.interrupt();
        }
        finally {
            InterruptHandler interruptHandler = this.interruptHandler;
            if (interruptHandler != null) {
                try {
                    interruptHandler.handleInterrupt(this);
                }
                catch (Throwable t) {
                    ihlog.errorf(t, "Interrupt handler %s threw an exception", (Object)interruptHandler);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.tracef("Thread \"%s\" starting execution", (Object)this);
        try {
            super.run();
        }
        finally {
            log.tracef("Thread \"%s\" exiting", (Object)this);
        }
    }

    public static JBossThread currentThread() {
        Thread thread = Thread.currentThread();
        return thread instanceof JBossThread ? (JBossThread)thread : null;
    }

    @Override
    public void start() {
        super.start();
        log.tracef("Started thread \"%s\"", (Object)this);
    }

    @Override
    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler eh) {
        super.setUncaughtExceptionHandler(eh);
        log.tracef("Changed uncaught exception handler for \"%s\" to %s", (Object)this, (Object)eh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InterruptHandler getAndSetInterruptHandler(InterruptHandler newInterruptHandler) {
        JBossThread thread = JBossThread.currentThread();
        if (thread == null) {
            throw new IllegalStateException("The current thread does not support interrupt handlers");
        }
        try {
            InterruptHandler interruptHandler = thread.interruptHandler;
            return interruptHandler;
        }
        finally {
            thread.interruptHandler = newInterruptHandler;
        }
    }

    public ThreadNameInfo getThreadNameInfo() {
        return this.threadNameInfo;
    }

    public void setThreadNameInfo(ThreadNameInfo threadNameInfo) throws SecurityException {
        this.checkAccess();
        this.threadNameInfo = threadNameInfo;
    }
}

