/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.file;

import org.keycloak.connections.file.DefaultFileConnectionProviderFactory;
import org.keycloak.connections.file.FileConnectionProvider;
import org.keycloak.connections.file.InMemoryModel;
import org.keycloak.models.KeycloakSession;

public class DefaultFileConnectionProvider
implements FileConnectionProvider {
    private final DefaultFileConnectionProviderFactory factory;
    private final KeycloakSession session;
    private final InMemoryModel inMemoryModel;
    private boolean isRollbackOnly = false;

    public DefaultFileConnectionProvider(DefaultFileConnectionProviderFactory factory, KeycloakSession session, InMemoryModel inMemoryModel) {
        this.factory = factory;
        this.session = session;
        this.inMemoryModel = inMemoryModel;
    }

    @Override
    public InMemoryModel getModel() {
        return this.inMemoryModel;
    }

    @Override
    public void sessionClosed(KeycloakSession session) {
        this.factory.sessionClosed(session);
    }

    public void close() {
    }

    public void begin() {
    }

    public void commit() {
        this.factory.commit(this.session);
    }

    public void rollback() {
        this.factory.rollback(this.session);
    }

    public void setRollbackOnly() {
        this.isRollbackOnly = true;
    }

    public boolean getRollbackOnly() {
        return this.isRollbackOnly;
    }

    public boolean isActive() {
        return this.factory.isActive(this.session);
    }
}

