/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml;

import java.net.URI;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keycloak.dom.saml.v2.protocol.StatusCodeType;
import org.keycloak.dom.saml.v2.protocol.StatusDetailType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.common.util.StringUtil;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.w3c.dom.Element;

public abstract class SAMLStatusResponseTypeParser {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    protected StatusResponseType parseBaseAttributes(StartElement startElement) throws ParsingException {
        Attribute inResponseTo;
        Attribute consent;
        Attribute idAttr = startElement.getAttributeByName(new QName(JBossSAMLConstants.ID.get()));
        if (idAttr == null) {
            throw logger.parserRequiredAttribute("ID");
        }
        String id = StaxParserUtil.getAttributeValue(idAttr);
        Attribute version = startElement.getAttributeByName(new QName(JBossSAMLConstants.VERSION.get()));
        if (version == null) {
            throw logger.parserRequiredAttribute("Version");
        }
        StringUtil.match(JBossSAMLConstants.VERSION_2_0.get(), StaxParserUtil.getAttributeValue(version));
        Attribute issueInstant = startElement.getAttributeByName(new QName(JBossSAMLConstants.ISSUE_INSTANT.get()));
        if (issueInstant == null) {
            throw logger.parserRequiredAttribute("IssueInstant");
        }
        XMLGregorianCalendar issueInstantVal = XMLTimeUtil.parse(StaxParserUtil.getAttributeValue(issueInstant));
        StatusResponseType response = new StatusResponseType(id, issueInstantVal);
        Attribute destination = startElement.getAttributeByName(new QName(JBossSAMLConstants.DESTINATION.get()));
        if (destination != null) {
            response.setDestination(StaxParserUtil.getAttributeValue(destination));
        }
        if ((consent = startElement.getAttributeByName(new QName(JBossSAMLConstants.CONSENT.get()))) != null) {
            response.setConsent(StaxParserUtil.getAttributeValue(consent));
        }
        if ((inResponseTo = startElement.getAttributeByName(new QName(JBossSAMLConstants.IN_RESPONSE_TO.get()))) != null) {
            response.setInResponseTo(StaxParserUtil.getAttributeValue(inResponseTo));
        }
        return response;
    }

    protected StatusType parseStatus(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        String STATUS = JBossSAMLConstants.STATUS.get();
        StaxParserUtil.validate(startElement, STATUS);
        StatusType status = new StatusType();
        while (xmlEventReader.hasNext() && (startElement = StaxParserUtil.peekNextStartElement(xmlEventReader)) != null) {
            XMLEvent xmlEvent;
            EndElement endElement;
            QName startElementName = startElement.getName();
            String elementTag = startElementName.getLocalPart();
            StatusCodeType statusCode = new StatusCodeType();
            if (JBossSAMLConstants.STATUS_CODE.get().equals(elementTag)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                if (startElement == null) break;
                Attribute valueAttr = startElement.getAttributeByName(new QName("Value"));
                if (valueAttr != null) {
                    statusCode.setValue(URI.create(StaxParserUtil.getAttributeValue(valueAttr)));
                }
                status.setStatusCode(statusCode);
                startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
                if (startElement == null) {
                    endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    if (endElement == null) continue;
                    StaxParserUtil.validate(endElement, JBossSAMLConstants.STATUS_CODE.get());
                    continue;
                }
                elementTag = startElement.getName().getLocalPart();
                if (JBossSAMLConstants.STATUS_CODE.get().equals(elementTag)) {
                    StatusCodeType subStatusCodeType = new StatusCodeType();
                    startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                    Attribute subValueAttr = startElement.getAttributeByName(new QName("Value"));
                    if (subValueAttr != null) {
                        subStatusCodeType.setValue(URI.create(StaxParserUtil.getAttributeValue(subValueAttr)));
                    }
                    statusCode.setStatusCode(subStatusCodeType);
                    EndElement endElement2 = StaxParserUtil.getNextEndElement(xmlEventReader);
                    StaxParserUtil.validate(endElement2, JBossSAMLConstants.STATUS_CODE.get());
                    continue;
                }
            }
            if (JBossSAMLConstants.STATUS_MESSAGE.get().equals(elementTag)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                if (startElement == null) break;
                status.setStatusMessage(StaxParserUtil.getElementText(xmlEventReader));
            }
            if (JBossSAMLConstants.STATUS_DETAIL.get().equals(elementTag)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                if (startElement == null) break;
                Element domElement = StaxParserUtil.getDOMElement(xmlEventReader);
                StatusDetailType statusDetailType = new StatusDetailType();
                statusDetailType.addStatusDetail(domElement);
                status.setStatusDetail(statusDetailType);
            }
            if (!((xmlEvent = StaxParserUtil.peek(xmlEventReader)) instanceof EndElement) || StaxParserUtil.matches(endElement = StaxParserUtil.getNextEndElement(xmlEventReader), STATUS)) break;
            throw logger.parserUnknownEndElement(StaxParserUtil.getEndElementName(endElement));
        }
        return status;
    }
}

