/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.jpa;

import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import javax.persistence.EntityManager;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.jboss.logging.Logger;
import org.keycloak.events.Event;
import org.keycloak.events.EventQuery;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventType;
import org.keycloak.events.jpa.EventEntity;
import org.keycloak.events.jpa.JpaEventQuery;

public class JpaEventStoreProvider
implements EventStoreProvider {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<Map<String, String>> mapType = new TypeReference<Map<String, String>>(){};
    private static final Logger logger = Logger.getLogger(JpaEventStoreProvider.class);
    private EntityManager em;

    public JpaEventStoreProvider(EntityManager em) {
        this.em = em;
    }

    public EventQuery createQuery() {
        return new JpaEventQuery(this.em);
    }

    public void clear() {
        this.em.createQuery("delete from EventEntity").executeUpdate();
    }

    public void clear(String realmId) {
        this.em.createQuery("delete from EventEntity where realmId = :realmId").setParameter("realmId", (Object)realmId).executeUpdate();
    }

    public void clear(String realmId, long olderThan) {
        this.em.createQuery("delete from EventEntity where realmId = :realmId and time < :time").setParameter("realmId", (Object)realmId).setParameter("time", (Object)olderThan).executeUpdate();
    }

    public void onEvent(Event event) {
        this.em.persist((Object)JpaEventStoreProvider.convert(event));
    }

    public void close() {
    }

    static EventEntity convert(Event o) {
        EventEntity e = new EventEntity();
        e.setId(UUID.randomUUID().toString());
        e.setTime(o.getTime());
        e.setType(o.getType().toString());
        e.setRealmId(o.getRealmId());
        e.setClientId(o.getClientId());
        e.setUserId(o.getUserId());
        e.setSessionId(o.getSessionId());
        e.setIpAddress(o.getIpAddress());
        e.setError(o.getError());
        try {
            e.setDetailsJson(mapper.writeValueAsString((Object)o.getDetails()));
        }
        catch (IOException ex) {
            logger.error((Object)"Failed to write log details", (Throwable)ex);
        }
        return e;
    }

    static Event convert(EventEntity o) {
        Event e = new Event();
        e.setTime(o.getTime());
        e.setType(EventType.valueOf((String)o.getType()));
        e.setRealmId(o.getRealmId());
        e.setClientId(o.getClientId());
        e.setUserId(o.getUserId());
        e.setSessionId(o.getSessionId());
        e.setIpAddress(o.getIpAddress());
        e.setError(o.getError());
        try {
            Map details = (Map)mapper.readValue(o.getDetailsJson(), mapType);
            e.setDetails(details);
        }
        catch (IOException ex) {
            logger.error((Object)"Failed to read log details", (Throwable)ex);
        }
        return e;
    }
}

