/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.producer;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.EntityType;
import org.picketlink.IdentityConfigurationEvent;
import org.picketlink.annotations.PicketLink;
import org.picketlink.extension.PicketLinkExtension;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.internal.CDIEventBridge;
import org.picketlink.internal.EEJPAContextInitializer;
import org.picketlink.log.BaseLog;

public class IdentityManagementConfiguration {
    private static final String DEFAULT_CONFIGURATION_NAME = "default";
    private static final String JPA_ANNOTATION_PACKAGE = "org.picketlink.idm.jpa.annotations";
    @Inject
    private Instance<IdentityConfiguration> identityConfigInstance;
    @Inject
    private PicketLinkExtension picketLinkExtension;
    @Inject
    @PicketLink
    private Instance<EntityManager> entityManagerInstance;
    @Inject
    private EEJPAContextInitializer contextInitializer;
    @Inject
    private CDIEventBridge eventBridge;
    private List<IdentityConfiguration> identityConfiguration;

    List<IdentityConfiguration> getIdentityConfiguration() {
        if (this.identityConfiguration == null) {
            IdentityConfigurationBuilder builder;
            if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                BaseLog.ROOT_LOGGER.debugf("Building identity management configuration.", new Object[0]);
            }
            ArrayList configurations = new ArrayList();
            if (!this.identityConfigInstance.isUnsatisfied()) {
                Iterator iterator = this.identityConfigInstance.iterator();
                while (iterator.hasNext()) {
                    configurations.add(iterator.next());
                }
            } else {
                configurations.addAll(this.picketLinkExtension.getSecurityConfiguration().getIdentityConfigurations());
            }
            if (configurations.isEmpty()) {
                if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                    BaseLog.ROOT_LOGGER.debugf("IdentityConfiguration not provided by the application, creating a default IdentityConfigurationBuilder.", new Object[0]);
                }
                builder = new IdentityConfigurationBuilder();
            } else {
                if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                    BaseLog.ROOT_LOGGER.debugf("Found IdentityConfiguration from the environment. Creating a IdentityConfigurationBuilder with them.", new Object[0]);
                }
                builder = new IdentityConfigurationBuilder(configurations);
            }
            this.eventBridge.fireEvent(new IdentityConfigurationEvent(builder));
            if (!builder.isConfigured()) {
                this.configureDefaults(builder);
            }
            this.identityConfiguration = builder.buildAll();
        }
        return this.identityConfiguration;
    }

    private void configureDefaults(IdentityConfigurationBuilder builder) {
        Set<Class<?>> entities;
        if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
            BaseLog.ROOT_LOGGER.debugf("No configuration provided by the application. Configuring defaults.", new Object[0]);
        }
        if ((entities = this.getEntities()).isEmpty()) {
            builder.named(DEFAULT_CONFIGURATION_NAME).stores().file().supportAllFeatures();
            if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                BaseLog.ROOT_LOGGER.debugf("Auto configuring File Identity Store. All features are going to be supported.", entities);
            }
        } else {
            builder.named(DEFAULT_CONFIGURATION_NAME).stores().jpa().mappedEntity(entities.toArray(new Class[entities.size()])).addContextInitializer((ContextInitializer)this.contextInitializer).supportAllFeatures();
            if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                BaseLog.ROOT_LOGGER.debugf("Auto configuring JPA Identity Store. All features are going to be supported. Entities [%s]", entities);
            }
        }
    }

    private Set<Class<?>> getEntities() {
        HashSet entities = new HashSet();
        if (!this.entityManagerInstance.isUnsatisfied()) {
            EntityManager entityManager = (EntityManager)this.entityManagerInstance.get();
            for (EntityType entityType : entityManager.getMetamodel().getEntities()) {
                Class javaType = entityType.getJavaType();
                if (Modifier.isAbstract(javaType.getModifiers()) || !this.isIdentityEntity(javaType)) continue;
                if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                    BaseLog.ROOT_LOGGER.debugf("PicketLink IDM mapped entity found [%s].", (Object)entityType);
                }
                entities.add(javaType);
            }
        }
        return entities;
    }

    private boolean isIdentityEntity(Class<?> cls) {
        while (!cls.equals(Object.class)) {
            for (Annotation a : cls.getAnnotations()) {
                if (!a.annotationType().getName().startsWith(JPA_ANNOTATION_PACKAGE)) continue;
                return true;
            }
            for (Field f : cls.getDeclaredFields()) {
                for (Annotation a : f.getAnnotations()) {
                    if (!a.annotationType().getName().startsWith(JPA_ANNOTATION_PACKAGE)) continue;
                    return true;
                }
            }
            cls = cls.getSuperclass();
        }
        return false;
    }
}

