/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.x509;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.ssl.TrustMaterial;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.x509.extension.SubjectKeyIdentifierStructure;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.x509.InternalX500DNHandler;
import org.opensaml.xml.security.x509.X500DNHandler;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.IPAddressHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509Util {
    public static final String CN_OID = "2.5.4.3";
    public static final Integer OTHER_ALT_NAME = new Integer(0);
    public static final Integer RFC822_ALT_NAME = new Integer(1);
    public static final Integer DNS_ALT_NAME = new Integer(2);
    public static final Integer X400ADDRESS_ALT_NAME = new Integer(3);
    public static final Integer DIRECTORY_ALT_NAME = new Integer(4);
    public static final Integer EDI_PARTY_ALT_NAME = new Integer(5);
    public static final Integer URI_ALT_NAME = new Integer(6);
    public static final Integer IP_ADDRESS_ALT_NAME = new Integer(7);
    public static final Integer REGISTERED_ID_ALT_NAME = new Integer(8);

    protected X509Util() {
    }

    public static X509Certificate determineEntityCertificate(Collection<X509Certificate> certs, PrivateKey privateKey) throws SecurityException {
        if (certs == null || privateKey == null) {
            return null;
        }
        for (X509Certificate certificate : certs) {
            if (!SecurityHelper.matchKeyPair(certificate.getPublicKey(), privateKey)) continue;
            return certificate;
        }
        return null;
    }

    public static List<String> getCommonNames(X500Principal dn) {
        Logger log = X509Util.getLogger();
        if (dn == null) {
            return null;
        }
        log.debug("Extracting CNs from the following DN: {}", (Object)dn.toString());
        LinkedList<String> commonNames = new LinkedList<String>();
        try {
            ASN1InputStream asn1Stream = new ASN1InputStream(dn.getEncoded());
            DERObject parent = asn1Stream.readObject();
            String cn = null;
            for (int i = 0; i < ((DERSequence)parent).size(); ++i) {
                DERObject dnComponent = ((DERSequence)parent).getObjectAt(i).getDERObject();
                if (!(dnComponent instanceof DERSet)) {
                    log.debug("No DN components.");
                    continue;
                }
                for (int j = 0; j < ((DERSet)dnComponent).size(); ++j) {
                    DERObjectIdentifier componentId;
                    DERSequence grandChild = (DERSequence)((DERSet)dnComponent).getObjectAt(j).getDERObject();
                    if (grandChild.getObjectAt(0) == null || !(grandChild.getObjectAt(0).getDERObject() instanceof DERObjectIdentifier) || !CN_OID.equals((componentId = (DERObjectIdentifier)grandChild.getObjectAt(0).getDERObject()).getId()) || grandChild.getObjectAt(1) == null || !(grandChild.getObjectAt(1).getDERObject() instanceof DERString)) continue;
                    cn = ((DERString)grandChild.getObjectAt(1).getDERObject()).getString();
                    commonNames.add(cn);
                }
            }
            asn1Stream.close();
            return commonNames;
        }
        catch (IOException e) {
            log.error("Unable to extract common names from DN: ASN.1 parsing failed: " + e);
            return null;
        }
    }

    public static List getAltNames(X509Certificate certificate, Integer[] nameTypes) {
        Logger log = X509Util.getLogger();
        if (certificate == null) {
            return null;
        }
        LinkedList<Object> names = new LinkedList<Object>();
        Collection altNames = null;
        try {
            altNames = X509ExtensionUtil.getSubjectAlternativeNames((X509Certificate)certificate);
        }
        catch (CertificateParsingException e) {
            log.error("Encountered an problem trying to extract Subject Alternate Name from supplied certificate: " + e);
            return names;
        }
        if (altNames != null) {
            block2: for (List altName : altNames) {
                for (Integer nameType : nameTypes) {
                    if (!altName.get(0).equals(nameType)) continue;
                    names.add(X509Util.convertAltNameType(nameType, altName.get(1)));
                    continue block2;
                }
            }
        }
        return names;
    }

    public static List getSubjectNames(X509Certificate certificate, Integer[] altNameTypes) {
        LinkedList<String> issuerNames = new LinkedList<String>();
        List<String> entityCertCNs = X509Util.getCommonNames(certificate.getSubjectX500Principal());
        issuerNames.add(entityCertCNs.get(0));
        issuerNames.addAll(X509Util.getAltNames(certificate, altNameTypes));
        return issuerNames;
    }

    public static byte[] getSubjectKeyIdentifier(X509Certificate certificate) {
        Logger log = X509Util.getLogger();
        byte[] derValue = certificate.getExtensionValue(X509Extensions.SubjectKeyIdentifier.getId());
        if (derValue == null || derValue.length == 0) {
            return null;
        }
        SubjectKeyIdentifierStructure ski = null;
        try {
            ski = new SubjectKeyIdentifierStructure(derValue);
        }
        catch (IOException e) {
            log.error("Unable to extract subject key identifier from certificate: ASN.1 parsing failed: " + e);
            return null;
        }
        if (ski != null) {
            return ski.getKeyIdentifier();
        }
        return null;
    }

    public static Collection<X509Certificate> decodeCertificate(File certs) throws CertificateException {
        if (!certs.exists()) {
            throw new CertificateException("Certificate file " + certs.getAbsolutePath() + " does not exist");
        }
        if (!certs.canRead()) {
            throw new CertificateException("Certificate file " + certs.getAbsolutePath() + " is not readable");
        }
        try {
            return X509Util.decodeCertificate(DatatypeHelper.fileToByteArray(certs));
        }
        catch (IOException e) {
            throw new CertificateException("Error reading certificate file " + certs.getAbsolutePath(), e);
        }
    }

    public static Collection<X509Certificate> decodeCertificate(byte[] certs) throws CertificateException {
        try {
            TrustMaterial tm = new TrustMaterial(certs);
            return tm.getCertificates();
        }
        catch (Exception e) {
            throw new CertificateException("Unable to decode X.509 certificates", e);
        }
    }

    public static Collection<X509CRL> decodeCRLs(File crls) throws CRLException {
        if (!crls.exists()) {
            throw new CRLException("CRL file " + crls.getAbsolutePath() + " does not exist");
        }
        if (!crls.canRead()) {
            throw new CRLException("CRL file " + crls.getAbsolutePath() + " is not readable");
        }
        try {
            return X509Util.decodeCRLs(DatatypeHelper.fileToByteArray(crls));
        }
        catch (IOException e) {
            throw new CRLException("Error reading CRL file " + crls.getAbsolutePath(), e);
        }
    }

    public static Collection<X509CRL> decodeCRLs(byte[] crls) throws CRLException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return cf.generateCRLs(new ByteArrayInputStream(crls));
        }
        catch (GeneralSecurityException e) {
            throw new CRLException("Unable to decode X.509 certificates");
        }
    }

    public static String getIdentifiersToken(X509Credential credential, X500DNHandler handler) {
        X500DNHandler x500DNHandler = handler != null ? handler : new InternalX500DNHandler();
        X500Principal x500Principal = credential.getEntityCertificate().getSubjectX500Principal();
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        builder.append(String.format("subjectName='%s'", x500DNHandler.getName(x500Principal)));
        if (!DatatypeHelper.isEmpty(credential.getEntityId())) {
            builder.append(String.format(" |credential entityID='%s'", DatatypeHelper.safeTrimOrNullString(credential.getEntityId())));
        }
        builder.append(']');
        return builder.toString();
    }

    private static Object convertAltNameType(Integer nameType, Object nameValue) {
        Logger log = X509Util.getLogger();
        if (DIRECTORY_ALT_NAME.equals(nameType) || DNS_ALT_NAME.equals(nameType) || RFC822_ALT_NAME.equals(nameType) || URI_ALT_NAME.equals(nameType) || REGISTERED_ID_ALT_NAME.equals(nameType)) {
            return nameValue;
        }
        if (IP_ADDRESS_ALT_NAME.equals(nameType)) {
            return IPAddressHelper.addressToString((byte[])nameValue);
        }
        if (EDI_PARTY_ALT_NAME.equals(nameType) || X400ADDRESS_ALT_NAME.equals(nameType) || OTHER_ALT_NAME.equals(nameType)) {
            return ((DERObject)nameValue).getDEREncoded();
        }
        log.warn("Encountered unknown alt name type '{}', adding as-is", (Object)nameType);
        return nameValue;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(X509Util.class);
    }

    public static enum ENCODING_FORMAT {
        PEM,
        DER;

    }
}

