/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.constraint;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.constraint.AbstractConstraintFactory;
import org.jboss.as.controller.access.constraint.AllowAllowNotConstraint;
import org.jboss.as.controller.access.constraint.AuditConstraint;
import org.jboss.as.controller.access.constraint.AuditLogAddressUtil;
import org.jboss.as.controller.access.constraint.Constraint;
import org.jboss.as.controller.access.constraint.ConstraintFactory;
import org.jboss.as.controller.access.constraint.ScopingConstraintFactory;
import org.jboss.as.controller.access.rbac.StandardRole;

public class NonAuditConstraint
extends AllowAllowNotConstraint {
    public static final ConstraintFactory FACTORY = new Factory();
    private static final NonAuditConstraint AUDIT = new NonAuditConstraint(true);
    private static final NonAuditConstraint NOT_AUDIT = new NonAuditConstraint(false);
    private static final NonAuditConstraint ALLOWS = new NonAuditConstraint(true, true);
    private static final NonAuditConstraint DISALLOWS = new NonAuditConstraint(true, false);

    private NonAuditConstraint(boolean isAudit) {
        super(isAudit);
    }

    private NonAuditConstraint(boolean allowsAudit, boolean allowsNonAudit) {
        super(allowsAudit, allowsNonAudit);
    }

    private static class Factory
    extends AbstractConstraintFactory {
        private Factory() {
        }

        @Override
        public Constraint getStandardUserConstraint(StandardRole role, Action.ActionEffect actionEffect) {
            return role == StandardRole.AUDITOR && (actionEffect == Action.ActionEffect.WRITE_CONFIG || actionEffect == Action.ActionEffect.WRITE_RUNTIME) ? DISALLOWS : ALLOWS;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetAttribute target) {
            return this.getRequiredConstraint(actionEffect, action, target.getTargetResource());
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetResource target) {
            return this.isAuditOperation(action) || this.isAuditResource(target) ? AUDIT : NOT_AUDIT;
        }

        private boolean isAuditOperation(Action action) {
            return AuditLogAddressUtil.isAuditLogAddress(PathAddress.pathAddress(action.getOperation().get("address")));
        }

        private boolean isAuditResource(TargetResource target) {
            return AuditLogAddressUtil.isAuditLogAddress(target.getResourceAddress());
        }

        @Override
        protected int internalCompare(AbstractConstraintFactory other) {
            return other instanceof ScopingConstraintFactory || other instanceof AuditConstraint.Factory ? 1 : -1;
        }
    }
}

