/*
 * Decompiled with CFR 0.152.
 */
package liquibase.logging;

import java.util.HashMap;
import java.util.Map;
import liquibase.exception.ServiceNotFoundException;
import liquibase.logging.LogLevel;
import liquibase.logging.Logger;
import liquibase.servicelocator.ServiceLocator;

public class LogFactory {
    private static Map<String, Logger> loggers = new HashMap<String, Logger>();
    private static String defaultLoggingLevel = null;
    private static LogFactory instance;

    public static void reset() {
        instance = new LogFactory();
    }

    public static LogFactory getInstance() {
        if (instance == null) {
            instance = new LogFactory();
        }
        return instance;
    }

    public static void setInstance(LogFactory instance) {
        LogFactory.instance = instance;
    }

    public static Logger getLogger(String name) {
        return LogFactory.getInstance().getLog(name);
    }

    public Logger getLog(String name) {
        if (!loggers.containsKey(name)) {
            Logger value;
            try {
                value = (Logger)ServiceLocator.getInstance().newInstance(Logger.class);
            }
            catch (Exception e) {
                throw new ServiceNotFoundException(e);
            }
            value.setName(name);
            if (defaultLoggingLevel != null) {
                value.setLogLevel(defaultLoggingLevel);
            }
            loggers.put(name, value);
        }
        return loggers.get(name);
    }

    public static Logger getLogger() {
        return LogFactory.getInstance().getLog();
    }

    public Logger getLog() {
        return this.getLog("liquibase");
    }

    public void setDefaultLoggingLevel(String defaultLoggingLevel) {
        LogFactory.defaultLoggingLevel = defaultLoggingLevel;
    }

    public void setDefaultLoggingLevel(LogLevel defaultLoggingLevel) {
        LogFactory.defaultLoggingLevel = defaultLoggingLevel.name();
    }

    public static void setLoggingLevel(String defaultLoggingLevel) {
        LogFactory.getInstance();
        LogFactory.defaultLoggingLevel = defaultLoggingLevel;
    }
}

