/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ISODateFormat {
    private SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private SimpleDateFormat dateTimeFormatWithDecimal = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private SimpleDateFormat dateTimeFormatWithSpace = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat dateTimeFormatWithSpaceAndDecimal = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final String DATE_TIME_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String DATE_TIME_FORMAT_STRING_WITH_SPACE = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_TIME_FORMAT_STRING_WITH_DECIMAL = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String DATE_TIME_FORMAT_STRING_WITH_SPACE_AND_DECIMAL = "yyyy-MM-dd HH:mm:ss.SSS";

    public String format(java.sql.Date date) {
        return this.dateFormat.format(date);
    }

    public String format(Time date) {
        return this.timeFormat.format(date);
    }

    public String format(Timestamp date) {
        return this.dateTimeFormatWithDecimal.format(date);
    }

    public String format(Date date) {
        if (date == null) {
            return null;
        }
        if (date instanceof java.sql.Date) {
            return this.format((java.sql.Date)date);
        }
        if (date instanceof Time) {
            return this.format((Time)date);
        }
        if (date instanceof Timestamp) {
            return this.format((Timestamp)date);
        }
        throw new RuntimeException("Unknown type: " + date.getClass().getName());
    }

    public Date parse(String dateAsString) throws ParseException {
        SimpleDateFormat dateTimeFormat = this.dateTimeFormat;
        if (dateAsString.contains(".") && dateAsString.contains(" ")) {
            dateTimeFormat = this.dateTimeFormatWithSpaceAndDecimal;
        } else if (dateAsString.contains(".")) {
            dateTimeFormat = this.dateTimeFormatWithDecimal;
        } else if (dateAsString.contains(" ")) {
            dateTimeFormat = this.dateTimeFormatWithSpace;
        }
        if (dateAsString.length() != this.dateFormat.toPattern().length() && dateAsString.length() != this.timeFormat.toPattern().length()) {
            return new Timestamp(dateTimeFormat.parse(dateAsString).getTime());
        }
        if (dateAsString.indexOf(58) > 0) {
            return new Time(this.timeFormat.parse(dateAsString).getTime());
        }
        return new java.sql.Date(this.dateFormat.parse(dateAsString).getTime());
    }
}

