/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.jpa;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.EntityManager;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.jpa.UserSessionAdapter;
import org.keycloak.models.sessions.jpa.entities.ClientSessionEntity;
import org.keycloak.models.sessions.jpa.entities.ClientSessionNoteEntity;
import org.keycloak.models.sessions.jpa.entities.ClientSessionProtocolMapperEntity;
import org.keycloak.models.sessions.jpa.entities.ClientSessionRoleEntity;
import org.keycloak.models.sessions.jpa.entities.UserSessionEntity;

public class ClientSessionAdapter
implements ClientSessionModel {
    private KeycloakSession session;
    private ClientSessionEntity entity;
    private EntityManager em;
    private RealmModel realm;

    public ClientSessionAdapter(KeycloakSession session, EntityManager em, RealmModel realm, ClientSessionEntity entity) {
        this.session = session;
        this.em = em;
        this.realm = realm;
        this.entity = entity;
    }

    public RealmModel getRealm() {
        return this.session.realms().getRealm(this.entity.getRealmId());
    }

    public void setNote(String name, String value) {
        for (ClientSessionNoteEntity attr : this.entity.getNotes()) {
            if (!attr.getName().equals(name)) continue;
            attr.setValue(value);
            return;
        }
        ClientSessionNoteEntity attr = new ClientSessionNoteEntity();
        attr.setName(name);
        attr.setValue(value);
        attr.setClientSession(this.entity);
        this.em.persist((Object)attr);
        this.entity.getNotes().add(attr);
    }

    public void removeNote(String name) {
        Iterator<ClientSessionNoteEntity> it = this.entity.getNotes().iterator();
        while (it.hasNext()) {
            ClientSessionNoteEntity attr = it.next();
            if (!attr.getName().equals(name)) continue;
            it.remove();
            this.em.remove((Object)attr);
        }
    }

    public String getNote(String name) {
        for (ClientSessionNoteEntity attr : this.entity.getNotes()) {
            if (!attr.getName().equals(name)) continue;
            return attr.getValue();
        }
        return null;
    }

    public String getId() {
        return this.entity.getId();
    }

    public ClientModel getClient() {
        return this.realm.getClientById(this.entity.getClientId());
    }

    public void setUserSession(UserSessionModel userSession) {
        if (userSession == null) {
            if (this.entity.getSession() != null) {
                this.entity.getSession().getClientSessions().remove(this.entity);
            }
            this.entity.setSession(null);
        } else {
            UserSessionAdapter adapter = (UserSessionAdapter)userSession;
            UserSessionEntity userSessionEntity = adapter.getEntity();
            this.entity.setSession(userSessionEntity);
            userSessionEntity.getClientSessions().add(this.entity);
        }
    }

    public void setRedirectUri(String uri) {
        this.entity.setRedirectUri(uri);
    }

    public void setRoles(Set<String> roles) {
        if (roles != null) {
            for (String r : roles) {
                ClientSessionRoleEntity roleEntity = new ClientSessionRoleEntity();
                roleEntity.setClientSession(this.entity);
                roleEntity.setRoleId(r);
                this.em.persist((Object)roleEntity);
                this.entity.getRoles().add(roleEntity);
            }
        } else if (this.entity.getRoles() != null) {
            for (ClientSessionRoleEntity r : this.entity.getRoles()) {
                this.em.remove((Object)r);
            }
            this.entity.getRoles().clear();
        }
    }

    public String getAuthMethod() {
        return this.entity.getAuthMethod();
    }

    public void setAuthMethod(String method) {
        this.entity.setAuthMethod(method);
    }

    public UserSessionModel getUserSession() {
        if (this.entity.getSession() == null) {
            return null;
        }
        return new UserSessionAdapter(this.session, this.em, this.realm, this.entity.getSession());
    }

    public String getRedirectUri() {
        return this.entity.getRedirectUri();
    }

    public int getTimestamp() {
        return this.entity.getTimestamp();
    }

    public void setTimestamp(int timestamp) {
        this.entity.setTimestamp(timestamp);
    }

    public ClientSessionModel.Action getAction() {
        return this.entity.getAction();
    }

    public void setAction(ClientSessionModel.Action action) {
        this.entity.setAction(action);
    }

    public Set<String> getRoles() {
        HashSet<String> roles = new HashSet<String>();
        if (this.entity.getRoles() != null) {
            for (ClientSessionRoleEntity e : this.entity.getRoles()) {
                roles.add(e.getRoleId());
            }
        }
        return roles;
    }

    public Set<String> getProtocolMappers() {
        HashSet<String> protMappers = new HashSet<String>();
        if (this.entity.getProtocolMappers() != null) {
            for (ClientSessionProtocolMapperEntity e : this.entity.getProtocolMappers()) {
                protMappers.add(e.getProtocolMapperId());
            }
        }
        return protMappers;
    }

    public void setProtocolMappers(Set<String> protocolMappers) {
        if (protocolMappers != null) {
            for (String pm : protocolMappers) {
                ClientSessionProtocolMapperEntity protMapperEntity = new ClientSessionProtocolMapperEntity();
                protMapperEntity.setClientSession(this.entity);
                protMapperEntity.setProtocolMapperId(pm);
                this.em.persist((Object)protMapperEntity);
                this.entity.getProtocolMappers().add(protMapperEntity);
            }
        } else if (this.entity.getProtocolMappers() != null) {
            for (ClientSessionProtocolMapperEntity pm : this.entity.getProtocolMappers()) {
                this.em.remove((Object)pm);
            }
            this.entity.getProtocolMappers().clear();
        }
    }
}

