/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.apache.log4j.Appender;
import org.apache.log4j.JBossFilterWrapper;
import org.apache.log4j.JBossLogManagerFacade;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Logger;

final class JBossAppenderHandler
extends ExtHandler {
    private static final Logger.AttachmentKey<CopyOnWriteArrayList<Appender>> APPENDERS_KEY = new Logger.AttachmentKey();
    private final Logger logger;

    private JBossAppenderHandler(Logger logger) {
        this.logger = logger;
    }

    protected void doPublish(ExtLogRecord record) {
        LoggingEvent event = new LoggingEvent(record, JBossLogManagerFacade.getLogger(this.logger));
        CopyOnWriteArrayList<Appender> appenders = JBossAppenderHandler.getAppenderList(this.logger);
        for (Appender appender : appenders) {
            if (!new JBossFilterWrapper(appender.getFilter(), true).isLoggable((LogRecord)record)) continue;
            appender.doAppend(event);
        }
    }

    public void flush() {
    }

    public void close() throws SecurityException {
        JBossAppenderHandler.checkAccess((ExtHandler)this);
        JBossAppenderHandler.closeAppenders(this.logger);
    }

    public int hashCode() {
        int prime = 31;
        int hash = 17;
        hash = 31 * hash + (this.logger == null ? 0 : this.logger.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JBossAppenderHandler)) {
            return false;
        }
        JBossAppenderHandler other = (JBossAppenderHandler)((Object)obj);
        return this.logger == null ? other.logger == null : this.logger.equals(other.logger);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass() + "{" + this.logger.getName() + "}";
    }

    public static void attachAppender(Logger logger, Appender appender) {
        Handler[] newHandlers;
        Handler[] oldHandlers;
        block0: do {
            for (Handler handler : oldHandlers = logger.getHandlers()) {
                if (handler instanceof JBossAppenderHandler) break block0;
            }
            int size = oldHandlers.length;
            newHandlers = Arrays.copyOf(oldHandlers, size + 1);
            newHandlers[size] = new JBossAppenderHandler(logger);
        } while (!logger.compareAndSetHandlers(oldHandlers, newHandlers));
        JBossAppenderHandler.getAppenderList(logger).addIfAbsent(appender);
    }

    public static List<Appender> getAppenders(Logger logger) {
        CopyOnWriteArrayList<Appender> appenders = JBossAppenderHandler.getAppenderList(logger);
        if (appenders == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Appender>(appenders);
    }

    public static Appender getAppender(Logger logger, String name) {
        Appender result = null;
        if (name != null) {
            List<Appender> appenders = JBossAppenderHandler.getAppenders(logger);
            for (Appender appender : appenders) {
                if (!name.equals(appender.getName())) continue;
                result = appender;
                break;
            }
        }
        return result;
    }

    public static boolean isAppenderAttached(Logger logger, Appender appender) {
        return JBossAppenderHandler.getAppenders(logger).contains(appender);
    }

    public static List<Appender> removeAllAppenders(Logger logger) {
        List<Appender> result = Collections.emptyList();
        CopyOnWriteArrayList<Appender> currentAppenders = JBossAppenderHandler.getAppenderList(logger);
        if (currentAppenders != null && !currentAppenders.isEmpty()) {
            result = new ArrayList<Appender>(currentAppenders);
            currentAppenders.clear();
        }
        return result;
    }

    public static boolean removeAppender(Logger logger, Appender appender) {
        boolean result = false;
        CopyOnWriteArrayList<Appender> currentAppenders = JBossAppenderHandler.getAppenderList(logger);
        if (currentAppenders != null) {
            result = currentAppenders.remove(appender);
        }
        return result;
    }

    public static void closeAppenders(Logger logger) {
        CopyOnWriteArrayList<Appender> appenders = JBossAppenderHandler.getAppenderList(logger);
        for (Appender appender : appenders) {
            if (!(appender instanceof AppenderAttachable)) continue;
            appender.close();
        }
    }

    private static CopyOnWriteArrayList<Appender> getAppenderList(Logger logger) {
        CopyOnWriteArrayList current;
        CopyOnWriteArrayList result = (CopyOnWriteArrayList)logger.getAttachment(APPENDERS_KEY);
        if (result == null && (current = (CopyOnWriteArrayList)logger.attachIfAbsent(APPENDERS_KEY, result = new CopyOnWriteArrayList())) != null) {
            result = current;
        }
        return result;
    }
}

