/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.batch.api.chunk.CheckpointAlgorithm;
import javax.batch.api.chunk.ItemProcessor;
import javax.batch.api.chunk.ItemReader;
import javax.batch.api.chunk.ItemWriter;
import javax.batch.api.chunk.listener.ChunkListener;
import javax.batch.api.chunk.listener.ItemProcessListener;
import javax.batch.api.chunk.listener.ItemReadListener;
import javax.batch.api.chunk.listener.ItemWriteListener;
import javax.batch.api.chunk.listener.RetryProcessListener;
import javax.batch.api.chunk.listener.RetryReadListener;
import javax.batch.api.chunk.listener.RetryWriteListener;
import javax.batch.api.chunk.listener.SkipProcessListener;
import javax.batch.api.chunk.listener.SkipReadListener;
import javax.batch.api.chunk.listener.SkipWriteListener;
import javax.batch.api.partition.PartitionCollector;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;
import javax.transaction.TransactionManager;
import org.jberet._private.BatchLogger;
import org.jberet._private.BatchMessages;
import org.jberet.job.model.Chunk;
import org.jberet.job.model.ExceptionClassFilter;
import org.jberet.job.model.Listeners;
import org.jberet.job.model.Properties;
import org.jberet.job.model.RefArtifact;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.runtime.metric.StepMetrics;
import org.jberet.runtime.runner.AbstractRunner;
import org.jberet.runtime.runner.CompositeExecutionRunner;
import org.jberet.runtime.runner.StepExecutionRunner;

public final class ChunkRunner
extends AbstractRunner<StepContextImpl>
implements Runnable {
    private final List<Object> allChunkRelatedListeners = new ArrayList<Object>();
    private final List<ChunkListener> chunkListeners = new ArrayList<ChunkListener>();
    private final List<SkipWriteListener> skipWriteListeners = new ArrayList<SkipWriteListener>();
    private final List<SkipProcessListener> skipProcessListeners = new ArrayList<SkipProcessListener>();
    private final List<SkipReadListener> skipReadListeners = new ArrayList<SkipReadListener>();
    private final List<RetryReadListener> retryReadListeners = new ArrayList<RetryReadListener>();
    private final List<RetryWriteListener> retryWriteListeners = new ArrayList<RetryWriteListener>();
    private final List<RetryProcessListener> retryProcessListeners = new ArrayList<RetryProcessListener>();
    private final List<ItemReadListener> itemReadListeners = new ArrayList<ItemReadListener>();
    private final List<ItemWriteListener> itemWriteListeners = new ArrayList<ItemWriteListener>();
    private final List<ItemProcessListener> itemProcessListeners = new ArrayList<ItemProcessListener>();
    private final Chunk chunk;
    private final StepExecutionRunner stepRunner;
    private final StepMetrics stepMetrics;
    private AbstractStepExecution stepOrPartitionExecution;
    private final ItemReader itemReader;
    private final ItemWriter itemWriter;
    private ItemProcessor itemProcessor;
    private PartitionCollector collector;
    private String checkpointPolicy = "item";
    private CheckpointAlgorithm checkpointAlgorithm;
    private int itemCount = 10;
    private int timeLimit;
    private int skipLimit;
    private int retryLimit;
    private final ExceptionClassFilter skippableExceptionClasses;
    private final ExceptionClassFilter retryableExceptionClasses;
    private final ExceptionClassFilter noRollbackExceptionClasses;
    private int skipCount;
    private int retryCount;
    private Object itemRead;
    private final List<Object> outputList = new ArrayList<Object>();
    private final TransactionManager tm;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ChunkRunner(StepContextImpl stepContext, CompositeExecutionRunner enclosingRunner, StepExecutionRunner stepRunner, Chunk chunk) {
        super(stepContext, enclosingRunner);
        String attrVal;
        RefArtifact collectorConfig;
        this.stepRunner = stepRunner;
        this.chunk = chunk;
        this.stepOrPartitionExecution = stepContext.getStepExecution();
        this.stepMetrics = this.stepOrPartitionExecution.getStepMetrics();
        RefArtifact readerElement = chunk.getReader();
        this.itemReader = (ItemReader)this.jobContext.createArtifact(readerElement.getRef(), null, readerElement.getProperties(), (StepContextImpl)this.batchContext);
        RefArtifact writerElement = chunk.getWriter();
        this.itemWriter = (ItemWriter)this.jobContext.createArtifact(writerElement.getRef(), null, writerElement.getProperties(), (StepContextImpl)this.batchContext);
        RefArtifact processorElement = chunk.getProcessor();
        if (processorElement != null) {
            this.itemProcessor = (ItemProcessor)this.jobContext.createArtifact(processorElement.getRef(), null, processorElement.getProperties(), (StepContextImpl)this.batchContext);
        }
        if (stepRunner.collectorDataQueue != null && (collectorConfig = ((StepContextImpl)this.batchContext).getStep().getPartition().getCollector()) != null) {
            this.collector = (PartitionCollector)this.jobContext.createArtifact(collectorConfig.getRef(), null, collectorConfig.getProperties(), (StepContextImpl)this.batchContext);
        }
        if ((attrVal = chunk.getCheckpointPolicy()) == null || attrVal.equals("item")) {
            attrVal = chunk.getItemCount();
            if (attrVal != null) {
                this.itemCount = Integer.parseInt(attrVal);
                if (this.itemCount < 1) {
                    throw BatchMessages.MESSAGES.invalidItemCount(this.itemCount);
                }
            }
            if ((attrVal = chunk.getTimeLimit()) != null) {
                this.timeLimit = Integer.parseInt(attrVal);
            }
        } else {
            if (!attrVal.equals("custom")) throw BatchMessages.MESSAGES.invalidCheckpointPolicy(attrVal);
            this.checkpointPolicy = "custom";
            RefArtifact alg = chunk.getCheckpointAlgorithm();
            if (alg == null) throw BatchMessages.MESSAGES.checkpointAlgorithmMissing(stepRunner.step.getId());
            this.checkpointAlgorithm = (CheckpointAlgorithm)this.jobContext.createArtifact(alg.getRef(), null, alg.getProperties(), (StepContextImpl)this.batchContext);
        }
        this.skipLimit = (attrVal = chunk.getSkipLimit()) == null ? -1 : Integer.parseInt(attrVal);
        attrVal = chunk.getRetryLimit();
        this.retryLimit = attrVal == null ? -1 : Integer.parseInt(attrVal);
        this.skippableExceptionClasses = chunk.getSkippableExceptionClasses();
        this.retryableExceptionClasses = chunk.getRetryableExceptionClasses();
        this.noRollbackExceptionClasses = chunk.getNoRollbackExceptionClasses();
        this.tm = stepRunner.tm;
        this.createChunkRelatedListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block23: {
            block22: {
                String globalTimeoutProp;
                Properties stepProps = this.stepRunner.step.getProperties();
                int globalTimeout = 180;
                if (stepProps != null && (globalTimeoutProp = stepProps.get("javax.transaction.global.timeout")) != null) {
                    globalTimeout = Integer.valueOf(globalTimeoutProp);
                }
                this.tm.setTransactionTimeout(globalTimeout);
                this.tm.begin();
                try {
                    this.itemReader.open(this.stepOrPartitionExecution.getReaderCheckpointInfo());
                    this.itemWriter.open(this.stepOrPartitionExecution.getWriterCheckpointInfo());
                    this.tm.commit();
                }
                catch (Exception e) {
                    this.tm.rollback();
                    this.safeClose();
                    throw e;
                }
                this.readProcessWriteItems();
                this.tm.begin();
                try {
                    this.itemReader.close();
                    this.itemWriter.close();
                    this.tm.commit();
                }
                catch (Exception e) {
                    this.tm.rollback();
                    this.safeClose();
                    throw e;
                }
                if (this.collector != null) {
                    this.stepRunner.collectorDataQueue.put(this.collector.collectPartitionData());
                }
                if (((StepContextImpl)this.batchContext).getBatchStatus() != BatchStatus.STARTED) break block22;
                ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.COMPLETED);
            }
            try {
                if (this.stepRunner.collectorDataQueue != null) {
                    this.stepRunner.collectorDataQueue.put(this.stepOrPartitionExecution);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.stepRunner.completedPartitionThreads != null) {
                this.stepRunner.completedPartitionThreads.offer(Boolean.TRUE);
            }
            this.jobContext.destroyArtifact(this.itemReader, this.itemWriter, this.itemProcessor, this.collector, this.checkpointAlgorithm);
            this.jobContext.destroyArtifact(this.allChunkRelatedListeners);
            this.safeClose();
            break block23;
            catch (Exception e) {
                try {
                    ((StepContextImpl)this.batchContext).setException(e);
                    BatchLogger.LOGGER.failToRunJob(e, this.jobContext.getJobName(), ((StepContextImpl)this.batchContext).getStepName(), this.chunk);
                    ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
                }
                catch (Throwable throwable) {
                    try {
                        if (this.stepRunner.collectorDataQueue != null) {
                            this.stepRunner.collectorDataQueue.put(this.stepOrPartitionExecution);
                        }
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    if (this.stepRunner.completedPartitionThreads != null) {
                        this.stepRunner.completedPartitionThreads.offer(Boolean.TRUE);
                    }
                    this.jobContext.destroyArtifact(this.itemReader, this.itemWriter, this.itemProcessor, this.collector, this.checkpointAlgorithm);
                    this.jobContext.destroyArtifact(this.allChunkRelatedListeners);
                    this.safeClose();
                    throw throwable;
                }
                try {
                    if (this.stepRunner.collectorDataQueue != null) {
                        this.stepRunner.collectorDataQueue.put(this.stepOrPartitionExecution);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.stepRunner.completedPartitionThreads != null) {
                    this.stepRunner.completedPartitionThreads.offer(Boolean.TRUE);
                }
                this.jobContext.destroyArtifact(this.itemReader, this.itemWriter, this.itemProcessor, this.collector, this.checkpointAlgorithm);
                this.jobContext.destroyArtifact(this.allChunkRelatedListeners);
                this.safeClose();
            }
        }
    }

    private void readProcessWriteItems() throws Exception {
        ProcessingInfo processingInfo = new ProcessingInfo();
        while (processingInfo.chunkState != ChunkState.JOB_STOPPED && (processingInfo.chunkState != ChunkState.DEPLETED || processingInfo.itemState == ItemState.TO_RETRY_READ || processingInfo.itemState == ItemState.TO_RETRY_PROCESS || processingInfo.itemState == ItemState.TO_RETRY_WRITE)) {
            try {
                switch (processingInfo.itemState) {
                    case TO_SKIP: {
                        processingInfo.itemState = ItemState.RUNNING;
                        break;
                    }
                    case TO_RETRY_READ: {
                        processingInfo.itemState = ItemState.RETRYING_READ;
                        break;
                    }
                    case TO_RETRY_PROCESS: {
                        processingInfo.itemState = ItemState.RETRYING_PROCESS;
                        break;
                    }
                    case TO_RETRY_WRITE: {
                        processingInfo.itemState = ItemState.RETRYING_WRITE;
                    }
                }
                if (processingInfo.chunkState == ChunkState.TO_START_NEW || processingInfo.chunkState == ChunkState.TO_RETRY || processingInfo.chunkState == ChunkState.RETRYING || processingInfo.chunkState == ChunkState.TO_END_RETRY) {
                    if (processingInfo.chunkState == ChunkState.TO_START_NEW || processingInfo.chunkState == ChunkState.TO_END_RETRY) {
                        processingInfo.reset();
                    }
                    if (this.tm.getStatus() != 0) {
                        if (this.checkpointAlgorithm != null) {
                            this.tm.setTransactionTimeout(this.checkpointAlgorithm.checkpointTimeout());
                            this.checkpointAlgorithm.beginCheckpoint();
                        }
                        this.tm.begin();
                    }
                    for (ChunkListener l : this.chunkListeners) {
                        l.beforeChunk();
                    }
                    this.beginCheckpoint(processingInfo);
                }
                if (processingInfo.itemState != ItemState.RETRYING_PROCESS && processingInfo.itemState != ItemState.RETRYING_WRITE) {
                    this.readItem(processingInfo);
                }
                if (this.itemRead != null && processingInfo.itemState != ItemState.RETRYING_WRITE) {
                    this.processItem(processingInfo);
                }
                if (processingInfo.toStopItem() || !this.isReadyToCheckpoint(processingInfo)) continue;
                try {
                    this.doCheckpoint(processingInfo);
                    if (processingInfo.chunkState == ChunkState.TO_RETRY || processingInfo.itemState == ItemState.TO_RETRY_WRITE || processingInfo.itemState == ItemState.TO_SKIP) continue;
                    for (ChunkListener l : this.chunkListeners) {
                        l.afterChunk();
                    }
                }
                catch (Exception e) {
                    this.tm.rollback();
                    this.stepMetrics.increment(Metric.MetricType.ROLLBACK_COUNT, 1L);
                    throw e;
                }
                this.tm.commit();
                if (this.checkpointAlgorithm != null) {
                    this.checkpointAlgorithm.endCheckpoint();
                }
                this.stepMetrics.increment(Metric.MetricType.COMMIT_COUNT, 1L);
            }
            catch (Exception e) {
                int txStatus = this.tm.getStatus();
                if (txStatus == 0 || txStatus == 1 || txStatus == 2 || txStatus == 7 || txStatus == 8 || txStatus == 9) {
                    this.tm.rollback();
                }
                for (ChunkListener l : this.chunkListeners) {
                    l.onError(e);
                }
                throw e;
            }
        }
    }

    private void readItem(ProcessingInfo processingInfo) throws Exception {
        block15: {
            try {
                for (ItemReadListener l : this.itemReadListeners) {
                    l.beforeRead();
                }
                this.itemRead = this.itemReader.readItem();
                if (this.itemRead != null) {
                    this.stepMetrics.increment(Metric.MetricType.READ_COUNT, 1L);
                    ++processingInfo.count;
                } else {
                    processingInfo.chunkState = ChunkState.DEPLETED;
                }
                for (ItemReadListener l : this.itemReadListeners) {
                    l.afterRead(this.itemRead);
                }
            }
            catch (Exception e) {
                for (ItemReadListener itemReadListener : this.itemReadListeners) {
                    itemReadListener.onReadError(e);
                }
                this.toSkipOrRetry(e, processingInfo);
                if (processingInfo.itemState == ItemState.TO_SKIP) {
                    for (SkipReadListener skipReadListener : this.skipReadListeners) {
                        skipReadListener.onSkipReadItem(e);
                    }
                    this.stepMetrics.increment(Metric.MetricType.READ_SKIP_COUNT, 1L);
                    ++this.skipCount;
                    this.itemRead = null;
                } else if (processingInfo.itemState == ItemState.TO_RETRY) {
                    for (RetryReadListener retryReadListener : this.retryReadListeners) {
                        retryReadListener.onRetryReadException(e);
                    }
                    ++this.retryCount;
                    if (this.needRollbackBeforeRetry(e)) {
                        this.rollbackCheckpoint(processingInfo);
                    } else {
                        processingInfo.itemState = ItemState.TO_RETRY_READ;
                    }
                    this.itemRead = null;
                } else {
                    throw e;
                }
                this.checkIfEndRetry(processingInfo, this.itemReader.checkpointInfo());
                if (processingInfo.itemState != ItemState.RETRYING_READ) break block15;
                processingInfo.itemState = ItemState.RUNNING;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processItem(ProcessingInfo processingInfo) throws Exception {
        Object output;
        block17: {
            if (this.itemProcessor != null) {
                try {
                    for (ItemProcessListener l : this.itemProcessListeners) {
                        l.beforeProcess(this.itemRead);
                    }
                    output = this.itemProcessor.processItem(this.itemRead);
                    for (ItemProcessListener l : this.itemProcessListeners) {
                        l.afterProcess(this.itemRead, output);
                    }
                    if (output == null) {
                        this.stepMetrics.increment(Metric.MetricType.FILTER_COUNT, 1L);
                    }
                }
                catch (Exception e) {
                    for (ItemProcessListener itemProcessListener : this.itemProcessListeners) {
                        itemProcessListener.onProcessError(this.itemRead, e);
                    }
                    this.toSkipOrRetry(e, processingInfo);
                    if (processingInfo.itemState == ItemState.TO_SKIP) {
                        for (SkipProcessListener skipProcessListener : this.skipProcessListeners) {
                            skipProcessListener.onSkipProcessItem(this.itemRead, e);
                        }
                        this.stepMetrics.increment(Metric.MetricType.PROCESS_SKIP_COUNT, 1L);
                        ++this.skipCount;
                        output = null;
                        break block17;
                    }
                    if (processingInfo.itemState != ItemState.TO_RETRY) {
                        throw e;
                    }
                    for (RetryProcessListener retryProcessListener : this.retryProcessListeners) {
                        retryProcessListener.onRetryProcessException(this.itemRead, e);
                    }
                    ++this.retryCount;
                    if (this.needRollbackBeforeRetry(e)) {
                        this.rollbackCheckpoint(processingInfo);
                    } else {
                        processingInfo.itemState = ItemState.TO_RETRY_PROCESS;
                    }
                    output = null;
                }
            } else {
                output = this.itemRead;
            }
        }
        if (output != null) {
            this.outputList.add(output);
        }
        if (processingInfo.itemState != ItemState.TO_RETRY_PROCESS) {
            this.itemRead = null;
        }
        this.checkIfEndRetry(processingInfo, this.itemReader.checkpointInfo());
        if (processingInfo.itemState == ItemState.RETRYING_PROCESS) {
            processingInfo.itemState = ItemState.RUNNING;
        }
    }

    private void checkIfEndRetry(ProcessingInfo processingInfo, Serializable currentPosition) {
        if (processingInfo.chunkState == ChunkState.RETRYING && processingInfo.itemState != ItemState.TO_RETRY_READ && processingInfo.itemState != ItemState.TO_RETRY_PROCESS && processingInfo.itemState != ItemState.TO_RETRY_WRITE && processingInfo.failurePoint.equals(currentPosition)) {
            processingInfo.chunkState = ChunkState.TO_END_RETRY;
        }
    }

    private void beginCheckpoint(final ProcessingInfo processingInfo) throws Exception {
        if (this.checkpointPolicy.equals("item") && this.timeLimit > 0) {
            Timer timer = new Timer("chunk-checkpoint-timer", true);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    processingInfo.timerExpired = true;
                }
            }, this.timeLimit * 1000);
        }
        if (processingInfo.chunkState == ChunkState.TO_RETRY) {
            processingInfo.chunkState = ChunkState.RETRYING;
        } else if (processingInfo.chunkState != ChunkState.RETRYING) {
            processingInfo.chunkState = ChunkState.RUNNING;
        }
    }

    private boolean isReadyToCheckpoint(ProcessingInfo processingInfo) throws Exception {
        if (this.jobContext.getJobExecution().isStopRequested()) {
            processingInfo.chunkState = ChunkState.JOB_STOPPING;
            return true;
        }
        if (processingInfo.chunkState == ChunkState.DEPLETED || processingInfo.chunkState == ChunkState.RETRYING || processingInfo.chunkState == ChunkState.TO_END_RETRY) {
            return true;
        }
        if (this.checkpointPolicy.equals("item")) {
            if (processingInfo.count >= this.itemCount) {
                return true;
            }
            if (this.timeLimit > 0) {
                return processingInfo.timerExpired;
            }
            return false;
        }
        return this.checkpointAlgorithm.isReadyToCheckpoint();
    }

    private void doCheckpoint(ProcessingInfo processingInfo) throws Exception {
        int outputSize = this.outputList.size();
        if (outputSize == 0 && processingInfo.chunkState == ChunkState.DEPLETED) {
            return;
        }
        try {
            for (ItemWriteListener l : this.itemWriteListeners) {
                l.beforeWrite(this.outputList);
            }
            this.itemWriter.writeItems(this.outputList);
            this.stepMetrics.increment(Metric.MetricType.WRITE_COUNT, outputSize);
            for (ItemWriteListener l : this.itemWriteListeners) {
                l.afterWrite(this.outputList);
            }
            this.stepOrPartitionExecution.setReaderCheckpointInfo(this.itemReader.checkpointInfo());
            this.stepOrPartitionExecution.setWriterCheckpointInfo(this.itemWriter.checkpointInfo());
            ((StepContextImpl)this.batchContext).savePersistentData();
            this.outputList.clear();
            if (processingInfo.chunkState == ChunkState.JOB_STOPPING) {
                processingInfo.chunkState = ChunkState.JOB_STOPPED;
                ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.STOPPED);
            } else if (processingInfo.chunkState != ChunkState.DEPLETED && processingInfo.chunkState != ChunkState.RETRYING) {
                processingInfo.chunkState = ChunkState.TO_START_NEW;
            }
            if (this.collector != null) {
                this.stepRunner.collectorDataQueue.put(this.collector.collectPartitionData());
            }
        }
        catch (Exception e) {
            for (ItemWriteListener itemWriteListener : this.itemWriteListeners) {
                itemWriteListener.onWriteError(this.outputList, e);
            }
            this.toSkipOrRetry(e, processingInfo);
            if (processingInfo.itemState == ItemState.TO_SKIP) {
                if (processingInfo.chunkState == ChunkState.JOB_STOPPING) {
                    processingInfo.chunkState = ChunkState.JOB_STOPPED;
                    ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.STOPPED);
                } else if (processingInfo.chunkState != ChunkState.JOB_STOPPED) {
                    for (SkipWriteListener skipWriteListener : this.skipWriteListeners) {
                        skipWriteListener.onSkipWriteItem(this.outputList, e);
                    }
                    this.stepMetrics.increment(Metric.MetricType.WRITE_SKIP_COUNT, 1L);
                    this.skipCount += outputSize;
                }
            }
            if (processingInfo.itemState == ItemState.TO_RETRY) {
                for (RetryWriteListener retryWriteListener : this.retryWriteListeners) {
                    retryWriteListener.onRetryWriteException(this.outputList, e);
                }
                ++this.retryCount;
                if (this.needRollbackBeforeRetry(e)) {
                    this.rollbackCheckpoint(processingInfo);
                } else {
                    processingInfo.itemState = ItemState.TO_RETRY_WRITE;
                }
            }
            throw e;
        }
        this.checkIfEndRetry(processingInfo, this.itemReader.checkpointInfo());
        if (processingInfo.itemState == ItemState.RETRYING_WRITE) {
            processingInfo.itemState = ItemState.RUNNING;
        }
    }

    private void rollbackCheckpoint(ProcessingInfo processingInfo) throws Exception {
        this.outputList.clear();
        processingInfo.failurePoint = this.itemReader.checkpointInfo();
        this.tm.rollback();
        this.stepMetrics.increment(Metric.MetricType.ROLLBACK_COUNT, 1L);
        try {
            this.itemReader.close();
            this.itemWriter.close();
        }
        catch (Exception e) {
            this.safeClose();
            throw e;
        }
        try {
            this.itemReader.open(this.stepOrPartitionExecution.getReaderCheckpointInfo());
            this.itemWriter.open(this.stepOrPartitionExecution.getWriterCheckpointInfo());
        }
        catch (Exception e) {
            this.safeClose();
            throw e;
        }
        processingInfo.chunkState = ChunkState.TO_RETRY;
        processingInfo.itemState = ItemState.RUNNING;
        if (this.collector != null) {
            this.stepRunner.collectorDataQueue.put(this.collector.collectPartitionData());
        }
    }

    private boolean needSkip(Exception e) {
        return this.skippableExceptionClasses != null && (this.skipLimit >= 0 && this.skipCount < this.skipLimit || this.skipLimit < 0) && this.skippableExceptionClasses.matches(e.getClass());
    }

    private boolean needRetry(Exception e) {
        return this.retryableExceptionClasses != null && (this.retryLimit >= 0 && this.retryCount < this.retryLimit || this.retryLimit < 0) && this.retryableExceptionClasses.matches(e.getClass());
    }

    private void toSkipOrRetry(Exception e, ProcessingInfo processingInfo) {
        if (processingInfo.chunkState == ChunkState.RETRYING || processingInfo.chunkState == ChunkState.TO_END_RETRY || processingInfo.itemState == ItemState.RETRYING_READ || processingInfo.itemState == ItemState.RETRYING_PROCESS || processingInfo.itemState == ItemState.RETRYING_WRITE) {
            if (this.needSkip(e)) {
                processingInfo.itemState = ItemState.TO_SKIP;
                return;
            }
            if (this.needRetry(e)) {
                processingInfo.itemState = ItemState.TO_RETRY;
                return;
            }
        } else {
            if (this.needRetry(e)) {
                processingInfo.itemState = ItemState.TO_RETRY;
                return;
            }
            if (this.needSkip(e)) {
                processingInfo.itemState = ItemState.TO_SKIP;
                return;
            }
        }
    }

    private boolean needRollbackBeforeRetry(Exception e) {
        return this.noRollbackExceptionClasses == null || !this.noRollbackExceptionClasses.matches(e.getClass());
    }

    private void createChunkRelatedListeners() {
        Listeners listeners = ((StepContextImpl)this.batchContext).getStep().getListeners();
        if (listeners == null) {
            return;
        }
        for (RefArtifact l : listeners.getListeners()) {
            String ref = l.getRef();
            Class<?> cls = null;
            if (this.stepRunner.chunkRelatedListeners != null) {
                cls = this.stepRunner.chunkRelatedListeners.get(ref);
            }
            Object o = this.jobContext.createArtifact(ref, cls, l.getProperties(), (StepContextImpl)this.batchContext);
            this.allChunkRelatedListeners.add(o);
            if (o instanceof ChunkListener) {
                this.chunkListeners.add((ChunkListener)o);
            }
            if (o instanceof ItemReadListener) {
                this.itemReadListeners.add((ItemReadListener)o);
            }
            if (o instanceof ItemWriteListener) {
                this.itemWriteListeners.add((ItemWriteListener)o);
            }
            if (o instanceof ItemProcessListener) {
                this.itemProcessListeners.add((ItemProcessListener)o);
            }
            if (o instanceof SkipReadListener) {
                this.skipReadListeners.add((SkipReadListener)o);
            }
            if (o instanceof SkipWriteListener) {
                this.skipWriteListeners.add((SkipWriteListener)o);
            }
            if (o instanceof SkipProcessListener) {
                this.skipProcessListeners.add((SkipProcessListener)o);
            }
            if (o instanceof RetryReadListener) {
                this.retryReadListeners.add((RetryReadListener)o);
            }
            if (o instanceof RetryWriteListener) {
                this.retryWriteListeners.add((RetryWriteListener)o);
            }
            if (!(o instanceof RetryProcessListener)) continue;
            this.retryProcessListeners.add((RetryProcessListener)o);
        }
    }

    private void safeClose() {
        try {
            if (this.itemReader != null) {
                this.itemReader.close();
            }
        }
        catch (Exception e) {
            BatchLogger.LOGGER.trace("Error closing ItemReader.", e);
        }
        try {
            if (this.itemWriter != null) {
                this.itemWriter.close();
            }
        }
        catch (Exception e) {
            BatchLogger.LOGGER.trace("Error closing ItemWriter.", e);
        }
    }

    private static enum ChunkState {
        RUNNING,
        TO_RETRY,
        RETRYING,
        TO_END_RETRY,
        TO_START_NEW,
        DEPLETED,
        JOB_STOPPING,
        JOB_STOPPED;

    }

    private static enum ItemState {
        RUNNING,
        TO_SKIP,
        TO_RETRY,
        TO_RETRY_READ,
        RETRYING_READ,
        TO_RETRY_PROCESS,
        RETRYING_PROCESS,
        TO_RETRY_WRITE,
        RETRYING_WRITE;

    }

    private static final class ProcessingInfo {
        int count;
        boolean timerExpired;
        ItemState itemState = ItemState.RUNNING;
        ChunkState chunkState = ChunkState.TO_START_NEW;
        Serializable failurePoint;

        private ProcessingInfo() {
        }

        private void reset() {
            this.count = 0;
            this.timerExpired = false;
            this.itemState = ItemState.RUNNING;
            this.chunkState = ChunkState.RUNNING;
            this.failurePoint = null;
        }

        private boolean toStopItem() {
            return this.itemState == ItemState.TO_SKIP || this.itemState == ItemState.TO_RETRY || this.itemState == ItemState.TO_RETRY_READ || this.itemState == ItemState.TO_RETRY_PROCESS || this.itemState == ItemState.TO_RETRY_WRITE;
        }
    }
}

