/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.ChannelBusyException;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.MessageCancelledException;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.NotOpenException;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.remote.Equaller;
import org.jboss.remoting3.remote.InboundMessage;
import org.jboss.remoting3.remote.IntIndexHashMap;
import org.jboss.remoting3.remote.IntIndexMap;
import org.jboss.remoting3.remote.IntIndexer;
import org.jboss.remoting3.remote.OutboundMessage;
import org.jboss.remoting3.remote.ProtocolUtils;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.RemoteLogger;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.xnio.Bits;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.Pooled;

final class RemoteConnectionChannel
extends AbstractHandleableCloseable<Channel>
implements Channel {
    static final IntIndexer<RemoteConnectionChannel> INDEXER = new IntIndexer<RemoteConnectionChannel>(){

        @Override
        public int getKey(RemoteConnectionChannel argument) {
            return argument.channelId;
        }

        public boolean equals(RemoteConnectionChannel argument, int index) {
            return argument.channelId == index;
        }
    };
    private final RemoteConnectionHandler connectionHandler;
    private final ConnectionHandlerContext connectionHandlerContext;
    private final RemoteConnection connection;
    private final int channelId;
    private final IntIndexMap<OutboundMessage> outboundMessages = new IntIndexHashMap<Object>(OutboundMessage.INDEXER, Equaller.IDENTITY, 512, 0.5f);
    private final IntIndexMap<InboundMessage> inboundMessages = new IntIndexHashMap<Object>(InboundMessage.INDEXER, Equaller.IDENTITY, 512, 0.5f);
    private final int outboundWindow;
    private final int inboundWindow;
    private final Attachments attachments = new Attachments();
    private final Queue<InboundMessage> inboundMessageQueue = new ArrayDeque<InboundMessage>();
    private final int maxOutboundMessages;
    private final int maxInboundMessages;
    private final long maxOutboundMessageSize;
    private final long maxInboundMessageSize;
    private volatile int channelState = 0;
    private static final AtomicIntegerFieldUpdater<RemoteConnectionChannel> channelStateUpdater = AtomicIntegerFieldUpdater.newUpdater(RemoteConnectionChannel.class, "channelState");
    private Channel.Receiver nextReceiver;
    private static final int WRITE_CLOSED = Integer.MIN_VALUE;
    private static final int READ_CLOSED = 0x40000000;
    private static final int OUTBOUND_MESSAGES_MASK = Short.MAX_VALUE;
    private static final int ONE_OUTBOUND_MESSAGE = 1;
    private static final int INBOUND_MESSAGES_MASK = 1073709056;
    private static final int ONE_INBOUND_MESSAGE = 32768;
    private static Set<Option<?>> SUPPORTED_OPTIONS = Option.setBuilder().add(RemotingOptions.MAX_INBOUND_MESSAGES).add(RemotingOptions.MAX_OUTBOUND_MESSAGES).add(RemotingOptions.TRANSMIT_WINDOW_SIZE).add(RemotingOptions.RECEIVE_WINDOW_SIZE).add(RemotingOptions.MAX_INBOUND_MESSAGE_SIZE).add(RemotingOptions.MAX_OUTBOUND_MESSAGE_SIZE).create();

    RemoteConnectionChannel(RemoteConnectionHandler connectionHandler, RemoteConnection connection, int channelId, int outboundWindow, int inboundWindow, int maxOutboundMessages, int maxInboundMessages, long maxOutboundMessageSize, long maxInboundMessageSize) {
        super(connectionHandler.getConnectionContext().getConnectionProviderContext().getExecutor(), true);
        this.maxOutboundMessageSize = maxOutboundMessageSize;
        this.maxInboundMessageSize = maxInboundMessageSize;
        this.connectionHandlerContext = connectionHandler.getConnectionContext();
        this.connectionHandler = connectionHandler;
        this.connection = connection;
        this.channelId = channelId;
        this.outboundWindow = outboundWindow;
        this.inboundWindow = inboundWindow;
        this.maxOutboundMessages = maxOutboundMessages;
        this.maxInboundMessages = maxInboundMessages;
    }

    void openOutboundMessage() throws IOException {
        int newState;
        int oldState;
        do {
            if (((oldState = this.channelState) & Integer.MIN_VALUE) != 0) {
                throw new NotOpenException("Writes closed");
            }
            int outboundCount = oldState & Short.MAX_VALUE;
            if (outboundCount != this.maxOutboundMessages) continue;
            throw new ChannelBusyException("Too many open outbound writes");
        } while (!this.casState(oldState, newState = oldState + 1));
        RemoteLogger.log.tracef("Opened outbound message on %s", this);
    }

    private int incrementState(int count) {
        int oldState = channelStateUpdater.getAndAdd(this, count);
        if (RemoteLogger.log.isTraceEnabled()) {
            int newState = oldState + count;
            RemoteLogger.log.tracef("CAS %s\n\told: RS=%s WS=%s IM=%d OM=%d\n\tnew: RS=%s WS=%s IM=%d OM=%d", new Object[]{this, (oldState & 0x40000000) != 0, (oldState & Integer.MIN_VALUE) != 0, (oldState & 0x3FFF8000) >> Integer.numberOfTrailingZeros(32768), (oldState & Short.MAX_VALUE) >> Integer.numberOfTrailingZeros(1), (newState & 0x40000000) != 0, (newState & Integer.MIN_VALUE) != 0, (newState & 0x3FFF8000) >> Integer.numberOfTrailingZeros(32768), (newState & Short.MAX_VALUE) >> Integer.numberOfTrailingZeros(1)});
        }
        return oldState;
    }

    private boolean casState(int oldState, int newState) {
        boolean result = channelStateUpdater.compareAndSet(this, oldState, newState);
        if (result && RemoteLogger.log.isTraceEnabled()) {
            RemoteLogger.log.tracef("CAS %s\n\told: RS=%s WS=%s IM=%d OM=%d\n\tnew: RS=%s WS=%s IM=%d OM=%d", new Object[]{this, (oldState & 0x40000000) != 0, (oldState & Integer.MIN_VALUE) != 0, (oldState & 0x3FFF8000) >> Integer.numberOfTrailingZeros(32768), (oldState & Short.MAX_VALUE) >> Integer.numberOfTrailingZeros(1), (newState & 0x40000000) != 0, (newState & Integer.MIN_VALUE) != 0, (newState & 0x3FFF8000) >> Integer.numberOfTrailingZeros(32768), (newState & Short.MAX_VALUE) >> Integer.numberOfTrailingZeros(1)});
        }
        return result;
    }

    void closeOutboundMessage() {
        int oldState = this.incrementState(-1);
        if (oldState == -1073741824) {
            RemoteLogger.log.tracef("Closed outbound message on %s (unregistering)", this);
            this.unregister();
        } else {
            RemoteLogger.log.tracef("Closed outbound message on %s", this);
        }
    }

    boolean openInboundMessage() {
        int newState;
        int oldState;
        do {
            if (((oldState = this.channelState) & 0x40000000) != 0) {
                RemoteLogger.log.tracef("Refusing inbound message on %s (reads closed)", this);
                return false;
            }
            int inboundCount = oldState & 0x3FFF8000;
            if (inboundCount != this.maxInboundMessages) continue;
            RemoteLogger.log.tracef("Refusing inbound message on %s (too many concurrent reads)", this);
            return false;
        } while (!this.casState(oldState, newState = oldState + 32768));
        RemoteLogger.log.tracef("Opened inbound message on %s", this);
        return true;
    }

    void closeInboundMessage() {
        int oldState = this.incrementState(Short.MIN_VALUE);
        if (oldState == -1073741824) {
            RemoteLogger.log.tracef("Closed inbound message on %s (unregistering)", this);
            this.unregister();
        } else {
            RemoteLogger.log.tracef("Closed inbound message on %s", this);
        }
    }

    void closeReads() {
        int newState;
        int oldState;
        do {
            if (((oldState = this.channelState) & 0x40000000) == 0) continue;
            return;
        } while (!this.casState(oldState, newState = oldState | 0x40000000));
        if (oldState == Integer.MIN_VALUE) {
            RemoteLogger.log.tracef("Closed channel reads on %s (unregistering)", this);
            this.unregister();
        } else {
            RemoteLogger.log.tracef("Closed channel reads on %s", this);
        }
        this.notifyEnd();
    }

    boolean closeWrites() {
        int newState;
        int oldState;
        do {
            if (((oldState = this.channelState) & Integer.MIN_VALUE) == 0) continue;
            return false;
        } while (!this.casState(oldState, newState = oldState | Integer.MIN_VALUE));
        if (oldState == 0x40000000) {
            RemoteLogger.log.tracef("Closed channel writes on %s (unregistering)", this);
            this.unregister();
        } else {
            RemoteLogger.log.tracef("Closed channel writes on %s", this);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean closeReadsAndWrites() {
        int newState;
        int oldState;
        do {
            if (((oldState = this.channelState) & 0xC0000000) != -1073741824) continue;
            return false;
        } while (!this.casState(oldState, newState = oldState | 0x40000000 | Integer.MIN_VALUE));
        if ((oldState & Integer.MIN_VALUE) == 0) {
            Pooled<ByteBuffer> pooled = this.connection.allocate();
            boolean ok = false;
            try {
                ByteBuffer byteBuffer = (ByteBuffer)pooled.getResource();
                byteBuffer.put((byte)32);
                byteBuffer.putInt(this.channelId);
                byteBuffer.flip();
                ok = true;
                this.connection.send(pooled);
            }
            finally {
                if (!ok) {
                    pooled.free();
                }
            }
            RemoteLogger.log.tracef("Closed channel reads on %s", this);
        }
        if ((oldState & 0x3FFFFFFF) == 0) {
            RemoteLogger.log.tracef("Closed channel reads and writes on %s (unregistering)", this);
            this.unregister();
        } else {
            RemoteLogger.log.tracef("Closed channel reads and writes on %s", this);
        }
        this.notifyEnd();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEnd() {
        Object object = this.connection.getLock();
        synchronized (object) {
            if (this.nextReceiver != null) {
                final Channel.Receiver receiver = this.nextReceiver;
                this.nextReceiver = null;
                try {
                    this.getExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            receiver.handleEnd(RemoteConnectionChannel.this);
                        }
                    });
                }
                catch (Throwable t) {
                    this.connection.handleException(new IOException("Fatal connection error", t));
                    return;
                }
            }
        }
    }

    private void unregister() {
        RemoteLogger.log.tracef("Unregistering %s", this);
        this.closeAsync();
        this.connectionHandler.handleChannelClosed(this);
    }

    @Override
    public MessageOutputStream writeMessage() throws IOException {
        IntIndexMap<OutboundMessage> outboundMessages = this.outboundMessages;
        this.openOutboundMessage();
        boolean ok = false;
        try {
            Random random = ProtocolUtils.randomHolder.get();
            for (int tries = 50; tries > 0; --tries) {
                OutboundMessage message;
                OutboundMessage existing;
                int id = random.nextInt() & 0xFFFE;
                if (outboundMessages.containsKey(id) || (existing = outboundMessages.putIfAbsent(message = new OutboundMessage((short)id, this, this.outboundWindow, this.maxOutboundMessageSize))) != null) continue;
                ok = true;
                OutboundMessage outboundMessage = message;
                return outboundMessage;
            }
            throw RemoteLogger.log.channelBusy();
        }
        finally {
            if (!ok) {
                this.closeOutboundMessage();
            }
        }
    }

    void free(OutboundMessage outboundMessage) {
        if (this.outboundMessages.remove(outboundMessage)) {
            RemoteLogger.log.tracef("Removed %s", outboundMessage);
        } else {
            RemoteLogger.log.tracef("Got redundant free for %s", outboundMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeShutdown() throws IOException {
        if (this.closeWrites()) {
            Pooled<ByteBuffer> pooled = this.connection.allocate();
            boolean ok = false;
            try {
                ByteBuffer byteBuffer = (ByteBuffer)pooled.getResource();
                byteBuffer.put((byte)32);
                byteBuffer.putInt(this.channelId);
                byteBuffer.flip();
                this.connection.send(pooled);
                ok = true;
            }
            finally {
                if (!ok) {
                    pooled.free();
                }
            }
        }
    }

    void handleRemoteClose() {
        this.closeReadsAndWrites();
    }

    void handleIncomingWriteShutdown() {
        this.closeReads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMessage(final Channel.Receiver handler) {
        boolean immediateEnd = false;
        Object object = this.connection.getLock();
        synchronized (object) {
            if (this.inboundMessageQueue.isEmpty()) {
                if ((this.channelState & 0x40000000) != 0) {
                    try {
                        this.getExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                handler.handleEnd(RemoteConnectionChannel.this);
                            }
                        });
                    }
                    catch (RejectedExecutionException ignored) {
                        immediateEnd = true;
                    }
                } else {
                    if (this.nextReceiver != null) {
                        throw new IllegalStateException("Message handler already queued");
                    }
                    this.nextReceiver = handler;
                }
            } else {
                final InboundMessage message = this.inboundMessageQueue.remove();
                try {
                    this.getExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            handler.handleMessage(RemoteConnectionChannel.this, message.messageInputStream);
                        }
                    });
                }
                catch (RejectedExecutionException ignored) {
                    IoUtils.safeClose((Closeable)message.messageInputStream);
                    immediateEnd = true;
                }
            }
            this.connection.getLock().notify();
        }
        if (immediateEnd) {
            handler.handleEnd(this);
        }
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return SUPPORTED_OPTIONS.contains(option);
    }

    @Override
    public <T> T getOption(Option<T> option) {
        if (option == RemotingOptions.MAX_INBOUND_MESSAGES) {
            return (T)option.cast((Object)this.maxInboundMessages);
        }
        if (option == RemotingOptions.MAX_OUTBOUND_MESSAGES) {
            return (T)option.cast((Object)this.maxOutboundMessages);
        }
        if (option == RemotingOptions.RECEIVE_WINDOW_SIZE) {
            return (T)option.cast((Object)this.inboundWindow);
        }
        if (option == RemotingOptions.TRANSMIT_WINDOW_SIZE) {
            return (T)option.cast((Object)this.outboundWindow);
        }
        if (option == RemotingOptions.MAX_INBOUND_MESSAGE_SIZE) {
            return (T)option.cast((Object)this.maxInboundMessageSize);
        }
        if (option == RemotingOptions.MAX_OUTBOUND_MESSAGE_SIZE) {
            return (T)option.cast((Object)this.maxOutboundMessageSize);
        }
        return null;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void handleMessageData(Pooled<ByteBuffer> message) {
        boolean ok1 = false;
        try {
            InboundMessage inboundMessage;
            ByteBuffer buffer = (ByteBuffer)message.getResource();
            int id = buffer.getShort() & 0xFFFF;
            int flags = buffer.get() & 0xFF;
            if ((flags & 2) != 0) {
                if (!this.openInboundMessage()) {
                    this.asyncCloseMessage(id);
                    return;
                }
                boolean ok2 = false;
                try {
                    inboundMessage = new InboundMessage((short)id, this, this.inboundWindow, this.maxInboundMessageSize);
                    InboundMessage existing = this.inboundMessages.putIfAbsent(inboundMessage);
                    if (existing != null) {
                        existing.handleDuplicate();
                    }
                    Object object = this.connection.getLock();
                    synchronized (object) {
                        if (this.nextReceiver != null) {
                            final Channel.Receiver receiver = this.nextReceiver;
                            this.nextReceiver = null;
                            try {
                                this.getExecutor().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        receiver.handleMessage(RemoteConnectionChannel.this, inboundMessage.messageInputStream);
                                    }
                                });
                                ok2 = true;
                            }
                            catch (Throwable t) {
                                this.connection.handleException(new IOException("Fatal connection error", t));
                                // MONITOREXIT @DISABLED, blocks:[0, 2, 20, 24, 9, 10] lbl27 : MonitorExitStatement: MONITOREXIT : var9_9
                                if (!ok2) {
                                    this.freeInboundMessage((short)id);
                                }
                                if (ok1) return;
                                message.free();
                                return;
                            }
                        } else {
                            this.inboundMessageQueue.add(inboundMessage);
                            ok2 = true;
                        }
                    }
                }
                finally {
                    if (!ok2) {
                        this.freeInboundMessage((short)id);
                    }
                }
            } else {
                inboundMessage = this.inboundMessages.get(id);
                if (inboundMessage == null) {
                    RemoteLogger.log.tracef("Ignoring message on channel %s for unknown message ID %04x", this, id);
                    return;
                }
            }
            inboundMessage.handleIncoming(message);
            ok1 = true;
            return;
        }
        finally {
            if (!ok1) {
                message.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncCloseMessage(int id) {
        Pooled<ByteBuffer> pooled = this.connection.allocate();
        boolean ok = false;
        try {
            ByteBuffer byteBuffer = (ByteBuffer)pooled.getResource();
            byteBuffer.put((byte)50);
            byteBuffer.putInt(this.channelId);
            byteBuffer.putShort((short)id);
            byteBuffer.flip();
            ok = true;
            this.connection.send(pooled);
        }
        finally {
            if (!ok) {
                pooled.free();
            }
        }
    }

    void handleWindowOpen(Pooled<ByteBuffer> pooled) {
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        int id = buffer.getShort() & 0xFFFF;
        OutboundMessage outboundMessage = this.outboundMessages.get(id);
        if (outboundMessage == null) {
            return;
        }
        outboundMessage.acknowledge(buffer.getInt() & Integer.MAX_VALUE);
    }

    void handleAsyncClose(Pooled<ByteBuffer> pooled) {
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        int id = buffer.getShort() & 0xFFFF;
        OutboundMessage outboundMessage = this.outboundMessages.get(id);
        if (outboundMessage == null) {
            return;
        }
        outboundMessage.remoteClosed();
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }

    @Override
    public Connection getConnection() {
        return this.connectionHandlerContext.getConnection();
    }

    @Override
    protected void closeAction() throws IOException {
        this.closeReadsAndWrites();
        this.closeMessages();
        this.closeComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeMessages() {
        ArrayList<InboundMessage> terminateMessages;
        ArrayList<OutboundMessage> cancelMessages;
        ArrayList<InboundMessage> exceptionMessages;
        Object object = this.connection.getLock();
        synchronized (object) {
            exceptionMessages = new ArrayList<InboundMessage>(this.inboundMessages);
            cancelMessages = new ArrayList<OutboundMessage>(this.outboundMessages);
            terminateMessages = new ArrayList<InboundMessage>(this.inboundMessageQueue);
            this.inboundMessageQueue.clear();
        }
        for (InboundMessage inboundMessage : exceptionMessages) {
            inboundMessage.inputStream.pushException((IOException)new MessageCancelledException());
        }
        for (OutboundMessage outboundMessage : cancelMessages) {
            outboundMessage.cancel();
        }
        for (InboundMessage inboundMessage : terminateMessages) {
            inboundMessage.terminate();
        }
    }

    RemoteConnection getRemoteConnection() {
        return this.connection;
    }

    RemoteConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    int getChannelId() {
        return this.channelId;
    }

    void freeInboundMessage(short id) {
        if (this.inboundMessages.removeKey(id & 0xFFFF) != null) {
            this.closeInboundMessage();
        }
    }

    Pooled<ByteBuffer> allocate(byte protoId) {
        Pooled<ByteBuffer> pooled = this.connection.allocate();
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        buffer.put(protoId);
        buffer.putInt(this.channelId);
        return pooled;
    }

    public String toString() {
        return String.format("Channel ID %08x (%s) of %s", this.channelId, (this.channelId & Integer.MIN_VALUE) == 0 ? "inbound" : "outbound", this.connection);
    }

    void dumpState(StringBuilder b) {
        int state = this.channelState;
        int inboundMessageCnt = (state & 0x3FFF8000) >>> Integer.numberOfTrailingZeros(32768);
        int outboundMessageCnt = (state & Short.MAX_VALUE) >>> Integer.numberOfTrailingZeros(1);
        b.append("        ").append(String.format("%s channel ID %08x summary:\n", (this.channelId & Integer.MIN_VALUE) == 0 ? "Inbound" : "Outbound", this.channelId));
        b.append("        ").append("* Flags: ");
        if (Bits.allAreSet((int)state, (int)0x40000000)) {
            b.append("read-closed ");
        }
        if (Bits.allAreSet((int)state, (int)Integer.MIN_VALUE)) {
            b.append("write-closed ");
        }
        b.append('\n');
        b.append("        ").append("* ").append(this.inboundMessageQueue.size()).append(" pending inbound messages\n");
        b.append("        ").append("* ").append(inboundMessageCnt).append(" (max ").append(this.maxInboundMessages).append(") inbound messages\n");
        b.append("        ").append("* ").append(outboundMessageCnt).append(" (max ").append(this.maxOutboundMessages).append(") outbound messages\n");
        b.append("        ").append("* Pending inbound messages:\n");
        for (InboundMessage inboundMessage : this.inboundMessageQueue) {
            inboundMessage.dumpState(b);
        }
        b.append("        ").append("* Inbound messages:\n");
        for (InboundMessage inboundMessage : this.inboundMessages) {
            inboundMessage.dumpState(b);
        }
        b.append("        ").append("* Outbound messages:\n");
        for (OutboundMessage outboundMessage : this.outboundMessages) {
            outboundMessage.dumpState(b);
        }
    }
}

