/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.api;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import javax.security.auth.Subject;
import org.jboss.as.core.security.SubjectUserInfo;
import org.jboss.as.security.api.ContextStateCache;
import org.jboss.as.security.remoting.RemotingContext;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.security.UserInfo;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

public class ConnectionSecurityContext {
    private ConnectionSecurityContext() {
    }

    public static Collection<Principal> getConnectionPrincipals() {
        Connection con = RemotingContext.getConnection();
        if (con != null) {
            UserInfo userInfo = con.getUserInfo();
            if (userInfo instanceof SubjectUserInfo) {
                SubjectUserInfo sinfo = (SubjectUserInfo)userInfo;
                return sinfo.getPrincipals();
            }
            return Collections.emptySet();
        }
        return null;
    }

    public static ContextStateCache pushIdentity(Principal principal, Object credential) throws Exception {
        SecurityContext current = SecurityContextAssociation.getSecurityContext();
        SecurityContext nextContext = SecurityContextFactory.createSecurityContext((Principal)principal, (Object)credential, (Subject)new Subject(), (String)"USER_DELEGATION");
        SecurityContextAssociation.setSecurityContext((SecurityContext)nextContext);
        Connection con = RemotingContext.getConnection();
        RemotingContext.clear();
        return new ContextStateCache(con, current);
    }

    public static void popIdentity(ContextStateCache stateCache) {
        RemotingContext.setConnection((Connection)stateCache.getConnection());
        SecurityContextAssociation.setSecurityContext((SecurityContext)stateCache.getSecurityContext());
    }
}

