/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc.mappers;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.keycloak.broker.provider.AbstractIdentityProviderMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.representations.JsonWebToken;

public abstract class AbstractClaimMapper
extends AbstractIdentityProviderMapper {
    public static final String CLAIM = "claim";
    public static final String CLAIM_VALUE = "claim.value";

    public static Object getClaimValue(JsonWebToken token, String claim) {
        String[] split = claim.split("\\.");
        Map jsonObject = token.getOtherClaims();
        for (int i = 0; i < split.length; ++i) {
            if (i == split.length - 1) {
                return jsonObject.get(split[i]);
            }
            Object val = jsonObject.get(split[i]);
            if (!(val instanceof Map)) {
                return null;
            }
            jsonObject = (Map)val;
        }
        return null;
    }

    protected Object getClaimValue(IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        Object value;
        String claim = (String)mapperModel.getConfig().get(CLAIM);
        JsonWebToken token = (JsonWebToken)context.getContextData().get("VALIDATED_ACCESS_TOKEN");
        if (token != null && (value = AbstractClaimMapper.getClaimValue(token, claim)) != null) {
            return value;
        }
        token = (JsonWebToken)context.getContextData().get("VALIDATED_ID_TOKEN");
        if (token != null && (value = AbstractClaimMapper.getClaimValue(token, claim)) != null) {
            return value;
        }
        return null;
    }

    protected boolean hasClaimValue(IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        Object value = this.getClaimValue(mapperModel, context);
        String desiredValue = (String)mapperModel.getConfig().get(CLAIM_VALUE);
        return this.valueEquals(desiredValue, value);
    }

    public boolean valueEquals(String desiredValue, Object value) {
        List list;
        Iterator i$;
        if (value instanceof String) {
            if (desiredValue.equals(value)) {
                return true;
            }
        } else if (value instanceof Double) {
            try {
                if (Double.valueOf(desiredValue).equals(value)) {
                    return true;
                }
            }
            catch (Exception e) {}
        } else if (value instanceof Integer) {
            try {
                if (Integer.valueOf(desiredValue).equals(value)) {
                    return true;
                }
            }
            catch (Exception e) {}
        } else if (value instanceof Boolean) {
            try {
                if (Boolean.valueOf(desiredValue).equals(value)) {
                    return true;
                }
            }
            catch (Exception e) {}
        } else if (value instanceof List && (i$ = (list = (List)value).iterator()).hasNext()) {
            Object val = i$.next();
            return this.valueEquals(desiredValue, val);
        }
        return false;
    }
}

