/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.metadata.impl;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.patching.PatchMessages;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchElement;
import org.jboss.as.patching.metadata.PatchElementProvider;

public class PatchElementImpl
implements PatchElement {
    private final String id;
    private String description = "no description";
    private PatchElementProvider provider;
    private final List<ContentModification> modifications = new ArrayList<ContentModification>();

    public PatchElementImpl(String id) {
        assert (id != null);
        if (!Patch.PATCH_NAME_PATTERN.matcher(id).matches()) {
            throw PatchMessages.MESSAGES.illegalPatchName(id);
        }
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public PatchElementImpl setDescription(String descr) {
        this.description = descr;
        return this;
    }

    @Override
    public PatchElementProvider getProvider() {
        return this.provider;
    }

    public PatchElementImpl setProvider(PatchElementProvider provider) {
        assert (provider != null);
        this.provider = provider;
        return this;
    }

    public List<ContentModification> getModifications() {
        return this.modifications;
    }

    public PatchElementImpl addContentModification(ContentModification modification) {
        this.modifications.add(modification);
        return this;
    }
}

