/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapperUtils;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.AccessToken;

public class RoleNameMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper {
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String ROLE_CONFIG = "role";
    public static String NEW_ROLE_NAME = "new.role.name";
    public static final String PROVIDER_ID = "oidc-role-name-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public String getDisplayType() {
        return "Role Name Mapper";
    }

    @Override
    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Map an assigned role to a new name or position in the token.";
    }

    @Override
    public AccessToken transformAccessToken(AccessToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession) {
        AccessToken.Access access;
        String role = (String)mappingModel.getConfig().get(ROLE_CONFIG);
        String newName = (String)mappingModel.getConfig().get(NEW_ROLE_NAME);
        String[] scopedRole = ProtocolMapperUtils.parseRole(role);
        String[] newScopedRole = ProtocolMapperUtils.parseRole(newName);
        String appName = scopedRole[0];
        String roleName = scopedRole[1];
        if (appName != null) {
            access = token.getResourceAccess(appName);
            if (access == null) {
                return token;
            }
            if (!access.getRoles().contains(roleName)) {
                return token;
            }
            access.getRoles().remove(roleName);
        } else {
            access = token.getRealmAccess();
            if (access == null) {
                return token;
            }
            access.getRoles().remove(roleName);
        }
        String newAppName = newScopedRole[0];
        String newRoleName = newScopedRole[1];
        AccessToken.Access access2 = null;
        if (newAppName == null) {
            access2 = token.getRealmAccess();
            if (access2 == null) {
                access2 = new AccessToken.Access();
                token.setRealmAccess(access2);
            }
        } else {
            access2 = token.addAccess(newAppName);
        }
        access2.addRole(newRoleName);
        return token;
    }

    public static ProtocolMapperModel create(String name, String role, String newName) {
        String mapperId = PROVIDER_ID;
        ProtocolMapperModel mapper = new ProtocolMapperModel();
        mapper.setName(name);
        mapper.setProtocolMapper(mapperId);
        mapper.setProtocol("openid-connect");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(ROLE_CONFIG, role);
        config.put(NEW_ROLE_NAME, newName);
        mapper.setConfig(config);
        return mapper;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(ROLE_CONFIG);
        property.setLabel("Role");
        property.setHelpText("Role name you want changed.  To reference an application role the syntax is appname.approle, i.e. myapp.myrole");
        property.setType("String");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(NEW_ROLE_NAME);
        property.setLabel("New Role Name");
        property.setHelpText("The new role name.  The new name format corresponds to where in the access token the role will be mapped to.  So, a new name of 'myapp.newname' will map the role to that position in the access token.  A new name of 'newname' will map the role to the realm roles in the token.");
        property.setType("String");
        configProperties.add(property);
    }
}

