/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.configuration;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.util.List;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.jboss.ws.api.annotation.EndpointConfig;
import org.jboss.ws.api.util.ServiceLoader;
import org.jboss.ws.common.management.AbstractServerConfig;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.config.ConfigMetaDataParser;
import org.jboss.wsf.spi.metadata.config.ConfigRoot;
import org.jboss.wsf.spi.security.JASPIAuthenticationProvider;
import org.jboss.wsf.stack.cxf.JBossWSInvoker;
import org.jboss.wsf.stack.cxf.Loggers;
import org.jboss.wsf.stack.cxf.Messages;
import org.jboss.wsf.stack.cxf.client.configuration.BeanCustomizer;
import org.jboss.wsf.stack.cxf.deployment.EndpointImpl;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;
import org.jboss.wsf.stack.cxf.security.authentication.AutenticationMgrSubjectCreatingInterceptor;

public class ServerBeanCustomizer
extends BeanCustomizer {
    private WSDLFilePublisher wsdlPublisher;
    private List<Endpoint> depEndpoints;
    private UnifiedVirtualFile deploymentRoot;
    private String epConfigName;
    private String epConfigFile;

    public void customize(Object beanInstance) {
        if (beanInstance instanceof EndpointImpl) {
            this.configureEndpoint((EndpointImpl)((Object)beanInstance));
        }
        if (beanInstance instanceof ServerFactoryBean) {
            ServerFactoryBean factory = (ServerFactoryBean)beanInstance;
            if (factory.getInvoker() instanceof JBossWSInvoker) {
                ((JBossWSInvoker)factory.getInvoker()).setTargetBean(factory.getServiceBean());
            }
            if (this.depEndpoints != null) {
                String targetBeanName = factory.getServiceBean().getClass().getName();
                for (Endpoint depEndpoint : this.depEndpoints) {
                    if (!depEndpoint.getTargetBeanClass().getName().equals(targetBeanName)) continue;
                    depEndpoint.addAttachment(ServerFactoryBean.class, (Object)factory);
                }
            }
        }
        super.customize(beanInstance);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void configureEndpoint(EndpointImpl endpoint) {
        boolean isHttpEndpoint;
        if (this.wsdlPublisher != null) {
            endpoint.setWsdlPublisher(this.wsdlPublisher);
        }
        if (endpoint.isPublished()) return;
        Object implementor = endpoint.getImplementor();
        boolean bl = isHttpEndpoint = endpoint.getAddress() != null && endpoint.getAddress().substring(0, 5).toLowerCase().startsWith("http");
        if (endpoint.getInvoker() == null && isHttpEndpoint) {
            endpoint.setInvoker(new JBossWSInvoker());
        }
        String configName = "Standard-Endpoint-Config";
        String configFile = null;
        EndpointConfig epConfigAnn = implementor.getClass().getAnnotation(EndpointConfig.class);
        if (epConfigAnn != null) {
            if (!epConfigAnn.configName().isEmpty()) {
                configName = epConfigAnn.configName();
            }
            if (!epConfigAnn.configFile().isEmpty()) {
                configFile = epConfigAnn.configFile();
            }
        }
        if (this.epConfigName != null && !this.epConfigName.isEmpty()) {
            configName = this.epConfigName;
        }
        if (this.epConfigFile != null && !this.epConfigFile.isEmpty()) {
            configFile = this.epConfigFile;
        }
        if (configFile == null) {
            ServerConfig sc = ServerBeanCustomizer.getServerConfig();
            org.jboss.wsf.spi.metadata.config.EndpointConfig config = sc.getEndpointConfig(configName);
            if (config == null) throw Messages.MESSAGES.couldNotFindEndpointConfigName(configName);
            endpoint.setEndpointConfig((CommonConfig)config);
        } else {
            try {
                UnifiedVirtualFile vf = this.deploymentRoot.findChild(configFile);
                ConfigRoot config = ConfigMetaDataParser.parse((URL)vf.toURL());
                endpoint.setEndpointConfig((CommonConfig)config.getEndpointConfigByName(configName));
            }
            catch (IOException e) {
                throw Messages.MESSAGES.couldNotReadConfigFile(configFile);
            }
        }
        JASPIAuthenticationProvider jaspiProvider = (JASPIAuthenticationProvider)ServiceLoader.loadService((String)JASPIAuthenticationProvider.class.getName(), null, (ClassLoader)ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader());
        if (jaspiProvider == null) {
            Loggers.DEPLOYMENT_LOGGER.cannotFindJaspiClasses();
            return;
        } else {
            if (!jaspiProvider.enableServerAuthentication((Object)endpoint, this.depEndpoints.get(0))) return;
            endpoint.getInInterceptors().add(new AutenticationMgrSubjectCreatingInterceptor());
        }
    }

    private static ServerConfig getServerConfig() {
        if (System.getSecurityManager() == null) {
            return AbstractServerConfig.getServerIntegrationServerConfig();
        }
        return (ServerConfig)AccessController.doPrivileged(AbstractServerConfig.GET_SERVER_INTEGRATION_SERVER_CONFIG);
    }

    public void setDeploymentRoot(UnifiedVirtualFile deploymentRoot) {
        this.deploymentRoot = deploymentRoot;
    }

    public void setWsdlPublisher(WSDLFilePublisher wsdlPublisher) {
        this.wsdlPublisher = wsdlPublisher;
    }

    public void setDeploymentEndpoints(List<Endpoint> endpoints) {
        this.depEndpoints = endpoints;
    }

    public void setEpConfigName(String epConfigName) {
        this.epConfigName = epConfigName;
    }

    public void setEpConfigFile(String epConfigFile) {
        this.epConfigFile = epConfigFile;
    }
}

