/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import org.jboss.shrinkwrap.api.ArchiveEventHandler;
import org.jboss.shrinkwrap.api.ArchiveFormat;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.IllegalArchivePathException;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.NamedAsset;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.formatter.Formatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Archive<T extends Archive<T>>
extends Assignable {
    public String getName();

    public String getId();

    public T add(Asset var1, ArchivePath var2) throws IllegalArgumentException;

    public T add(Asset var1, ArchivePath var2, String var3) throws IllegalArgumentException;

    public T add(Asset var1, String var2, String var3) throws IllegalArgumentException;

    public T add(NamedAsset var1) throws IllegalArgumentException;

    public T add(Asset var1, String var2) throws IllegalArgumentException;

    public T addAsDirectory(String var1) throws IllegalArgumentException;

    public T addAsDirectories(String ... var1) throws IllegalArgumentException;

    public T addAsDirectory(ArchivePath var1) throws IllegalArgumentException;

    public T addAsDirectories(ArchivePath ... var1) throws IllegalArgumentException;

    public T addHandlers(ArchiveEventHandler ... var1);

    public Node get(ArchivePath var1) throws IllegalArgumentException;

    public Node get(String var1) throws IllegalArgumentException;

    public <X extends Archive<X>> X getAsType(Class<X> var1, String var2);

    public <X extends Archive<X>> X getAsType(Class<X> var1, ArchivePath var2);

    public <X extends Archive<X>> Collection<X> getAsType(Class<X> var1, Filter<ArchivePath> var2);

    public <X extends Archive<X>> X getAsType(Class<X> var1, String var2, ArchiveFormat var3);

    public <X extends Archive<X>> X getAsType(Class<X> var1, ArchivePath var2, ArchiveFormat var3);

    public <X extends Archive<X>> Collection<X> getAsType(Class<X> var1, Filter<ArchivePath> var2, ArchiveFormat var3);

    public boolean contains(ArchivePath var1) throws IllegalArgumentException;

    public boolean contains(String var1) throws IllegalArgumentException;

    public Node delete(ArchivePath var1) throws IllegalArgumentException;

    public Node delete(String var1) throws IllegalArgumentException;

    public Map<ArchivePath, Node> getContent();

    public Map<ArchivePath, Node> getContent(Filter<ArchivePath> var1);

    public T add(Archive<?> var1, ArchivePath var2, Class<? extends StreamExporter> var3) throws IllegalArgumentException;

    public T add(Archive<?> var1, String var2, Class<? extends StreamExporter> var3) throws IllegalArgumentException;

    public T merge(Archive<?> var1) throws IllegalArgumentException;

    public T merge(Archive<?> var1, Filter<ArchivePath> var2) throws IllegalArgumentException;

    public T merge(Archive<?> var1, ArchivePath var2) throws IllegalArgumentException;

    public T merge(Archive<?> var1, String var2) throws IllegalArgumentException;

    public T merge(Archive<?> var1, ArchivePath var2, Filter<ArchivePath> var3) throws IllegalArgumentException;

    public T merge(Archive<?> var1, String var2, Filter<ArchivePath> var3) throws IllegalArgumentException;

    public T move(ArchivePath var1, ArchivePath var2) throws IllegalArgumentException, IllegalArchivePathException;

    public T move(String var1, String var2) throws IllegalArgumentException, IllegalArchivePathException;

    public String toString();

    public String toString(boolean var1);

    public String toString(Formatter var1) throws IllegalArgumentException;

    public void writeTo(OutputStream var1, Formatter var2) throws IllegalArgumentException;

    public Archive<T> shallowCopy();
}

