/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.DelegatingObjectModelFactory;
import org.jboss.xb.binding.GenericObjectModelFactory;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.jboss.xb.binding.parser.JBossXBParser;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectModelBuilder
implements UnmarshallingContext,
JBossXBParser.DtdAwareContentHandler {
    private static final Logger log = Logger.getLogger(ObjectModelBuilder.class);
    private static final Object IGNORED = new Object();
    private Object root;
    private Stack all = new StackImpl();
    private Stack accepted = new StackImpl();
    private GenericObjectModelFactory curFactory;
    private String curNameSwitchingFactory;
    private String curNsSwitchingFactory;
    private Stack nameSwitchingFactory;
    private Stack nsSwitchingFactory;
    private GenericObjectModelFactory defaultFactory;
    private Map<String, GenericObjectModelFactory> factoriesToNs = Collections.emptyMap();
    private final NamespaceRegistry nsRegistry = new NamespaceRegistry();
    private boolean trimTextContent = true;
    private boolean trace = log.isTraceEnabled();

    public void mapFactoryToNamespace(ObjectModelFactory factory, String namespaceUri) {
        if (this.factoriesToNs.isEmpty()) {
            this.factoriesToNs = new HashMap<String, GenericObjectModelFactory>();
        }
        this.factoriesToNs.put(namespaceUri, ObjectModelBuilder.getGenericObjectModelFactory(factory));
    }

    public void init(ObjectModelFactory defaultFactory, Object root) {
        this.defaultFactory = ObjectModelBuilder.getGenericObjectModelFactory(defaultFactory);
        this.all.clear();
        this.accepted.clear();
        this.root = root;
    }

    public void pushFactory(String namespaceURI, String localName, GenericObjectModelFactory factory) {
        if (this.curNsSwitchingFactory != null) {
            if (this.nsSwitchingFactory == null) {
                this.nsSwitchingFactory = new StackImpl();
                this.nameSwitchingFactory = new StackImpl();
            }
            this.nsSwitchingFactory.push(this.curNsSwitchingFactory);
            this.nameSwitchingFactory.push(this.curNameSwitchingFactory);
        }
        this.curNsSwitchingFactory = namespaceURI;
        this.curNameSwitchingFactory = localName;
        this.curFactory = factory;
    }

    public void popFactory() {
        if (this.nsSwitchingFactory == null || this.nsSwitchingFactory.isEmpty()) {
            this.curNameSwitchingFactory = null;
            this.curNsSwitchingFactory = null;
        } else {
            this.curNameSwitchingFactory = (String)this.nameSwitchingFactory.pop();
            this.curNsSwitchingFactory = (String)this.nsSwitchingFactory.pop();
        }
        this.curFactory = this.getFactory(this.curNsSwitchingFactory);
    }

    @Override
    public Iterator<String> getNamespaceURIs() {
        return this.nsRegistry.getRegisteredURIs();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.nsRegistry;
    }

    @Override
    public boolean isTrimTextContent() {
        return this.trimTextContent;
    }

    @Override
    public void setTrimTextContent(boolean trimTextContent) {
        this.trimTextContent = trimTextContent;
    }

    @Override
    public QName resolveQName(String value) {
        StringTokenizer st = new StringTokenizer(value, ":");
        if (st.countTokens() == 1) {
            return new QName(value);
        }
        if (st.countTokens() != 2) {
            throw new IllegalArgumentException("Illegal QName: " + value);
        }
        String prefix = st.nextToken();
        String local = st.nextToken();
        String nsURI = this.nsRegistry.getNamespaceURI(prefix);
        if (nsURI == null) {
            throw new IllegalStateException("Cannot obtain namespace URI for prefix: " + prefix);
        }
        return new QName(nsURI, local, prefix);
    }

    @Override
    public String getChildContent(String namespaceURI, String qName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XSTypeDefinition getType() {
        return null;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.nsRegistry.addPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) {
        this.nsRegistry.removePrefixMapping(prefix);
    }

    @Override
    public void processingInstruction(String target, String data) {
        ObjectModelFactory factory;
        int end;
        if (!"jbossxb".equals(target)) {
            return;
        }
        int i = data.indexOf("factory=\"");
        if (i != -1) {
            Class<?> factoryCls;
            end = data.indexOf(34, i + 9);
            if (end == -1) {
                throw new JBossXBRuntimeException("Property 'factory' is not terminated with '\"' in processing instruction: " + data);
            }
            String factoryProp = data.substring(i + 9, end);
            try {
                factoryCls = Thread.currentThread().getContextClassLoader().loadClass(factoryProp);
            }
            catch (ClassNotFoundException e) {
                throw new JBossXBRuntimeException("Failed to load factory class : " + e.getMessage(), e);
            }
            try {
                factory = (ObjectModelFactory)factoryCls.newInstance();
            }
            catch (Exception e) {
                throw new JBossXBRuntimeException("Failed to instantiate factory " + factoryProp + ": " + e.getMessage(), e);
            }
            i = data.indexOf("ns=\"");
            if (i == -1) {
                throw new JBossXBRuntimeException("Property 'ns' not found in factory mapping processing instruction: " + data);
            }
            end = data.indexOf("\"", i + 4);
            if (end == -1) {
                throw new JBossXBRuntimeException("Property 'ns' is not terminated with '\"' in processing instruction: " + data);
            }
        } else {
            throw new JBossXBRuntimeException("Unexpected data in processing instruction: target=" + target + ", data=" + data);
        }
        String nsProp = data.substring(i + 4, end);
        this.mapFactoryToNamespace(factory, nsProp);
    }

    @Override
    public Object getRoot() {
        if (!this.all.isEmpty()) {
            this.popAll();
            this.popAccepted();
        }
        return this.root;
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) {
        GenericObjectModelFactory factory = this.getFactory(systemId);
        try {
            Class[] sig = new Class[]{String.class, String.class, String.class};
            Method startDTD = factory.getClass().getMethod("startDTD", sig);
            Object[] args = new Object[]{name, publicId, systemId};
            startDTD.invoke((Object)factory, args);
        }
        catch (Exception e) {
            log.debug((Object)("No startDTD found on factory: " + factory));
        }
    }

    @Override
    public void endDTD() {
        try {
            Class[] sig = new Class[]{};
            Method endDTD = this.defaultFactory.getClass().getMethod("endDTD", sig);
            Object[] args = new Object[]{};
            endDTD.invoke((Object)this.defaultFactory, args);
        }
        catch (Exception e) {
            log.debug((Object)("No endDTD found on factory: " + this.defaultFactory));
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        Object element;
        Object parent;
        Object object = parent = this.accepted.isEmpty() ? this.root : this.peekAccepted();
        if (!namespaceURI.equals(this.curNsSwitchingFactory)) {
            GenericObjectModelFactory newFactory = this.getFactory(namespaceURI);
            element = newFactory != this.curFactory ? newFactory.newRoot(parent, this, namespaceURI, localName, atts) : newFactory.newChild(parent, this, namespaceURI, localName, atts);
            this.pushFactory(namespaceURI, localName, newFactory);
        } else {
            element = this.curFactory.newChild(parent, this, namespaceURI, localName, atts);
        }
        if (element == null) {
            this.pushAll(IGNORED);
            if (this.trace) {
                log.trace((Object)("ignored " + namespaceURI + ':' + qName));
            }
        } else {
            this.pushAll(element);
            this.pushAccepted(element);
            if (this.trace) {
                log.trace((Object)("accepted " + namespaceURI + ':' + qName));
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        AllElement element = this.popAll();
        if (!this.accepted.isEmpty()) {
            Object acceptedElement = this.peekAccepted();
            if (element.characters != null && element.characters.length() > 0) {
                if (this.trimTextContent) {
                    String characters = element.characters.toString().trim();
                    if (characters.length() > 0) {
                        this.curFactory.setValue(acceptedElement, this, namespaceURI, localName, characters);
                    }
                } else {
                    this.curFactory.setValue(acceptedElement, this, namespaceURI, localName, element.characters.toString());
                }
            }
        }
        if (localName.equals(this.curNameSwitchingFactory) && namespaceURI.equals(this.curNsSwitchingFactory)) {
            this.popFactory();
        }
        if (element.element != IGNORED) {
            Object parent;
            this.popAccepted();
            Object object = parent = this.accepted.isEmpty() ? null : this.peekAccepted();
            if (parent != null) {
                this.curFactory.addChild(parent, element.element, this, namespaceURI, localName);
            } else {
                this.root = this.curFactory.completeRoot(element.element, this, namespaceURI, localName);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (!this.accepted.isEmpty()) {
            String str = String.valueOf(ch, start, length);
            AllElement allElement = this.peekAll();
            if (allElement.characters == null) {
                allElement.characters = new StringBuffer(str);
            } else {
                allElement.characters.append(str);
            }
        }
    }

    private GenericObjectModelFactory getFactory(String namespaceUri) {
        GenericObjectModelFactory factory = this.factoriesToNs.get(namespaceUri);
        if (factory == null) {
            factory = this.defaultFactory;
        }
        return factory;
    }

    static Object invokeFactory(Object factory, Method method, Object[] args) {
        try {
            return method.invoke(factory, args);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getCause();
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            String msg = "Failed to invoke method " + method + ", factory=" + factory;
            log.error((Object)msg, e.getTargetException());
            IllegalStateException ise = new IllegalStateException(msg);
            ise.initCause(te);
            throw ise;
        }
        catch (Exception e) {
            String msg = "Failed to invoke method " + method.getName() + ", factory=" + factory;
            log.error((Object)msg, (Throwable)e);
            IllegalStateException ise = new IllegalStateException(msg);
            ise.initCause(e);
            throw ise;
        }
    }

    static Method getMethodForElement(Object factory, String name, Class[] params) {
        Method method = null;
        try {
            method = factory.getClass().getMethod(name, params);
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
            throw e;
        }
        return method;
    }

    static final GenericObjectModelFactory getGenericObjectModelFactory(ObjectModelFactory factory) {
        if (!(factory instanceof GenericObjectModelFactory)) {
            factory = new DelegatingObjectModelFactory(factory);
        }
        return factory instanceof GenericObjectModelFactory ? (GenericObjectModelFactory)factory : new DelegatingObjectModelFactory(factory);
    }

    private void pushAccepted(Object o) {
        this.accepted.push(o);
    }

    private Object popAccepted() {
        return this.accepted.pop();
    }

    private Object peekAccepted() {
        return this.accepted.peek();
    }

    private void pushAll(Object o) {
        this.all.push(new AllElement(o));
    }

    private AllElement popAll() {
        return (AllElement)this.all.pop();
    }

    private AllElement peekAll() {
        return (AllElement)this.all.peek();
    }

    private static class StackImpl
    implements Stack {
        private List<Object> list = new ArrayList<Object>();

        private StackImpl() {
        }

        public void clear() {
            this.list.clear();
        }

        public void push(Object o) {
            this.list.add(o);
        }

        public Object pop() {
            return this.list.remove(this.list.size() - 1);
        }

        public Object peek() {
            return this.list.get(this.list.size() - 1);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }

    private static interface Stack {
        public void clear();

        public void push(Object var1);

        public Object pop();

        public Object peek();

        public boolean isEmpty();
    }

    private static final class AllElement {
        public final Object element;
        public StringBuffer characters;

        public AllElement(Object element) {
            this.element = element;
        }
    }
}

