/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowMessages;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Pooled;

public class ReferenceCountedPooled
implements Pooled<ByteBuffer> {
    private final Pooled<ByteBuffer> underlying;
    private volatile int referenceCount;
    private volatile boolean discard = false;
    boolean mainFreed = false;
    private ByteBuffer slice = null;
    private static final AtomicIntegerFieldUpdater<ReferenceCountedPooled> referenceCountUpdater = AtomicIntegerFieldUpdater.newUpdater(ReferenceCountedPooled.class, "referenceCount");

    public ReferenceCountedPooled(Pooled<ByteBuffer> underlying, int referenceCount) {
        this.underlying = underlying;
        this.referenceCount = referenceCount;
    }

    public void discard() {
        this.discard = true;
        if (referenceCountUpdater.decrementAndGet(this) == 0) {
            this.underlying.free();
        }
    }

    public void free() {
        if (this.mainFreed) {
            return;
        }
        this.mainFreed = true;
        this.freeInternal();
    }

    public boolean isFreed() {
        return this.mainFreed;
    }

    public boolean tryUnfree() {
        int refs;
        do {
            if ((refs = referenceCountUpdater.get(this)) > 0) continue;
            return false;
        } while (!referenceCountUpdater.compareAndSet(this, refs, refs + 1));
        ByteBuffer resource = this.slice != null ? this.slice : (ByteBuffer)this.underlying.getResource();
        resource.position(resource.limit());
        resource.limit(resource.capacity());
        this.slice = resource.slice();
        this.mainFreed = false;
        return true;
    }

    private void freeInternal() {
        if (referenceCountUpdater.decrementAndGet(this) == 0) {
            this.underlying.free();
        }
    }

    public ByteBuffer getResource() throws IllegalStateException {
        if (this.mainFreed) {
            throw UndertowMessages.MESSAGES.bufferAlreadyFreed();
        }
        if (this.slice != null) {
            return this.slice;
        }
        return (ByteBuffer)this.underlying.getResource();
    }

    public void close() {
        this.free();
    }

    public Pooled<ByteBuffer> createView(final ByteBuffer newValue) {
        this.increaseReferenceCount();
        return new Pooled<ByteBuffer>(){
            boolean free = false;

            public void discard() {
                if (!this.free) {
                    this.free = true;
                    ReferenceCountedPooled.this.freeInternal();
                }
            }

            public void free() {
                if (!this.free) {
                    this.free = true;
                    ReferenceCountedPooled.this.freeInternal();
                }
            }

            public ByteBuffer getResource() throws IllegalStateException {
                if (this.free) {
                    throw UndertowMessages.MESSAGES.bufferAlreadyFreed();
                }
                return newValue;
            }

            public void close() {
                this.free();
            }
        };
    }

    public void increaseReferenceCount() {
        int val;
        do {
            if ((val = referenceCountUpdater.get(this)) != 0) continue;
            throw UndertowMessages.MESSAGES.objectWasFreed();
        } while (!referenceCountUpdater.compareAndSet(this, val, val + 1));
    }
}

