/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.handlers.security.CachedAuthenticatedSessionHandler;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.undertow.session.LocalSessionContext;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public class DistributableSession
implements io.undertow.server.session.Session {
    private static final String AUTHENTICATED_SESSION_ATTRIBUTE_NAME = CachedAuthenticatedSessionHandler.class.getName() + ".AuthenticatedSession";
    private static final Set<String> AUTO_REAUTHENTICATING_MECHANISMS = new HashSet<String>(Arrays.asList("BASIC", "DIGEST", "CLIENT_CERT"));
    private final UndertowSessionManager manager;
    private final Batch batch;
    private volatile Map.Entry<Session<LocalSessionContext>, SessionConfig> entry;

    public DistributableSession(UndertowSessionManager manager, Session<LocalSessionContext> session, SessionConfig config, Batch batch) {
        this.manager = manager;
        this.entry = new AbstractMap.SimpleImmutableEntry<Session<LocalSessionContext>, SessionConfig>(session, config);
        this.batch = batch;
    }

    public SessionManager getSessionManager() {
        return this.manager;
    }

    public void requestDone(HttpServerExchange exchange) {
        if (this.batch.isActive()) {
            try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
                this.entry.getKey().close();
                this.batch.close();
            }
        }
    }

    public String getId() {
        return this.entry.getKey().getId();
    }

    public long getCreationTime() {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            long l = this.entry.getKey().getMetaData().getCreationTime().getTime();
            return l;
        }
    }

    public long getLastAccessedTime() {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            long l = this.entry.getKey().getMetaData().getLastAccessedTime().getTime();
            return l;
        }
    }

    public int getMaxInactiveInterval() {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            int n = (int)this.entry.getKey().getMetaData().getMaxInactiveInterval(TimeUnit.SECONDS);
            return n;
        }
    }

    public void setMaxInactiveInterval(int interval) {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            this.entry.getKey().getMetaData().setMaxInactiveInterval((long)interval, TimeUnit.SECONDS);
        }
    }

    public Set<String> getAttributeNames() {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            Set set = this.entry.getKey().getAttributes().getAttributeNames();
            return set;
        }
    }

    public Object getAttribute(String name) {
        Session<LocalSessionContext> session = this.entry.getKey();
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            if (AUTHENTICATED_SESSION_ATTRIBUTE_NAME.equals(name)) {
                AuthenticatedSessionManager.AuthenticatedSession auth = (AuthenticatedSessionManager.AuthenticatedSession)session.getAttributes().getAttribute(name);
                AuthenticatedSessionManager.AuthenticatedSession authenticatedSession = auth != null ? auth : ((LocalSessionContext)session.getLocalContext()).getAuthenticatedSession();
                return authenticatedSession;
            }
            Object object = session.getAttributes().getAttribute(name);
            return object;
        }
    }

    public Object setAttribute(String name, Object value) {
        if (value == null) {
            return this.removeAttribute(name);
        }
        Session<LocalSessionContext> session = this.entry.getKey();
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            if (AUTHENTICATED_SESSION_ATTRIBUTE_NAME.equals(name)) {
                AuthenticatedSessionManager.AuthenticatedSession auth = (AuthenticatedSessionManager.AuthenticatedSession)value;
                AuthenticatedSessionManager.AuthenticatedSession authenticatedSession = AUTO_REAUTHENTICATING_MECHANISMS.contains(auth.getMechanism()) ? this.setLocalContext(auth) : session.getAttributes().setAttribute(name, (Object)auth);
                return authenticatedSession;
            }
            if (!(value instanceof Serializable)) {
                throw new IllegalArgumentException(new NotSerializableException(value.getClass().getName()));
            }
            Object old = session.getAttributes().setAttribute(name, value);
            if (old == null) {
                this.manager.getSessionListeners().attributeAdded((io.undertow.server.session.Session)this, name, value);
            } else if (old != value) {
                this.manager.getSessionListeners().attributeUpdated((io.undertow.server.session.Session)this, name, value, old);
            }
            Object object = old;
            return object;
        }
    }

    public Object removeAttribute(String name) {
        Session<LocalSessionContext> session = this.entry.getKey();
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            if (AUTHENTICATED_SESSION_ATTRIBUTE_NAME.equals(name)) {
                AuthenticatedSessionManager.AuthenticatedSession auth = (AuthenticatedSessionManager.AuthenticatedSession)session.getAttributes().removeAttribute(name);
                AuthenticatedSessionManager.AuthenticatedSession authenticatedSession = auth != null ? auth : this.setLocalContext(null);
                return authenticatedSession;
            }
            Object old = session.getAttributes().removeAttribute(name);
            if (old != null) {
                this.manager.getSessionListeners().attributeRemoved((io.undertow.server.session.Session)this, name, old);
            }
            Object object = old;
            return object;
        }
    }

    public void invalidate(HttpServerExchange exchange) {
        Map.Entry<Session<LocalSessionContext>, SessionConfig> entry = this.entry;
        Session<LocalSessionContext> session = entry.getKey();
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            this.manager.getSessionListeners().sessionDestroyed((io.undertow.server.session.Session)this, exchange, SessionListener.SessionDestroyedReason.INVALIDATED);
            session.invalidate();
            if (exchange != null) {
                String id = session.getId();
                entry.getValue().clearSession(exchange, id);
            }
            this.batch.close();
        }
    }

    public String changeSessionId(HttpServerExchange exchange, SessionConfig config) {
        Session<LocalSessionContext> oldSession = this.entry.getKey();
        org.wildfly.clustering.web.session.SessionManager<LocalSessionContext, Batch> manager = this.manager.getSessionManager();
        String id = (String)manager.createIdentifier();
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            Session newSession = manager.createSession(id);
            for (String name : oldSession.getAttributes().getAttributeNames()) {
                newSession.getAttributes().setAttribute(name, oldSession.getAttributes().getAttribute(name));
            }
            newSession.getMetaData().setMaxInactiveInterval(oldSession.getMetaData().getMaxInactiveInterval(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            newSession.getMetaData().setLastAccessedTime(oldSession.getMetaData().getLastAccessedTime());
            ((LocalSessionContext)newSession.getLocalContext()).setAuthenticatedSession(((LocalSessionContext)oldSession.getLocalContext()).getAuthenticatedSession());
            config.setSessionId(exchange, id);
            this.entry = new AbstractMap.SimpleImmutableEntry<Session, SessionConfig>(newSession, config);
            oldSession.invalidate();
            String string = id;
            return string;
        }
    }

    private AuthenticatedSessionManager.AuthenticatedSession setLocalContext(AuthenticatedSessionManager.AuthenticatedSession auth) {
        LocalSessionContext localContext = (LocalSessionContext)this.entry.getKey().getLocalContext();
        AuthenticatedSessionManager.AuthenticatedSession old = localContext.getAuthenticatedSession();
        localContext.setAuthenticatedSession(auth);
        return old;
    }
}

