/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jboss.as.patching.IoUtils;

public class ZipUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File sourceDir, File zipFile) {
        try {
            FileOutputStream os = new FileOutputStream(zipFile);
            try {
                ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(os));
                try {
                    for (File file : sourceDir.listFiles()) {
                        if (file.isDirectory()) {
                            ZipUtils.addDirectoryToZip(file, file.getName(), zos);
                            continue;
                        }
                        ZipUtils.addFileToZip(file, null, zos);
                    }
                }
                finally {
                    IoUtils.safeClose(zos);
                }
            }
            finally {
                IoUtils.safeClose(os);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed creating patch file " + zipFile, e);
        }
        System.out.println("\nPrepared " + zipFile.getName() + " at " + zipFile.getAbsolutePath());
    }

    private static void addDirectoryToZip(File dir, String dirName, ZipOutputStream zos) throws IOException {
        ZipEntry dirEntry = new ZipEntry(dirName + "/");
        zos.putNextEntry(dirEntry);
        zos.closeEntry();
        File[] children = dir.listFiles();
        if (children != null) {
            for (File file : children) {
                if (file.isDirectory()) {
                    ZipUtils.addDirectoryToZip(file, dirName + "/" + file.getName(), zos);
                    continue;
                }
                ZipUtils.addFileToZip(file, dirName, zos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFileToZip(File file, String parent, ZipOutputStream zos) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            String entryName = parent == null ? file.getName() : parent + "/" + file.getName();
            zos.putNextEntry(new ZipEntry(entryName));
            BufferedInputStream bis = new BufferedInputStream(is);
            try {
                IoUtils.copyStream(bis, zos);
            }
            finally {
                IoUtils.safeClose(bis);
            }
            zos.closeEntry();
        }
        finally {
            IoUtils.safeClose(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zip, File patchDir) throws IOException {
        ZipFile zipFile = new ZipFile(zip);
        try {
            ZipUtils.unzip(zipFile, patchDir);
            zipFile.close();
        }
        finally {
            IoUtils.safeClose(zipFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(ZipFile zip, File patchDir) throws IOException {
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            File current = new File(patchDir, name);
            if (entry.isDirectory()) continue;
            if (!current.getParentFile().exists()) {
                current.getParentFile().mkdirs();
            }
            InputStream eis = zip.getInputStream(entry);
            try {
                IoUtils.copy(eis, current);
            }
            finally {
                IoUtils.safeClose(eis);
            }
        }
    }
}

