/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.config;

import java.io.InputStream;
import java.util.ArrayList;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.StringUtil;
import org.picketlink.config.federation.IDPType;
import org.picketlink.config.federation.ProviderType;
import org.picketlink.config.federation.SPType;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.saml.v2.metadata.EntitiesDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.web.config.AbstractSAMLConfigurationProvider;
import org.picketlink.identity.federation.web.config.SecurityActions;

public abstract class AbstractSPMetadataConfigurationProvider
extends AbstractSAMLConfigurationProvider {
    public static final String DEFAULT_SP_MD_FILE = "sp-metadata.xml";
    public static final String DEFAULT_IDP_MD_FILE = "idp-metadata.xml";
    private String spMetadataLocation;
    private String idpMetadataLocation;

    @Override
    public IDPType getIDPConfiguration() throws ProcessingException {
        throw new RuntimeException("PL00020: Illegal Method Called");
    }

    @Override
    public SPType getSPConfiguration() throws ProcessingException {
        SPType spType = null;
        if (this.fileAvailable()) {
            try {
                spType = CoreConfigUtil.getSPConfiguration(this.parseMDFile(), this.getBindingURI());
            }
            catch (ParsingException e) {
                throw logger.processingError((Throwable)e);
            }
            catch (ConfigurationException ce) {
                throw logger.processingError((Throwable)ce);
            }
        }
        this.importFromPicketLinkConfiguration(spType);
        return spType;
    }

    protected abstract String getBindingURI();

    private EntitiesDescriptorType parseMDFile() throws ParsingException {
        EntitiesDescriptorType entities;
        Object spMetadata = this.parseSPMetadata();
        Object idpMetadata = this.parseIdPMetadata();
        if (EntitiesDescriptorType.class.isInstance(spMetadata)) {
            entities = (EntitiesDescriptorType)spMetadata;
            if (idpMetadata != null) {
                this.removeIdPDescriptor(entities);
            }
        } else {
            entities = new EntitiesDescriptorType();
            entities.addEntityDescriptor(spMetadata);
        }
        if (idpMetadata != null) {
            entities.addEntityDescriptor(idpMetadata);
        }
        return entities;
    }

    private void removeIdPDescriptor(EntitiesDescriptorType entities) {
        for (Object descriptorType : new ArrayList<Object>(entities.getEntityDescriptor())) {
            for (EntityDescriptorType.EDTChoiceType choiceType : ((EntityDescriptorType)descriptorType).getChoiceType()) {
                for (EntityDescriptorType.EDTDescriptorChoiceType descriptorChoiceType : choiceType.getDescriptors()) {
                    if (descriptorChoiceType.getIdpDescriptor() == null) continue;
                    entities.removeEntityDescriptor(descriptorType);
                }
            }
        }
    }

    private Object parseSPMetadata() throws ParsingException {
        InputStream spMetadataStream = SecurityActions.loadStream(this.getClass(), this.getSpMetadataLocation());
        if (spMetadataStream == null) {
            throw logger.nullValueError(this.getSpMetadataLocation());
        }
        return new SAMLParser().parse(spMetadataStream);
    }

    private Object parseIdPMetadata() throws ParsingException {
        InputStream configStream;
        EntityDescriptorType idpEntityDescriptor = null;
        if (!StringUtil.isNullOrEmpty((String)this.getIdpMetadataLocation()) && (configStream = SecurityActions.loadStream(this.getClass(), this.getIdpMetadataLocation())) != null) {
            Object idpParsedType = new SAMLParser().parse(configStream);
            idpEntityDescriptor = EntitiesDescriptorType.class.isInstance(idpParsedType) ? (EntityDescriptorType)((EntitiesDescriptorType)idpParsedType).getEntityDescriptor().get(0) : (EntityDescriptorType)idpParsedType;
        }
        return idpEntityDescriptor;
    }

    private void importFromPicketLinkConfiguration(SPType spType) {
        if (this.configParsedSPType != null) {
            spType.importFrom((ProviderType)this.configParsedSPType);
        }
    }

    private boolean fileAvailable() {
        InputStream is = SecurityActions.loadStream(this.getClass(), this.getSpMetadataLocation());
        return is != null;
    }

    public String getSpMetadataLocation() {
        if (this.spMetadataLocation == null) {
            this.spMetadataLocation = DEFAULT_SP_MD_FILE;
        }
        return this.spMetadataLocation;
    }

    public void setSpMetadataLocation(String spMetadataLocation) {
        this.spMetadataLocation = spMetadataLocation;
    }

    public String getIdpMetadataLocation() {
        if (this.idpMetadataLocation == null) {
            this.idpMetadataLocation = DEFAULT_IDP_MD_FILE;
        }
        return this.idpMetadataLocation;
    }

    public void setIdpMetadataLocation(String idpMetadataLocation) {
        this.idpMetadataLocation = idpMetadataLocation;
    }
}

