/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.ClientModel;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.entities.FederatedIdentityEntity;
import org.keycloak.models.mongo.keycloak.adapters.UserAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoUserConsentEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoUserEntity;
import org.keycloak.models.utils.CredentialValidation;

public class MongoUserProvider
implements UserProvider {
    private final MongoStoreInvocationContext invocationContext;
    private final KeycloakSession session;

    public MongoUserProvider(KeycloakSession session, MongoStoreInvocationContext invocationContext) {
        this.session = session;
        this.invocationContext = invocationContext;
    }

    public void close() {
    }

    public UserModel getUserById(String id, RealmModel realm) {
        MongoUserEntity user = (MongoUserEntity)this.getMongoStore().loadEntity(MongoUserEntity.class, id, this.invocationContext);
        if (user == null || !realm.getId().equals(user.getRealmId())) {
            return null;
        }
        return new UserAdapter(this.session, realm, user, this.invocationContext);
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        DBObject query = new QueryBuilder().and("username").is((Object)username.toLowerCase()).and("realmId").is((Object)realm.getId()).get();
        MongoUserEntity user = (MongoUserEntity)this.getMongoStore().loadSingleEntity(MongoUserEntity.class, query, this.invocationContext);
        if (user == null) {
            return null;
        }
        return new UserAdapter(this.session, realm, user, this.invocationContext);
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        DBObject query = new QueryBuilder().and("email").is((Object)email.toLowerCase()).and("realmId").is((Object)realm.getId()).get();
        MongoUserEntity user = (MongoUserEntity)this.getMongoStore().loadSingleEntity(MongoUserEntity.class, query, this.invocationContext);
        if (user == null) {
            return null;
        }
        return new UserAdapter(this.session, realm, user, this.invocationContext);
    }

    protected MongoStore getMongoStore() {
        return this.invocationContext.getMongoStore();
    }

    public UserModel getUserByFederatedIdentity(FederatedIdentityModel socialLink, RealmModel realm) {
        DBObject query = new QueryBuilder().and("federatedIdentities.identityProvider").is((Object)socialLink.getIdentityProvider()).and("federatedIdentities.userId").is((Object)socialLink.getUserId()).and("realmId").is((Object)realm.getId()).get();
        MongoUserEntity userEntity = (MongoUserEntity)this.getMongoStore().loadSingleEntity(MongoUserEntity.class, query, this.invocationContext);
        return userEntity == null ? null : new UserAdapter(this.session, realm, userEntity, this.invocationContext);
    }

    protected List<UserModel> convertUserEntities(RealmModel realm, List<MongoUserEntity> userEntities) {
        ArrayList<UserModel> userModels = new ArrayList<UserModel>();
        for (MongoUserEntity user : userEntities) {
            userModels.add(new UserAdapter(this.session, realm, user, this.invocationContext));
        }
        return userModels;
    }

    public List<UserModel> getUsers(RealmModel realm) {
        return this.getUsers(realm, -1, -1);
    }

    public int getUsersCount(RealmModel realm) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).get();
        return this.getMongoStore().countEntities(MongoUserEntity.class, query, this.invocationContext);
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).get();
        BasicDBObject sort = new BasicDBObject("username", (Object)1);
        List users = this.getMongoStore().loadEntities(MongoUserEntity.class, query, (DBObject)sort, firstResult, maxResults, this.invocationContext);
        return this.convertUserEntities(realm, users);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.searchForUser(search, realm, -1, -1);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
        QueryBuilder nameBuilder;
        search = search.trim();
        Pattern caseInsensitivePattern = Pattern.compile("(?i:" + search + ")");
        int spaceInd = search.lastIndexOf(" ");
        if (spaceInd != -1) {
            String firstName = search.substring(0, spaceInd);
            String lastName = search.substring(spaceInd + 1);
            Pattern firstNamePattern = Pattern.compile("(?i:" + firstName + "$)");
            Pattern lastNamePattern = Pattern.compile("(?i:^" + lastName + ")");
            nameBuilder = new QueryBuilder().and(new DBObject[]{new QueryBuilder().put("firstName").regex(firstNamePattern).get(), new QueryBuilder().put("lastName").regex(lastNamePattern).get()});
        } else {
            nameBuilder = new QueryBuilder().or(new DBObject[]{new QueryBuilder().put("firstName").regex(caseInsensitivePattern).get(), new QueryBuilder().put("lastName").regex(caseInsensitivePattern).get()});
        }
        QueryBuilder builder = new QueryBuilder().and(new DBObject[]{new QueryBuilder().and("realmId").is((Object)realm.getId()).get(), new QueryBuilder().or(new DBObject[]{new QueryBuilder().put("username").regex(caseInsensitivePattern).get(), new QueryBuilder().put("email").regex(caseInsensitivePattern).get(), nameBuilder.get()}).get()});
        BasicDBObject sort = new BasicDBObject("username", (Object)1);
        List users = this.getMongoStore().loadEntities(MongoUserEntity.class, builder.get(), (DBObject)sort, firstResult, maxResults, this.invocationContext);
        return this.convertUserEntities(realm, users);
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm) {
        return this.searchForUserByAttributes(attributes, realm, -1, -1);
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm, int firstResult, int maxResults) {
        QueryBuilder queryBuilder = new QueryBuilder().and("realmId").is((Object)realm.getId());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("username")) {
                queryBuilder.and("username").regex(Pattern.compile(".*" + entry.getValue() + ".*", 2));
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("firstName")) {
                queryBuilder.and("firstName").regex(Pattern.compile(".*" + entry.getValue() + ".*", 2));
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("lastName")) {
                queryBuilder.and("lastName").regex(Pattern.compile(".*" + entry.getValue() + ".*", 2));
                continue;
            }
            if (!entry.getKey().equalsIgnoreCase("email")) continue;
            queryBuilder.and("email").regex(Pattern.compile(".*" + entry.getValue() + ".*", 2));
        }
        BasicDBObject sort = new BasicDBObject("username", (Object)1);
        List users = this.getMongoStore().loadEntities(MongoUserEntity.class, queryBuilder.get(), (DBObject)sort, firstResult, maxResults, this.invocationContext);
        return this.convertUserEntities(realm, users);
    }

    public Set<FederatedIdentityModel> getFederatedIdentities(UserModel userModel, RealmModel realm) {
        UserModel user = this.getUserById(userModel.getId(), realm);
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        List linkEntities = userEntity.getFederatedIdentities();
        if (linkEntities == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<FederatedIdentityModel> result = new HashSet<FederatedIdentityModel>();
        for (FederatedIdentityEntity federatedIdentityEntity : linkEntities) {
            FederatedIdentityModel model = new FederatedIdentityModel(federatedIdentityEntity.getIdentityProvider(), federatedIdentityEntity.getUserId(), federatedIdentityEntity.getUserName(), federatedIdentityEntity.getToken());
            result.add(model);
        }
        return result;
    }

    public FederatedIdentityModel getFederatedIdentity(UserModel user, String socialProvider, RealmModel realm) {
        MongoUserEntity userEntity = ((UserAdapter)(user = this.getUserById(user.getId(), realm))).getUser();
        FederatedIdentityEntity federatedIdentityEntity = this.findFederatedIdentityLink(userEntity, socialProvider);
        return federatedIdentityEntity != null ? new FederatedIdentityModel(federatedIdentityEntity.getIdentityProvider(), federatedIdentityEntity.getUserId(), federatedIdentityEntity.getUserName(), federatedIdentityEntity.getToken()) : null;
    }

    public UserAdapter addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        UserAdapter userModel = this.addUserEntity(realm, id, username.toLowerCase());
        if (addDefaultRoles) {
            for (String r : realm.getDefaultRoles()) {
                userModel.grantRole(realm.getRole(r));
            }
            for (ClientModel application : realm.getClients()) {
                for (String r : application.getDefaultRoles()) {
                    userModel.grantRole(application.getRole(r));
                }
            }
        }
        if (addDefaultRequiredActions) {
            for (String r : realm.getDefaultRequiredActions()) {
                userModel.addRequiredAction(r);
            }
        }
        return userModel;
    }

    protected UserAdapter addUserEntity(RealmModel realm, String id, String username) {
        MongoUserEntity userEntity = new MongoUserEntity();
        userEntity.setId(id);
        userEntity.setUsername(username);
        userEntity.setRealmId(realm.getId());
        this.getMongoStore().insertEntity((MongoIdentifiableEntity)userEntity, this.invocationContext);
        return new UserAdapter(this.session, realm, userEntity, this.invocationContext);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        return this.getMongoStore().removeEntity(MongoUserEntity.class, user.getId(), this.invocationContext);
    }

    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel identity) {
        user = this.getUserById(user.getId(), realm);
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        FederatedIdentityEntity federatedIdentityEntity = new FederatedIdentityEntity();
        federatedIdentityEntity.setIdentityProvider(identity.getIdentityProvider());
        federatedIdentityEntity.setUserId(identity.getUserId());
        federatedIdentityEntity.setUserName(identity.getUserName().toLowerCase());
        federatedIdentityEntity.setToken(identity.getToken());
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)userEntity, "federatedIdentities", (Object)federatedIdentityEntity, true, this.invocationContext);
    }

    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        federatedUser = this.getUserById(federatedUser.getId(), realm);
        MongoUserEntity userEntity = ((UserAdapter)federatedUser).getUser();
        FederatedIdentityEntity federatedIdentityEntity = this.findFederatedIdentityLink(userEntity, federatedIdentityModel.getIdentityProvider());
        federatedIdentityEntity.setToken(federatedIdentityModel.getToken());
    }

    public boolean removeFederatedIdentity(RealmModel realm, UserModel userModel, String socialProvider) {
        UserModel user = this.getUserById(userModel.getId(), realm);
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        FederatedIdentityEntity federatedIdentityEntity = this.findFederatedIdentityLink(userEntity, socialProvider);
        if (federatedIdentityEntity == null) {
            return false;
        }
        return this.getMongoStore().pullItemFromList((MongoIdentifiableEntity)userEntity, "federatedIdentities", (Object)federatedIdentityEntity, this.invocationContext);
    }

    private FederatedIdentityEntity findFederatedIdentityLink(MongoUserEntity userEntity, String identityProvider) {
        List linkEntities = userEntity.getFederatedIdentities();
        if (linkEntities == null) {
            return null;
        }
        for (FederatedIdentityEntity federatedIdentityEntity : linkEntities) {
            if (!federatedIdentityEntity.getIdentityProvider().equals(identityProvider)) continue;
            return federatedIdentityEntity;
        }
        return null;
    }

    public UserModel addUser(RealmModel realm, String username) {
        return this.addUser(realm, null, username, true, true);
    }

    public void preRemove(RealmModel realm) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).get();
        this.getMongoStore().removeEntities(MongoUserEntity.class, query, true, this.invocationContext);
    }

    public void preRemove(RealmModel realm, UserFederationProviderModel link) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).and("federationLink").is((Object)link.getId()).get();
        this.getMongoStore().removeEntities(MongoUserEntity.class, query, true, this.invocationContext);
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        for (RoleModel role : client.getRoles()) {
            this.preRemove(realm, role);
        }
        DBObject query = new QueryBuilder().and("clientId").is((Object)client.getId()).get();
        this.getMongoStore().removeEntities(MongoUserConsentEntity.class, query, false, this.invocationContext);
    }

    public void preRemove(ClientModel client, ProtocolMapperModel protocolMapper) {
        DBObject query = new QueryBuilder().and("grantedProtocolMappers").is((Object)protocolMapper.getId()).get();
        BasicDBObject pull = new BasicDBObject("$pull", (Object)query);
        this.getMongoStore().updateEntities(MongoUserConsentEntity.class, query, (DBObject)pull, this.invocationContext);
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        DBObject query = new QueryBuilder().and("roleIds").is((Object)role.getId()).get();
        BasicDBObject pull = new BasicDBObject("$pull", (Object)query);
        this.getMongoStore().updateEntities(MongoUserEntity.class, query, (DBObject)pull, this.invocationContext);
        query = new QueryBuilder().and("grantedRoles").is((Object)role.getId()).get();
        pull = new BasicDBObject("$pull", (Object)query);
        this.getMongoStore().updateEntities(MongoUserConsentEntity.class, query, (DBObject)pull, this.invocationContext);
    }

    public boolean validCredentials(RealmModel realm, UserModel user, List<UserCredentialModel> input) {
        return CredentialValidation.validCredentials((RealmModel)realm, (UserModel)user, input);
    }

    public boolean validCredentials(RealmModel realm, UserModel user, UserCredentialModel ... input) {
        return CredentialValidation.validCredentials((RealmModel)realm, (UserModel)user, (UserCredentialModel[])input);
    }

    public CredentialValidationOutput validCredentials(RealmModel realm, UserCredentialModel ... input) {
        return null;
    }
}

