/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.jaspi.config;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ClientAuthContext;
import javax.security.auth.message.module.ClientAuthModule;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.cxf.common.util.StringUtils;
import org.jboss.security.auth.container.config.AuthModuleEntry;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.auth.message.config.JBossClientAuthConfig;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.plugins.ClassLoaderLocator;
import org.jboss.security.plugins.ClassLoaderLocatorFactory;
import org.jboss.wsf.stack.cxf.jaspi.config.JBossWSClientAuthContext;
import org.jboss.wsf.stack.cxf.jaspi.config.SecurityActions;

public class JBossWSClientAuthConfig
extends JBossClientAuthConfig {
    private final List modules = new ArrayList();
    private CallbackHandler callbackHandler;

    public JBossWSClientAuthConfig(String layer, String appContext, CallbackHandler handler, Map properties) {
        super(layer, appContext, handler, properties);
        this.callbackHandler = handler;
    }

    public ClientAuthContext getAuthContext(String authContextID, Subject clientSubject, Map properties) throws AuthException {
        ClassLoaderLocator locator;
        ArrayList<ControlFlag> controlFlags = new ArrayList<ControlFlag>();
        HashMap<String, Map> mapOptionsByName = new HashMap<String, Map>();
        JASPIAuthenticationInfo jai = (JASPIAuthenticationInfo)properties.get("jaspi-policy");
        AuthModuleEntry[] amearr = jai.getAuthModuleEntry();
        ClassLoader moduleCL = null;
        String jbossModule = jai.getJBossModuleName();
        if (jbossModule != null && !jbossModule.isEmpty() && (locator = ClassLoaderLocatorFactory.get()) != null) {
            moduleCL = locator.get(jbossModule);
        }
        for (AuthModuleEntry ame : amearr) {
            try {
                mapOptionsByName.put(ame.getAuthModuleName(), ame.getOptions());
                controlFlags.add(ame.getControlFlag());
                ClientAuthModule sam = this.createCAM(moduleCL, ame.getAuthModuleName());
                HashMap options = new HashMap();
                sam.initialize(null, null, this.callbackHandler, options);
                this.modules.add(sam);
            }
            catch (Exception e) {
                throw new AuthException(e.getLocalizedMessage());
            }
        }
        JBossWSClientAuthContext clientAuthContext = new JBossWSClientAuthContext(this.modules, mapOptionsByName, this.callbackHandler);
        clientAuthContext.setControlFlags(controlFlags);
        return clientAuthContext;
    }

    private ClientAuthModule createCAM(ClassLoader moduleCL, String name) throws Exception {
        Class<?> clazz = SecurityActions.loadClass(moduleCL, name);
        Constructor<?> ctr = clazz.getConstructor(new Class[0]);
        return (ClientAuthModule)ctr.newInstance(new Object[0]);
    }

    public List getClientAuthModules() {
        return this.modules;
    }

    public String getAuthContextID(MessageInfo messageInfo) {
        String[] soapActions;
        SOAPMessage request = (SOAPMessage)messageInfo.getRequestMessage();
        if (request == null) {
            return null;
        }
        String authContext = null;
        MimeHeaders headers = request.getMimeHeaders();
        if (headers != null && (soapActions = headers.getHeader("SOAPAction")) != null && soapActions.length > 0 && !StringUtils.isEmpty((String)(authContext = soapActions[0]))) {
            return authContext;
        }
        SOAPPart soapMessage = request.getSOAPPart();
        if (soapMessage != null) {
            try {
                SOAPBody body;
                SOAPEnvelope envelope = soapMessage.getEnvelope();
                if (envelope != null && (body = envelope.getBody()) != null) {
                    Iterator it = body.getChildElements();
                    while (it.hasNext()) {
                        Object o = it.next();
                        if (!(o instanceof SOAPElement)) continue;
                        QName name = ((SOAPElement)o).getElementQName();
                        return name.getLocalPart();
                    }
                }
            }
            catch (SOAPException se) {
                // empty catch block
            }
        }
        return null;
    }
}

