/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.ClientConnection;
import org.keycloak.events.Event;
import org.keycloak.events.EventQuery;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.AdminEventQuery;
import org.keycloak.events.admin.OperationType;
import org.keycloak.exportimport.ClientImporter;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.CacheUserProvider;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.LDAPConnectionTestManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.managers.UsersSyncManager;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AttackDetectionResource;
import org.keycloak.services.resources.admin.AuthenticationManagementResource;
import org.keycloak.services.resources.admin.ClientsResource;
import org.keycloak.services.resources.admin.IdentityProvidersResource;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.admin.RoleByIdResource;
import org.keycloak.services.resources.admin.RoleContainerResource;
import org.keycloak.services.resources.admin.UserFederationProvidersResource;
import org.keycloak.services.resources.admin.UsersResource;
import org.keycloak.timer.TimerProvider;

public class RealmAdminResource {
    protected static final Logger logger = Logger.getLogger(RealmAdminResource.class);
    protected RealmAuth auth;
    protected RealmModel realm;
    private TokenManager tokenManager;
    private AdminEventBuilder adminEvent;
    @Context
    protected KeycloakSession session;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ClientConnection connection;
    @Context
    protected HttpHeaders headers;

    public RealmAdminResource(RealmAuth auth, RealmModel realm, TokenManager tokenManager, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.tokenManager = tokenManager;
        this.adminEvent = adminEvent.realm(realm);
        auth.init(RealmAuth.Resource.REALM);
    }

    @Path(value="client-importers/{formatId}")
    public Object getClientImporter(@PathParam(value="formatId") String formatId) {
        ClientImporter importer = (ClientImporter)this.session.getProvider(ClientImporter.class, formatId);
        return importer.createJaxrsService(this.realm, this.auth);
    }

    @Path(value="attack-detection")
    public AttackDetectionResource getClientImporter() {
        AttackDetectionResource resource = new AttackDetectionResource(this.auth, this.realm, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="clients")
    public ClientsResource getClients() {
        ClientsResource clientsResource = new ClientsResource(this.realm, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)clientsResource);
        return clientsResource;
    }

    @Path(value="roles")
    public RoleContainerResource getRoleContainerResource() {
        return new RoleContainerResource(this.uriInfo, this.realm, this.auth, (RoleContainerModel)this.realm, this.adminEvent);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public RealmRepresentation getRealm() {
        if (this.auth.hasView()) {
            RealmRepresentation rep = ModelToRepresentation.toRepresentation((RealmModel)this.realm, (boolean)false);
            if (this.session.realms() instanceof CacheRealmProvider) {
                CacheRealmProvider cacheRealmProvider = (CacheRealmProvider)this.session.realms();
                rep.setRealmCacheEnabled(Boolean.valueOf(cacheRealmProvider.isEnabled()));
            }
            if (this.session.userStorage() instanceof CacheUserProvider) {
                CacheUserProvider cache = (CacheUserProvider)this.session.userStorage();
                rep.setUserCacheEnabled(Boolean.valueOf(cache.isEnabled()));
            }
            return rep;
        }
        this.auth.requireAny();
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm(this.realm.getName());
        return rep;
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response updateRealm(RealmRepresentation rep) {
        this.auth.requireManage();
        logger.debug((Object)("updating realm: " + this.realm.getName()));
        try {
            RepresentationToModel.updateRealm((RealmRepresentation)rep, (RealmModel)this.realm);
            if (rep.isRealmCacheEnabled() != null && this.session.realms() instanceof CacheRealmProvider) {
                CacheRealmProvider cacheRealmProvider = (CacheRealmProvider)this.session.realms();
                cacheRealmProvider.setEnabled(rep.isRealmCacheEnabled().booleanValue());
            }
            if (rep.isUserCacheEnabled() != null && this.session.userStorage() instanceof CacheUserProvider) {
                CacheUserProvider cache = (CacheUserProvider)this.session.userStorage();
                cache.setEnabled(rep.isUserCacheEnabled().booleanValue());
            }
            List federationProviders = this.realm.getUserFederationProviders();
            UsersSyncManager usersSyncManager = new UsersSyncManager();
            for (UserFederationProviderModel fedProvider : federationProviders) {
                usersSyncManager.refreshPeriodicSyncForProvider(this.session.getKeycloakSessionFactory(), (TimerProvider)this.session.getProvider(TimerProvider.class), fedProvider, this.realm.getId());
            }
            this.adminEvent.operation(OperationType.UPDATE).representation(rep).success();
            return Response.noContent().build();
        }
        catch (PatternSyntaxException e) {
            return ErrorResponse.error("Specified regex pattern(s) is invalid.", Response.Status.BAD_REQUEST);
        }
        catch (ModelDuplicateException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return ErrorResponse.error("Failed to update " + rep.getRealm() + " Realm.", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    public void deleteRealm() {
        this.auth.requireManage();
        if (!new RealmManager(this.session).removeRealm(this.realm)) {
            throw new NotFoundException("Realm doesn't exist");
        }
        this.clearAdminEvents();
    }

    @Path(value="users")
    public UsersResource users() {
        UsersResource users = new UsersResource(this.realm, this.auth, this.tokenManager, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)users);
        return users;
    }

    @Path(value="user-federation")
    public UserFederationProvidersResource userFederation() {
        UserFederationProvidersResource fed = new UserFederationProvidersResource(this.realm, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)fed);
        return fed;
    }

    @Path(value="authentication")
    public AuthenticationManagementResource flows() {
        AuthenticationManagementResource resource = new AuthenticationManagementResource(this.realm, this.session, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="roles-by-id")
    public RoleByIdResource rolesById() {
        RoleByIdResource resource = new RoleByIdResource(this.realm, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="push-revocation")
    @POST
    public GlobalRequestResult pushRevocation() {
        this.auth.requireManage();
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
        return new ResourceAdminManager(this.session).pushRealmRevocationPolicy(this.uriInfo.getRequestUri(), this.realm);
    }

    @Path(value="logout-all")
    @POST
    public GlobalRequestResult logoutAll() {
        this.auth.init(RealmAuth.Resource.USER).requireManage();
        this.session.sessions().removeUserSessions(this.realm);
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
        return new ResourceAdminManager(this.session).logoutAll(this.uriInfo.getRequestUri(), this.realm);
    }

    @Path(value="sessions/{session}")
    @DELETE
    public void deleteSession(@PathParam(value="session") String sessionId) {
        this.auth.init(RealmAuth.Resource.USER).requireManage();
        UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, sessionId);
        if (userSession == null) {
            throw new NotFoundException("Sesssion not found");
        }
        AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, this.uriInfo, this.connection, this.headers, true);
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
    }

    @Path(value="client-session-stats")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<Map<String, String>> getClientSessionStats() {
        this.auth.requireView();
        LinkedList<Map<String, String>> data = new LinkedList<Map<String, String>>();
        for (ClientModel client : this.realm.getClients()) {
            int size = this.session.sessions().getActiveUserSessions(client.getRealm(), client);
            if (size == 0) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", client.getId());
            map.put("clientId", client.getClientId());
            map.put("active", size + "");
            data.add(map);
        }
        return data;
    }

    @GET
    @NoCache
    @Path(value="events/config")
    @Produces(value={"application/json"})
    public RealmEventsConfigRepresentation getRealmEventsConfig() {
        this.auth.init(RealmAuth.Resource.EVENTS).requireView();
        return ModelToRepresentation.toEventsConfigReprensetation((RealmModel)this.realm);
    }

    @PUT
    @Path(value="events/config")
    @Consumes(value={"application/json"})
    public void updateRealmEventsConfig(RealmEventsConfigRepresentation rep) {
        this.auth.init(RealmAuth.Resource.EVENTS).requireManage();
        logger.debug((Object)("updating realm events config: " + this.realm.getName()));
        new RealmManager(this.session).updateRealmEventsConfig(rep, this.realm);
    }

    @Path(value="events")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<Event> getEvents(@QueryParam(value="client") String client, @QueryParam(value="user") String user, @QueryParam(value="dateFrom") String dateFrom, @QueryParam(value="dateTo") String dateTo, @QueryParam(value="ipAddress") String ipAddress, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        SimpleDateFormat df;
        List types;
        this.auth.init(RealmAuth.Resource.EVENTS).requireView();
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        EventQuery query = eventStore.createQuery().realm(this.realm.getId());
        if (client != null) {
            query.client(client);
        }
        if ((types = (List)this.uriInfo.getQueryParameters().get((Object)"type")) != null) {
            EventType[] t = new EventType[types.size()];
            for (int i = 0; i < t.length; ++i) {
                t[i] = EventType.valueOf((String)((String)types.get(i)));
            }
            query.type(t);
        }
        if (user != null) {
            query.user(user);
        }
        if (dateFrom != null) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            Date from = null;
            try {
                from = df.parse(dateFrom);
            }
            catch (ParseException e) {
                throw new BadRequestException("Invalid value for 'Date(From)', expected format is yyyy-MM-dd");
            }
            query.fromDate(from);
        }
        if (dateTo != null) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            Date to = null;
            try {
                to = df.parse(dateTo);
            }
            catch (ParseException e) {
                throw new BadRequestException("Invalid value for 'Date(To)', expected format is yyyy-MM-dd");
            }
            query.toDate(to);
        }
        if (ipAddress != null) {
            query.ipAddress(ipAddress);
        }
        if (firstResult != null) {
            query.firstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.maxResults(maxResults.intValue());
        }
        return query.getResultList();
    }

    @Path(value="admin-events")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<AdminEvent> getEvents(@QueryParam(value="authRealm") String authRealm, @QueryParam(value="authClient") String authClient, @QueryParam(value="authUser") String authUser, @QueryParam(value="authIpAddress") String authIpAddress, @QueryParam(value="resourcePath") String resourcePath, @QueryParam(value="dateFrom") String dateFrom, @QueryParam(value="dateTo") String dateTo, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        SimpleDateFormat df;
        List operationTypes;
        this.auth.init(RealmAuth.Resource.EVENTS).requireView();
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        AdminEventQuery query = eventStore.createAdminQuery().realm(this.realm.getId());
        if (authRealm != null) {
            query.authRealm(authRealm);
        }
        if (authClient != null) {
            query.authClient(authClient);
        }
        if (authUser != null) {
            query.authUser(authUser);
        }
        if (authIpAddress != null) {
            query.authIpAddress(authIpAddress);
        }
        if (resourcePath != null) {
            query.resourcePath(resourcePath);
        }
        if ((operationTypes = (List)this.uriInfo.getQueryParameters().get((Object)"operationTypes")) != null) {
            OperationType[] t = new OperationType[operationTypes.size()];
            for (int i = 0; i < t.length; ++i) {
                t[i] = OperationType.valueOf((String)((String)operationTypes.get(i)));
            }
            query.operation(t);
        }
        if (dateFrom != null) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            Date from = null;
            try {
                from = df.parse(dateFrom);
            }
            catch (ParseException e) {
                throw new BadRequestException("Invalid value for 'Date(From)', expected format is yyyy-MM-dd");
            }
            query.fromTime(from);
        }
        if (dateTo != null) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            Date to = null;
            try {
                to = df.parse(dateTo);
            }
            catch (ParseException e) {
                throw new BadRequestException("Invalid value for 'Date(To)', expected format is yyyy-MM-dd");
            }
            query.toTime(to);
        }
        if (firstResult != null) {
            query.firstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.maxResults(maxResults.intValue());
        }
        return query.getResultList();
    }

    @Path(value="events")
    @DELETE
    public void clearEvents() {
        this.auth.init(RealmAuth.Resource.EVENTS).requireManage();
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        eventStore.clear(this.realm.getId());
    }

    @Path(value="admin-events")
    @DELETE
    public void clearAdminEvents() {
        this.auth.init(RealmAuth.Resource.EVENTS).requireManage();
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        eventStore.clearAdmin(this.realm.getId());
    }

    @Path(value="testLDAPConnection")
    @GET
    @NoCache
    public Response testLDAPConnection(@QueryParam(value="action") String action, @QueryParam(value="connectionUrl") String connectionUrl, @QueryParam(value="bindDn") String bindDn, @QueryParam(value="bindCredential") String bindCredential) {
        this.auth.init(RealmAuth.Resource.REALM).requireManage();
        boolean result = new LDAPConnectionTestManager().testLDAP(action, connectionUrl, bindDn, bindCredential);
        return result ? Response.noContent().build() : ErrorResponse.error("LDAP test error", Response.Status.BAD_REQUEST);
    }

    @Path(value="identity-provider")
    public IdentityProvidersResource getIdentityProviderResource() {
        return new IdentityProvidersResource(this.realm, this.session, this.auth, this.adminEvent);
    }
}

