/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.security.manager.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.metadata.parser.util.NoopXMLResolver;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.security.PermissionFactory;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.security.manager.deployment.PermissionsParser;

public class PermissionsParseProcessor
implements DeploymentUnitProcessor {
    private static final String PERMISSIONS_XML = "META-INF/permissions.xml";
    private static final String JBOSS_PERMISSIONS_XML = "META-INF/jboss-permissions.xml";
    private final List<PermissionFactory> minPermissions;
    private final List<PermissionFactory> maxPermissions;

    public PermissionsParseProcessor(List<PermissionFactory> minPermissions, List<PermissionFactory> maxPermissions) {
        this.minPermissions = minPermissions;
        this.maxPermissions = maxPermissions;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        block7: {
            ModuleSpecification moduleSpecification;
            DeploymentUnit deploymentUnit;
            block8: {
                ModuleIdentifier moduleIdentifier;
                ModuleLoader moduleLoader;
                ResourceRoot deploymentRoot;
                block6: {
                    deploymentUnit = phaseContext.getDeploymentUnit();
                    deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
                    moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
                    moduleLoader = (ModuleLoader)deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
                    moduleIdentifier = (ModuleIdentifier)deploymentUnit.getAttachment(Attachments.MODULE_IDENTIFIER);
                    VirtualFile jbossPermissionsXML = deploymentRoot.getRoot().getChild(JBOSS_PERMISSIONS_XML);
                    if (!jbossPermissionsXML.exists() || !jbossPermissionsXML.isFile()) break block6;
                    List<PermissionFactory> factories = this.parsePermissions(jbossPermissionsXML, moduleLoader, moduleIdentifier);
                    for (PermissionFactory permissionFactory : factories) {
                        moduleSpecification.addPermissionFactory(permissionFactory);
                    }
                    for (PermissionFactory permissionFactory : this.minPermissions) {
                        moduleSpecification.addPermissionFactory(permissionFactory);
                    }
                    break block7;
                }
                if (deploymentUnit.getParent() != null) break block8;
                VirtualFile permissionsXML = deploymentRoot.getRoot().getChild(PERMISSIONS_XML);
                if (permissionsXML.exists() && permissionsXML.isFile()) {
                    List<PermissionFactory> factories = this.parsePermissions(permissionsXML, moduleLoader, moduleIdentifier);
                    Iterator iterator = factories.iterator();
                    while (iterator.hasNext()) {
                        PermissionFactory factory2 = (PermissionFactory)iterator.next();
                        moduleSpecification.addPermissionFactory(factory2);
                    }
                }
                for (PermissionFactory permissionFactory : this.minPermissions) {
                    moduleSpecification.addPermissionFactory(permissionFactory);
                }
                break block7;
            }
            ModuleSpecification parentSpecification = (ModuleSpecification)deploymentUnit.getParent().getAttachment(Attachments.MODULE_SPECIFICATION);
            List factories = parentSpecification.getPermissionFactories();
            if (factories == null || factories.size() <= 0) break block7;
            for (PermissionFactory factory : factories) {
                moduleSpecification.addPermissionFactory(factory);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private List<PermissionFactory> parsePermissions(VirtualFile file, ModuleLoader loader, ModuleIdentifier identifier) throws DeploymentUnitProcessingException {
        InputStream inputStream = null;
        try {
            inputStream = file.openStream();
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setXMLResolver(NoopXMLResolver.create());
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(inputStream);
            List<PermissionFactory> list = PermissionsParser.parse(xmlReader, loader, identifier);
            return list;
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

