/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.saml.processing.api.saml.v2.response.SAML2Response;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.web.util.PostBindingUtil;
import org.keycloak.saml.processing.web.util.RedirectBindingUtil;

public class SAMLRequestParser {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static SAMLDocumentHolder parseRequestRedirectBinding(String samlMessage) {
        InputStream is = RedirectBindingUtil.base64DeflateDecode((String)samlMessage);
        SAML2Request saml2Request = new SAML2Request();
        try {
            saml2Request.getSAML2ObjectFromStream(is);
            return saml2Request.getSamlDocumentHolder();
        }
        catch (Exception e) {
            logger.samlBase64DecodingError((Throwable)e);
            return null;
        }
    }

    public static SAMLDocumentHolder parseRequestPostBinding(String samlMessage) {
        byte[] samlBytes = PostBindingUtil.base64Decode((String)samlMessage);
        ByteArrayInputStream is = new ByteArrayInputStream(samlBytes);
        SAML2Request saml2Request = new SAML2Request();
        try {
            saml2Request.getSAML2ObjectFromStream((InputStream)is);
            return saml2Request.getSamlDocumentHolder();
        }
        catch (Exception e) {
            logger.samlBase64DecodingError((Throwable)e);
            return null;
        }
    }

    public static SAMLDocumentHolder parseResponsePostBinding(String samlMessage) {
        byte[] samlBytes = PostBindingUtil.base64Decode((String)samlMessage);
        return SAMLRequestParser.parseResponseDocument(samlBytes);
    }

    public static SAMLDocumentHolder parseResponseDocument(byte[] samlBytes) {
        ByteArrayInputStream is = new ByteArrayInputStream(samlBytes);
        SAML2Response response = new SAML2Response();
        try {
            response.getSAML2ObjectFromStream((InputStream)is);
            return response.getSamlDocumentHolder();
        }
        catch (Exception e) {
            logger.samlBase64DecodingError((Throwable)e);
            return null;
        }
    }

    public static SAMLDocumentHolder parseResponseRedirectBinding(String samlMessage) {
        InputStream is = RedirectBindingUtil.base64DeflateDecode((String)samlMessage);
        SAML2Response response = new SAML2Response();
        try {
            response.getSAML2ObjectFromStream(is);
            return response.getSamlDocumentHolder();
        }
        catch (Exception e) {
            logger.samlBase64DecodingError((Throwable)e);
            return null;
        }
    }
}

