/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.federation.kerberos.CommonKerberosConfig;
import org.keycloak.federation.kerberos.impl.KerberosServerSubjectAuthenticator;
import org.keycloak.federation.kerberos.impl.KerberosUsernamePasswordAuthenticator;
import org.keycloak.federation.kerberos.impl.SPNEGOAuthenticator;
import org.keycloak.federation.ldap.LDAPConfig;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.federation.ldap.LDAPIdentityStoreRegistry;
import org.keycloak.federation.ldap.LDAPUtils;
import org.keycloak.federation.ldap.idm.model.LDAPObject;
import org.keycloak.federation.ldap.idm.query.Condition;
import org.keycloak.federation.ldap.idm.query.QueryParameter;
import org.keycloak.federation.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.federation.ldap.idm.query.internal.LDAPQueryConditionsBuilder;
import org.keycloak.federation.ldap.idm.store.ldap.LDAPIdentityStore;
import org.keycloak.federation.ldap.mappers.LDAPFederationMapper;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationEventAwareProviderFactory;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserFederationSyncResult;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class LDAPFederationProviderFactory
extends UserFederationEventAwareProviderFactory {
    private static final Logger logger = Logger.getLogger(LDAPFederationProviderFactory.class);
    public static final String PROVIDER_NAME = "ldap";
    private LDAPIdentityStoreRegistry ldapStoreRegistry;

    public UserFederationProvider create(KeycloakSession session) {
        throw new IllegalAccessError("Illegal to call this method");
    }

    public LDAPFederationProvider getInstance(KeycloakSession session, UserFederationProviderModel model) {
        LDAPIdentityStore ldapIdentityStore = this.ldapStoreRegistry.getLdapStore(model);
        return new LDAPFederationProvider(this, session, model, ldapIdentityStore);
    }

    public void init(Config.Scope config) {
        this.ldapStoreRegistry = new LDAPIdentityStoreRegistry();
    }

    public void close() {
        this.ldapStoreRegistry = null;
    }

    public String getId() {
        return PROVIDER_NAME;
    }

    public Set<String> getConfigurationOptions() {
        return Collections.emptySet();
    }

    public void onProviderModelCreated(RealmModel realm, UserFederationProviderModel newProviderModel) {
        LDAPConfig ldapConfig = new LDAPConfig(newProviderModel.getConfig());
        boolean activeDirectory = ldapConfig.isActiveDirectory();
        UserFederationProvider.EditMode editMode = ldapConfig.getEditMode();
        String readOnly = String.valueOf(editMode == UserFederationProvider.EditMode.READ_ONLY || editMode == UserFederationProvider.EditMode.UNSYNCED);
        String usernameLdapAttribute = ldapConfig.getUsernameLdapAttribute();
        String alwaysReadValueFromLDAP = String.valueOf(editMode == UserFederationProvider.EditMode.READ_ONLY || editMode == UserFederationProvider.EditMode.WRITABLE);
        UserFederationMapperModel mapperModel = KeycloakModelUtils.createUserFederationMapperModel((String)"username", (String)newProviderModel.getId(), (String)"user-attribute-ldap-mapper", (String[])new String[]{"user.model.attribute", "username", "ldap.attribute", usernameLdapAttribute, "read.only", readOnly, "always.read.value.from.ldap", "false", "is.mandatory.in.ldap", "true"});
        realm.addUserFederationMapper(mapperModel);
        if (ldapConfig.getRdnLdapAttribute().equalsIgnoreCase("cn")) {
            if (usernameLdapAttribute.equalsIgnoreCase("cn")) {
                mapperModel = KeycloakModelUtils.createUserFederationMapperModel((String)"first name", (String)newProviderModel.getId(), (String)"user-attribute-ldap-mapper", (String[])new String[]{"user.model.attribute", "firstName", "ldap.attribute", "givenName", "read.only", readOnly, "always.read.value.from.ldap", alwaysReadValueFromLDAP, "is.mandatory.in.ldap", "true"});
                realm.addUserFederationMapper(mapperModel);
            } else if (editMode == UserFederationProvider.EditMode.WRITABLE) {
                mapperModel = KeycloakModelUtils.createUserFederationMapperModel((String)"first name", (String)newProviderModel.getId(), (String)"user-attribute-ldap-mapper", (String[])new String[]{"user.model.attribute", "firstName", "ldap.attribute", "givenName", "read.only", readOnly, "always.read.value.from.ldap", alwaysReadValueFromLDAP, "is.mandatory.in.ldap", "true"});
                realm.addUserFederationMapper(mapperModel);
                mapperModel = KeycloakModelUtils.createUserFederationMapperModel((String)"username-cn", (String)newProviderModel.getId(), (String)"user-attribute-ldap-mapper", (String[])new String[]{"user.model.attribute", "username", "ldap.attribute", "cn", "read.only", readOnly, "always.read.value.from.ldap", "false", "is.mandatory.in.ldap", "true"});
                realm.addUserFederationMapper(mapperModel);
            } else {
                mapperModel = KeycloakModelUtils.createUserFederationMapperModel((String)"full name", (String)newProviderModel.getId(), (String)"full-name-ldap-mapper", (String[])new String[]{"ldap.full.name.attribute", "cn", "read.only", readOnly});
                realm.addUserFederationMapper(mapperModel);
            }
        } else {
            mapperModel = KeycloakModelUtils.createUserFederationMapperModel((String)"first name", (String)newProviderModel.getId(), (String)"user-attribute-ldap-mapper", (String[])new String[]{"user.model.attribute", "firstName", "ldap.attribute", "cn", "read.only", readOnly, "always.read.value.from.ldap", alwaysReadValueFromLDAP, "is.mandatory.in.ldap", "true"});
            realm.addUserFederationMapper(mapperModel);
        }
        mapperModel = KeycloakModelUtils.createUserFederationMapperModel((String)"last name", (String)newProviderModel.getId(), (String)"user-attribute-ldap-mapper", (String[])new String[]{"user.model.attribute", "lastName", "ldap.attribute", "sn", "read.only", readOnly, "always.read.value.from.ldap", alwaysReadValueFromLDAP, "is.mandatory.in.ldap", "true"});
        realm.addUserFederationMapper(mapperModel);
        mapperModel = KeycloakModelUtils.createUserFederationMapperModel((String)"email", (String)newProviderModel.getId(), (String)"user-attribute-ldap-mapper", (String[])new String[]{"user.model.attribute", "email", "ldap.attribute", "mail", "read.only", readOnly, "always.read.value.from.ldap", "false", "is.mandatory.in.ldap", "false"});
        realm.addUserFederationMapper(mapperModel);
        String createTimestampLdapAttrName = activeDirectory ? "whenCreated" : "createTimestamp";
        String modifyTimestampLdapAttrName = activeDirectory ? "whenChanged" : "modifyTimestamp";
        mapperModel = KeycloakModelUtils.createUserFederationMapperModel((String)"creation date", (String)newProviderModel.getId(), (String)"user-attribute-ldap-mapper", (String[])new String[]{"user.model.attribute", "createTimestamp", "ldap.attribute", createTimestampLdapAttrName, "read.only", "true", "always.read.value.from.ldap", alwaysReadValueFromLDAP, "is.mandatory.in.ldap", "false"});
        realm.addUserFederationMapper(mapperModel);
        mapperModel = KeycloakModelUtils.createUserFederationMapperModel((String)"modify date", (String)newProviderModel.getId(), (String)"user-attribute-ldap-mapper", (String[])new String[]{"user.model.attribute", "modifyTimestamp", "ldap.attribute", modifyTimestampLdapAttrName, "read.only", "true", "always.read.value.from.ldap", alwaysReadValueFromLDAP, "is.mandatory.in.ldap", "false"});
        realm.addUserFederationMapper(mapperModel);
    }

    public UserFederationSyncResult syncAllUsers(KeycloakSessionFactory sessionFactory, String realmId, UserFederationProviderModel model) {
        logger.infof("Sync all users from LDAP to local store: realm: %s, federation provider: %s", (Object)realmId, (Object)model.getDisplayName());
        LDAPQuery userQuery = this.createQuery(sessionFactory, realmId, model);
        UserFederationSyncResult syncResult = this.syncImpl(sessionFactory, userQuery, realmId, model);
        logger.infof("Sync all users finished: %s", (Object)syncResult.getStatus());
        return syncResult;
    }

    public UserFederationSyncResult syncChangedUsers(KeycloakSessionFactory sessionFactory, String realmId, UserFederationProviderModel model, Date lastSync) {
        logger.infof("Sync changed users from LDAP to local store: realm: %s, federation provider: %s, last sync time: " + lastSync, (Object)realmId, (Object)model.getDisplayName());
        LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
        Condition createCondition = conditionsBuilder.greaterThanOrEqualTo(new QueryParameter("createTimestamp"), lastSync);
        Condition modifyCondition = conditionsBuilder.greaterThanOrEqualTo(new QueryParameter("modifyTimestamp"), lastSync);
        Condition orCondition = conditionsBuilder.orCondition(createCondition, modifyCondition);
        LDAPQuery userQuery = this.createQuery(sessionFactory, realmId, model);
        userQuery.where(orCondition);
        UserFederationSyncResult result = this.syncImpl(sessionFactory, userQuery, realmId, model);
        logger.infof("Sync changed users finished: %s", (Object)result.getStatus());
        return result;
    }

    protected UserFederationSyncResult syncImpl(KeycloakSessionFactory sessionFactory, LDAPQuery userQuery, String realmId, UserFederationProviderModel fedModel) {
        UserFederationSyncResult syncResult = new UserFederationSyncResult();
        boolean pagination = Boolean.parseBoolean((String)fedModel.getConfig().get("pagination"));
        if (pagination) {
            String pageSizeConfig = (String)fedModel.getConfig().get("batchSizeForSync");
            int pageSize = pageSizeConfig != null ? Integer.parseInt(pageSizeConfig) : 1000;
            boolean nextPage = true;
            while (nextPage) {
                userQuery.setLimit(pageSize);
                List<LDAPObject> users = userQuery.getResultList();
                nextPage = userQuery.getPaginationContext() != null;
                UserFederationSyncResult currentPageSync = this.importLdapUsers(sessionFactory, realmId, fedModel, users);
                syncResult.add(currentPageSync);
            }
        } else {
            List<LDAPObject> users = userQuery.getResultList();
            UserFederationSyncResult currentSync = this.importLdapUsers(sessionFactory, realmId, fedModel, users);
            syncResult.add(currentSync);
        }
        return syncResult;
    }

    private LDAPQuery createQuery(KeycloakSessionFactory sessionFactory, final String realmId, final UserFederationProviderModel model) {
        class QueryHolder {
            LDAPQuery query;

            QueryHolder() {
            }
        }
        final QueryHolder queryHolder = new QueryHolder();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){
            {
            }

            public void run(KeycloakSession session) {
                LDAPFederationProvider ldapFedProvider = LDAPFederationProviderFactory.this.getInstance(session, model);
                RealmModel realm = session.realms().getRealm(realmId);
                queryHolder.query = LDAPUtils.createQueryForUserSearch(ldapFedProvider, realm);
            }
        });
        return queryHolder.query;
    }

    protected UserFederationSyncResult importLdapUsers(KeycloakSessionFactory sessionFactory, final String realmId, final UserFederationProviderModel fedModel, List<LDAPObject> ldapUsers) {
        final UserFederationSyncResult syncResult = new UserFederationSyncResult();
        class BooleanHolder {
            private boolean value = true;

            BooleanHolder() {
            }
        }
        final BooleanHolder exists = new BooleanHolder();
        for (final LDAPObject ldapUser : ldapUsers) {
            try {
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){
                    {
                    }

                    public void run(KeycloakSession session) {
                        LDAPFederationProvider ldapFedProvider = LDAPFederationProviderFactory.this.getInstance(session, fedModel);
                        RealmModel currentRealm = session.realms().getRealm(realmId);
                        String username = LDAPUtils.getUsername(ldapUser, ldapFedProvider.getLdapIdentityStore().getConfig());
                        UserModel currentUser = session.userStorage().getUserByUsername(username, currentRealm);
                        if (currentUser == null) {
                            exists.value = false;
                            ldapFedProvider.importUserFromLDAP(session, currentRealm, ldapUser);
                            syncResult.increaseAdded();
                        } else if (fedModel.getId().equals(currentUser.getFederationLink()) && ldapUser.getUuid().equals(currentUser.getFirstAttribute("LDAP_ID"))) {
                            Set federationMappers = currentRealm.getUserFederationMappersByFederationProvider(fedModel.getId());
                            for (UserFederationMapperModel mapperModel : federationMappers) {
                                LDAPFederationMapper ldapMapper = ldapFedProvider.getMapper(mapperModel);
                                ldapMapper.onImportUserFromLDAP(mapperModel, ldapFedProvider, ldapUser, currentUser, currentRealm, false);
                            }
                            logger.debugf("Updated user from LDAP: %s", (Object)currentUser.getUsername());
                            syncResult.increaseUpdated();
                        } else {
                            logger.warnf("User '%s' is not updated during sync as he already exists in Keycloak database but is not linked to federation provider '%s'", (Object)username, (Object)fedModel.getDisplayName());
                            syncResult.increaseFailed();
                        }
                    }
                });
            }
            catch (ModelException me) {
                logger.error((Object)"Failed during import user from LDAP", (Throwable)me);
                syncResult.increaseFailed();
                if (exists.value) continue;
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                    public void run(KeycloakSession session) {
                        LDAPFederationProvider ldapFedProvider = LDAPFederationProviderFactory.this.getInstance(session, fedModel);
                        RealmModel currentRealm = session.realms().getRealm(realmId);
                        String username = LDAPUtils.getUsername(ldapUser, ldapFedProvider.getLdapIdentityStore().getConfig());
                        UserModel existing = session.userStorage().getUserByUsername(username, currentRealm);
                        if (existing != null) {
                            session.userStorage().removeUser(currentRealm, existing);
                        }
                    }
                });
            }
        }
        return syncResult;
    }

    protected SPNEGOAuthenticator createSPNEGOAuthenticator(String spnegoToken, CommonKerberosConfig kerberosConfig) {
        KerberosServerSubjectAuthenticator kerberosAuth = this.createKerberosSubjectAuthenticator(kerberosConfig);
        return new SPNEGOAuthenticator(kerberosConfig, kerberosAuth, spnegoToken);
    }

    protected KerberosServerSubjectAuthenticator createKerberosSubjectAuthenticator(CommonKerberosConfig kerberosConfig) {
        return new KerberosServerSubjectAuthenticator(kerberosConfig);
    }

    protected KerberosUsernamePasswordAuthenticator createKerberosUsernamePasswordAuthenticator(CommonKerberosConfig kerberosConfig) {
        return new KerberosUsernamePasswordAuthenticator(kerberosConfig);
    }
}

