/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlow;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorContext;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.UserModel;

public class DefaultAuthenticationFlow
implements AuthenticationFlow {
    Response alternativeChallenge = null;
    AuthenticationExecutionModel challengedAlternativeExecution = null;
    boolean alternativeSuccessful = false;
    List<AuthenticationExecutionModel> executions;
    Iterator<AuthenticationExecutionModel> executionIterator;
    AuthenticationProcessor processor;
    AuthenticationFlowModel flow;

    public DefaultAuthenticationFlow(AuthenticationProcessor processor, AuthenticationFlowModel flow) {
        this.processor = processor;
        this.flow = flow;
        this.executions = processor.getRealm().getAuthenticationExecutions(flow.getId());
        this.executionIterator = this.executions.iterator();
    }

    protected boolean isProcessed(AuthenticationExecutionModel model) {
        if (model.isDisabled()) {
            return true;
        }
        ClientSessionModel.ExecutionStatus status = (ClientSessionModel.ExecutionStatus)this.processor.getClientSession().getExecutionStatus().get(model.getId());
        if (status == null) {
            return false;
        }
        return status == ClientSessionModel.ExecutionStatus.SUCCESS || status == ClientSessionModel.ExecutionStatus.SKIPPED || status == ClientSessionModel.ExecutionStatus.ATTEMPTED || status == ClientSessionModel.ExecutionStatus.SETUP_REQUIRED;
    }

    @Override
    public Response processAction(String actionExecution) {
        while (this.executionIterator.hasNext()) {
            AuthenticationExecutionModel model = this.executionIterator.next();
            if (this.isProcessed(model)) {
                AuthenticationProcessor.logger.debug((Object)"execution is processed");
                if (this.alternativeSuccessful || !model.isAlternative() || !this.processor.isSuccessful(model)) continue;
                this.alternativeSuccessful = true;
                continue;
            }
            if (model.isAutheticatorFlow()) {
                AuthenticationFlow authenticationFlow = this.processor.createFlowExecution(model.getFlowId(), model);
                return authenticationFlow.processAction(actionExecution);
            }
            if (!model.getId().equals(actionExecution)) continue;
            AuthenticatorFactory factory = (AuthenticatorFactory)this.processor.getSession().getKeycloakSessionFactory().getProviderFactory(Authenticator.class, model.getAuthenticator());
            Authenticator authenticator = factory.create();
            AuthenticatorContext result = this.processor.createAuthenticatorContext(model, authenticator, this.executions);
            authenticator.action(result);
            Response response = this.processResult(result);
            if (response == null) {
                return this.processFlow();
            }
            return response;
        }
        throw new AuthenticationProcessor.AuthException("action is not in current execution", AuthenticationProcessor.Error.INTERNAL_ERROR);
    }

    @Override
    public Response processFlow() {
        while (this.executionIterator.hasNext()) {
            AuthenticationExecutionModel model = this.executionIterator.next();
            if (this.isProcessed(model)) {
                AuthenticationProcessor.logger.debug((Object)"execution is processed");
                if (this.alternativeSuccessful || !model.isAlternative() || !this.processor.isSuccessful(model)) continue;
                this.alternativeSuccessful = true;
                continue;
            }
            if (model.isAlternative() && this.alternativeSuccessful) {
                this.processor.getClientSession().setExecutionStatus(model.getId(), ClientSessionModel.ExecutionStatus.SKIPPED);
                continue;
            }
            if (model.isAutheticatorFlow()) {
                AuthenticationFlow authenticationFlow = this.processor.createFlowExecution(model.getFlowId(), model);
                Response flowChallenge = authenticationFlow.processFlow();
                if (flowChallenge == null) {
                    this.processor.getClientSession().setExecutionStatus(model.getId(), ClientSessionModel.ExecutionStatus.SUCCESS);
                    if (!model.isAlternative()) continue;
                    this.alternativeSuccessful = true;
                    continue;
                }
                if (!model.isAlternative()) {
                    if (model.isRequired()) {
                        this.processor.getClientSession().setExecutionStatus(model.getId(), ClientSessionModel.ExecutionStatus.CHALLENGED);
                        return flowChallenge;
                    }
                    if (model.isOptional()) {
                        this.processor.getClientSession().setExecutionStatus(model.getId(), ClientSessionModel.ExecutionStatus.SKIPPED);
                        continue;
                    }
                    this.processor.getClientSession().setExecutionStatus(model.getId(), ClientSessionModel.ExecutionStatus.SKIPPED);
                    continue;
                }
                this.alternativeChallenge = flowChallenge;
                this.challengedAlternativeExecution = model;
                return flowChallenge;
            }
            AuthenticatorFactory factory = (AuthenticatorFactory)this.processor.getSession().getKeycloakSessionFactory().getProviderFactory(Authenticator.class, model.getAuthenticator());
            if (factory == null) {
                throw new AuthenticationProcessor.AuthException("Could not find AuthenticatorFactory for: " + model.getAuthenticator(), AuthenticationProcessor.Error.INTERNAL_ERROR);
            }
            Authenticator authenticator = factory.create();
            AuthenticationProcessor.logger.debugv("authenticator: {0}", (Object)factory.getId());
            UserModel authUser = this.processor.getClientSession().getAuthenticatedUser();
            if (authenticator.requiresUser() && authUser == null) {
                if (this.alternativeChallenge != null) {
                    this.processor.getClientSession().setExecutionStatus(this.challengedAlternativeExecution.getId(), ClientSessionModel.ExecutionStatus.CHALLENGED);
                    return this.alternativeChallenge;
                }
                throw new AuthenticationProcessor.AuthException("authenticator: " + factory.getId(), AuthenticationProcessor.Error.UNKNOWN_USER);
            }
            boolean configuredFor = false;
            if (authenticator.requiresUser() && authUser != null && !(configuredFor = authenticator.configuredFor(this.processor.getSession(), this.processor.getRealm(), authUser))) {
                if (model.isRequired()) {
                    if (model.isUserSetupAllowed()) {
                        AuthenticationProcessor.logger.debugv("authenticator SETUP_REQUIRED: {0}", (Object)factory.getId());
                        this.processor.getClientSession().setExecutionStatus(model.getId(), ClientSessionModel.ExecutionStatus.SETUP_REQUIRED);
                        authenticator.setRequiredActions(this.processor.getSession(), this.processor.getRealm(), this.processor.getClientSession().getAuthenticatedUser());
                        continue;
                    }
                    throw new AuthenticationProcessor.AuthException(AuthenticationProcessor.Error.CREDENTIAL_SETUP_REQUIRED);
                }
                if (model.isOptional()) {
                    this.processor.getClientSession().setExecutionStatus(model.getId(), ClientSessionModel.ExecutionStatus.SKIPPED);
                    continue;
                }
            }
            AuthenticatorContext context = this.processor.createAuthenticatorContext(model, authenticator, this.executions);
            authenticator.authenticate(context);
            Response response = this.processResult(context);
            if (response == null) continue;
            return response;
        }
        return null;
    }

    public Response processResult(AuthenticatorContext result) {
        AuthenticationExecutionModel execution = result.getExecution();
        AuthenticationProcessor.Status status = result.getStatus();
        if (status == AuthenticationProcessor.Status.SUCCESS) {
            AuthenticationProcessor.logger.debugv("authenticator SUCCESS: {0}", (Object)execution.getAuthenticator());
            this.processor.getClientSession().setExecutionStatus(execution.getId(), ClientSessionModel.ExecutionStatus.SUCCESS);
            if (execution.isAlternative()) {
                this.alternativeSuccessful = true;
            }
            return null;
        }
        if (status == AuthenticationProcessor.Status.FAILED) {
            AuthenticationProcessor.logger.debugv("authenticator FAILED: {0}", (Object)execution.getAuthenticator());
            this.processor.logFailure();
            this.processor.getClientSession().setExecutionStatus(execution.getId(), ClientSessionModel.ExecutionStatus.FAILED);
            if (result.getChallenge() != null) {
                return this.sendChallenge(result, execution);
            }
            throw new AuthenticationProcessor.AuthException(result.getError());
        }
        if (status == AuthenticationProcessor.Status.FORCE_CHALLENGE) {
            this.processor.getClientSession().setExecutionStatus(execution.getId(), ClientSessionModel.ExecutionStatus.CHALLENGED);
            return this.sendChallenge(result, execution);
        }
        if (status == AuthenticationProcessor.Status.CHALLENGE) {
            AuthenticationProcessor.logger.debugv("authenticator CHALLENGE: {0}", (Object)execution.getAuthenticator());
            if (execution.isRequired()) {
                this.processor.getClientSession().setExecutionStatus(execution.getId(), ClientSessionModel.ExecutionStatus.CHALLENGED);
                return this.sendChallenge(result, execution);
            }
            UserModel authenticatedUser = this.processor.getClientSession().getAuthenticatedUser();
            if (execution.isOptional() && authenticatedUser != null && result.getAuthenticator().configuredFor(this.processor.getSession(), this.processor.getRealm(), authenticatedUser)) {
                this.processor.getClientSession().setExecutionStatus(execution.getId(), ClientSessionModel.ExecutionStatus.CHALLENGED);
                return this.sendChallenge(result, execution);
            }
            if (execution.isAlternative()) {
                this.alternativeChallenge = result.getChallenge();
                this.challengedAlternativeExecution = execution;
            } else {
                this.processor.getClientSession().setExecutionStatus(execution.getId(), ClientSessionModel.ExecutionStatus.SKIPPED);
            }
            return null;
        }
        if (status == AuthenticationProcessor.Status.FAILURE_CHALLENGE) {
            AuthenticationProcessor.logger.debugv("authenticator FAILURE_CHALLENGE: {0}", (Object)execution.getAuthenticator());
            this.processor.logFailure();
            this.processor.getClientSession().setExecutionStatus(execution.getId(), ClientSessionModel.ExecutionStatus.CHALLENGED);
            return this.sendChallenge(result, execution);
        }
        if (status == AuthenticationProcessor.Status.ATTEMPTED) {
            AuthenticationProcessor.logger.debugv("authenticator ATTEMPTED: {0}", (Object)execution.getAuthenticator());
            if (execution.getRequirement() == AuthenticationExecutionModel.Requirement.REQUIRED) {
                throw new AuthenticationProcessor.AuthException(AuthenticationProcessor.Error.INVALID_CREDENTIALS);
            }
            this.processor.getClientSession().setExecutionStatus(execution.getId(), ClientSessionModel.ExecutionStatus.ATTEMPTED);
            return null;
        }
        AuthenticationProcessor.logger.debugv("authenticator INTERNAL_ERROR: {0}", (Object)execution.getAuthenticator());
        AuthenticationProcessor.logger.error((Object)"Unknown result status");
        throw new AuthenticationProcessor.AuthException(AuthenticationProcessor.Error.INTERNAL_ERROR);
    }

    public Response sendChallenge(AuthenticatorContext result, AuthenticationExecutionModel execution) {
        this.processor.getClientSession().setNote("current.authentication.execution", execution.getId());
        return result.getChallenge();
    }
}

