/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorContext;
import org.keycloak.authentication.authenticators.browser.AbstractFormAuthenticator;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;

public class SpnegoAuthenticator
extends AbstractFormAuthenticator
implements Authenticator {
    public static final String KERBEROS_DISABLED = "kerberos_disabled";
    protected static Logger logger = Logger.getLogger(SpnegoAuthenticator.class);
    public static boolean bypassChallengeJavascript = false;

    @Override
    public boolean requiresUser() {
        return false;
    }

    @Override
    public void action(AuthenticatorContext context) {
        context.attempted();
    }

    @Override
    public void authenticate(AuthenticatorContext context) {
        HttpRequest request = context.getHttpRequest();
        String authHeader = (String)request.getHttpHeaders().getRequestHeaders().getFirst((Object)"Authorization");
        if (authHeader == null) {
            Response challenge = this.challengeNegotiation(context, null);
            context.forceChallenge(challenge);
            return;
        }
        String[] tokens = authHeader.split(" ");
        if (tokens.length == 0) {
            logger.debug((Object)("Invalid length of tokens: " + tokens.length));
            context.attempted();
            return;
        }
        if (!"Negotiate".equalsIgnoreCase(tokens[0])) {
            logger.debug((Object)("Unknown scheme " + tokens[0]));
            context.attempted();
            return;
        }
        if (tokens.length != 2) {
            context.failure(AuthenticationProcessor.Error.INVALID_CREDENTIALS);
            return;
        }
        String spnegoToken = tokens[1];
        UserCredentialModel spnegoCredential = UserCredentialModel.kerberos((String)spnegoToken);
        CredentialValidationOutput output = context.getSession().users().validCredentials(context.getRealm(), new UserCredentialModel[]{spnegoCredential});
        if (output.getAuthStatus() == CredentialValidationOutput.Status.AUTHENTICATED) {
            context.setUser(output.getAuthenticatedUser());
            if (output.getState() != null && !output.getState().isEmpty()) {
                for (Map.Entry entry : output.getState().entrySet()) {
                    context.getClientSession().setUserSessionNote((String)entry.getKey(), (String)entry.getValue());
                }
            }
            context.success();
        } else if (output.getAuthStatus() == CredentialValidationOutput.Status.CONTINUE) {
            String spnegoResponseToken = (String)output.getState().get("SpnegoResponseToken");
            Response challenge = this.challengeNegotiation(context, spnegoResponseToken);
            context.challenge(challenge);
        } else {
            context.getEvent().error("invalid_user_credentials");
            context.failure(AuthenticationProcessor.Error.INVALID_CREDENTIALS);
        }
    }

    private Response challengeNegotiation(AuthenticatorContext context, String negotiateToken) {
        String negotiateHeader;
        String string = negotiateHeader = negotiateToken == null ? "Negotiate" : "Negotiate " + negotiateToken;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Sending back WWW-Authenticate: " + negotiateHeader));
        }
        if (context.getExecution().isRequired()) {
            return ((LoginFormsProvider)context.getSession().getProvider(LoginFormsProvider.class)).setStatus(Response.Status.UNAUTHORIZED).setResponseHeader("WWW-Authenticate", negotiateHeader).setError("kerberosNotSetUp", new Object[0]).createErrorPage();
        }
        return this.optionalChallengeRedirect(context, negotiateHeader);
    }

    protected Response optionalChallengeRedirect(AuthenticatorContext context, String negotiateHeader) {
        String accessCode = context.generateAccessCode();
        URI action = this.getActionUrl(context, accessCode);
        StringBuilder builder = new StringBuilder();
        builder.append("<HTML>");
        builder.append("<HEAD>");
        builder.append("<TITLE>Kerberos Unsupported</TITLE>");
        builder.append("</HEAD>");
        if (bypassChallengeJavascript) {
            builder.append("<BODY>");
        } else {
            builder.append("<BODY Onload=\"document.forms[0].submit()\">");
        }
        builder.append("<FORM METHOD=\"POST\" ACTION=\"" + action.toString() + "\">");
        builder.append("<NOSCRIPT>");
        builder.append("<P>JavaScript is disabled. We strongly recommend to enable it. You were unable to login via Kerberos.  Click the button below to login via an alternative method .</P>");
        builder.append("<INPUT name=\"continue\" TYPE=\"SUBMIT\" VALUE=\"CONTINUE\" />");
        builder.append("</NOSCRIPT>");
        builder.append("</FORM></BODY></HTML>");
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)negotiateHeader).type(MediaType.TEXT_HTML_TYPE).entity((Object)builder.toString()).build();
    }

    @Override
    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    @Override
    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    @Override
    public void close() {
    }
}

