/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorContext;
import org.keycloak.authentication.authenticators.browser.AbstractFormAuthenticator;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.services.managers.AuthenticationManager;

public class UsernamePasswordForm
extends AbstractFormAuthenticator
implements Authenticator {
    @Override
    public void action(AuthenticatorContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        if (formData.containsKey((Object)"cancel")) {
            context.getEvent().error("rejected_by_user");
            LoginProtocol protocol = (LoginProtocol)context.getSession().getProvider(LoginProtocol.class, context.getClientSession().getAuthMethod());
            protocol.setRealm(context.getRealm()).setHttpHeaders(context.getHttpRequest().getHttpHeaders()).setUriInfo(context.getUriInfo());
            Response response = protocol.cancelLogin(context.getClientSession());
            context.forceChallenge(response);
            return;
        }
        if (!this.validateForm(context, (MultivaluedMap<String, String>)formData)) {
            return;
        }
        context.success();
    }

    protected boolean validateForm(AuthenticatorContext context, MultivaluedMap<String, String> formData) {
        return this.validateUser(context, formData) && this.validatePassword(context, formData);
    }

    @Override
    public void authenticate(AuthenticatorContext context) {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        String loginHint = context.getClientSession().getNote("login_hint");
        String rememberMeUsername = AuthenticationManager.getRememberMeUsername(context.getRealm(), context.getHttpRequest().getHttpHeaders());
        if (loginHint != null || rememberMeUsername != null) {
            if (loginHint != null) {
                formData.add((Object)"username", (Object)loginHint);
            } else {
                formData.add((Object)"username", (Object)rememberMeUsername);
                formData.add((Object)"rememberMe", (Object)"on");
            }
        }
        Response challengeResponse = this.challenge(context, (MultivaluedMap<String, String>)formData);
        context.getClientSession().setNote("current.authentication.execution", context.getExecution().getId());
        context.challenge(challengeResponse);
    }

    @Override
    public boolean requiresUser() {
        return false;
    }

    protected Response challenge(AuthenticatorContext context, MultivaluedMap<String, String> formData) {
        LoginFormsProvider forms = this.loginForm(context);
        if (formData.size() > 0) {
            forms.setFormData(formData);
        }
        return forms.createLogin();
    }

    @Override
    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    @Override
    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    @Override
    public void close() {
    }
}

