/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport;

import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.exportimport.ExportProvider;
import org.keycloak.exportimport.ImportProvider;
import org.keycloak.exportimport.Strategy;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.managers.ApplianceBootstrap;

public class ExportImportManager {
    private static final Logger logger = Logger.getLogger(ExportImportManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkExportImport(KeycloakSessionFactory sessionFactory, String contextPath) {
        String exportImportAction = ExportImportConfig.getAction();
        String realmName = ExportImportConfig.getRealmName();
        boolean export = false;
        boolean importt = false;
        if ("export".equals(exportImportAction)) {
            export = true;
        } else if ("import".equals(exportImportAction)) {
            importt = true;
        }
        if (export || importt) {
            String exportImportProviderId = ExportImportConfig.getProvider();
            logger.debug((Object)("Will use provider: " + exportImportProviderId));
            try (KeycloakSession session = sessionFactory.create();){
                if (export) {
                    ExportProvider exportProvider = (ExportProvider)session.getProvider(ExportProvider.class, exportImportProviderId);
                    if (realmName == null) {
                        logger.info((Object)"Full model export requested");
                        exportProvider.exportModel(sessionFactory);
                    } else {
                        logger.infof("Export of realm '%s' requested", (Object)realmName);
                        exportProvider.exportRealm(sessionFactory, realmName);
                    }
                    logger.info((Object)"Export finished successfully");
                } else {
                    ImportProvider importProvider = (ImportProvider)session.getProvider(ImportProvider.class, exportImportProviderId);
                    Strategy strategy = ExportImportConfig.getStrategy();
                    if (realmName == null) {
                        logger.infof("Full model import requested. Strategy: %s", (Object)strategy.toString());
                        if (!importProvider.isMasterRealmExported()) {
                            new ApplianceBootstrap().bootstrap(sessionFactory, contextPath);
                        }
                        importProvider.importModel(sessionFactory, strategy);
                    } else {
                        logger.infof("Import of realm '%s' requested. Strategy: %s", (Object)realmName, (Object)strategy.toString());
                        if (!realmName.equals(Config.getAdminRealm())) {
                            new ApplianceBootstrap().bootstrap(sessionFactory, contextPath);
                        }
                        importProvider.importRealm(sessionFactory, realmName, strategy);
                    }
                    logger.info((Object)"Import finished successfully");
                }
            }
        }
    }
}

