/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.config.http;

import java.util.LinkedList;
import java.util.List;
import org.picketlink.config.AbstractSecurityConfigurationBuilder;
import org.picketlink.config.SecurityConfigurationBuilder;
import org.picketlink.config.http.FilteringMode;
import org.picketlink.config.http.HttpSecurityConfiguration;
import org.picketlink.config.http.HttpSecurityConfigurationChildBuilder;
import org.picketlink.config.http.PathConfiguration;
import org.picketlink.config.http.PathConfigurationBuilder;
import org.picketlink.idm.config.SecurityConfigurationException;

public abstract class AbstractHttpSecurityBuilder
extends AbstractSecurityConfigurationBuilder<HttpSecurityConfiguration>
implements HttpSecurityConfigurationChildBuilder {
    private final List<PathConfigurationBuilder> uriConfigBuilder = new LinkedList<PathConfigurationBuilder>();
    private FilteringMode filteringMode;

    public AbstractHttpSecurityBuilder(SecurityConfigurationBuilder builder) {
        super(builder);
    }

    @Override
    public PathConfigurationBuilder allPaths() {
        return this.pathGroup("Default", "/*");
    }

    @Override
    public PathConfigurationBuilder forPath(String path) {
        return this.forPath(path, "Default");
    }

    @Override
    public PathConfigurationBuilder forPath(String path, String groupName) {
        return this.pathGroup(groupName, path);
    }

    @Override
    public PathConfigurationBuilder forGroup(String groupName) {
        return this.pathGroup(groupName, null);
    }

    private PathConfigurationBuilder pathGroup(String groupName, String path) {
        PathConfigurationBuilder pathConfigurationBuilder = new PathConfigurationBuilder(groupName, path, null, this);
        this.uriConfigBuilder.add(pathConfigurationBuilder);
        return pathConfigurationBuilder;
    }

    @Override
    public HttpSecurityConfigurationChildBuilder restrictive() {
        this.filteringMode = FilteringMode.RESTRICTIVE;
        return this;
    }

    @Override
    protected HttpSecurityConfiguration create() throws SecurityConfigurationException {
        LinkedList<PathConfiguration> uriConfigs = new LinkedList<PathConfiguration>();
        for (PathConfigurationBuilder uriConfigBuilder : this.uriConfigBuilder) {
            uriConfigs.add(uriConfigBuilder.create());
        }
        return new HttpSecurityConfiguration(uriConfigs, this.filteringMode);
    }
}

