/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.edit.KeyOperation;
import org.jboss.aesh.edit.actions.Operation;

public class KeyOperationManager {
    private List<KeyOperation> operations = new ArrayList<KeyOperation>();

    public List<KeyOperation> getOperations() {
        return this.operations;
    }

    public void clear() {
        this.operations.clear();
    }

    public void addOperations(List<KeyOperation> newOperations) {
        for (KeyOperation ko : newOperations) {
            this.checkAndRemove(ko);
            this.operations.add(ko);
        }
    }

    public void addOperation(KeyOperation operation) {
        this.checkAndRemove(operation);
        this.operations.add(operation);
    }

    private boolean exists(KeyOperation operation) {
        for (KeyOperation ko : this.operations) {
            if (!Arrays.equals(ko.getKeyValues(), operation.getKeyValues())) continue;
            return true;
        }
        return false;
    }

    private void checkAndRemove(KeyOperation ko) {
        Iterator<KeyOperation> iter = this.operations.iterator();
        while (iter.hasNext()) {
            KeyOperation operation = iter.next();
            if (!Arrays.equals(operation.getKeyValues(), ko.getKeyValues()) || !operation.getWorkingMode().equals((Object)ko.getWorkingMode())) continue;
            iter.remove();
            return;
        }
    }

    public KeyOperation findOperation(int[] input) {
        for (KeyOperation operation : this.operations) {
            if (!operation.equalValues(input)) continue;
            return operation;
        }
        return this.findOtherOperations(input);
    }

    private KeyOperation findOtherOperations(int[] input) {
        if (this.startsWithEscape(input)) {
            if (Config.isOSPOSIXCompatible()) {
                for (KeyOperation operation : this.operations) {
                    if (!operation.isEscapeCommand() || !this.startsFirstArgWithSecond(input, operation.getKeyValues()) || input.length % operation.getKeyValues().length != 0) continue;
                    return operation;
                }
                return new KeyOperation(new int[]{27}, Operation.NO_ACTION);
            }
            return new KeyOperation(new int[]{224}, Operation.NO_ACTION);
        }
        if (this.startsWithBackspace(input)) {
            if (Config.isOSPOSIXCompatible()) {
                return this.findOperation(new int[]{127});
            }
            return this.findOperation(new int[]{8});
        }
        return null;
    }

    private boolean startsWithEscape(int[] input) {
        if (Config.isOSPOSIXCompatible()) {
            return input[0] == 27;
        }
        return input[0] == 224;
    }

    private boolean startsWithBackspace(int[] input) {
        if (Config.isOSPOSIXCompatible()) {
            return input[0] == 127;
        }
        return input[0] == 8;
    }

    private boolean startsFirstArgWithSecond(int[] input1, int[] input2) {
        if (input1.length < input2.length) {
            return false;
        }
        for (int i = 0; i < input2.length; ++i) {
            if (input1[i] == input2[i]) continue;
            return false;
        }
        return true;
    }
}

