/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.provider.Provider;

public interface IdentityProvider<C extends IdentityProviderModel>
extends Provider {
    public void preprocessFederatedIdentity(KeycloakSession var1, RealmModel var2, BrokeredIdentityContext var3);

    public void attachUserSession(UserSessionModel var1, ClientSessionModel var2, BrokeredIdentityContext var3);

    public void importNewUser(KeycloakSession var1, RealmModel var2, UserModel var3, BrokeredIdentityContext var4);

    public void updateBrokeredUser(KeycloakSession var1, RealmModel var2, UserModel var3, BrokeredIdentityContext var4);

    public Object callback(RealmModel var1, AuthenticationCallback var2, EventBuilder var3);

    public Response performLogin(AuthenticationRequest var1);

    public Response retrieveToken(FederatedIdentityModel var1);

    public void backchannelLogout(UserSessionModel var1, UriInfo var2, RealmModel var3);

    public Response keycloakInitiatedBrowserLogout(UserSessionModel var1, UriInfo var2, RealmModel var3);

    public Response export(UriInfo var1, RealmModel var2, String var3);

    public static interface AuthenticationCallback {
        public Response authenticated(BrokeredIdentityContext var1);

        public Response cancelled(String var1);

        public Response error(String var1, String var2);
    }
}

