/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.aztec.encoder.AztecCode;
import com.google.zxing.aztec.encoder.Encoder;
import com.google.zxing.common.BitMatrix;
import java.nio.charset.Charset;
import java.util.Map;

public final class AztecWriter
implements Writer {
    private static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");

    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height) {
        return AztecWriter.encode(contents, format, DEFAULT_CHARSET, 33);
    }

    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) {
        String charset = (String)hints.get((Object)EncodeHintType.CHARACTER_SET);
        Number eccPercent = (Number)hints.get((Object)EncodeHintType.ERROR_CORRECTION);
        return AztecWriter.encode(contents, format, charset == null ? DEFAULT_CHARSET : Charset.forName(charset), eccPercent == null ? 33 : eccPercent.intValue());
    }

    private static BitMatrix encode(String contents, BarcodeFormat format, Charset charset, int eccPercent) {
        if (format != BarcodeFormat.AZTEC) {
            throw new IllegalArgumentException("Can only encode AZTEC, but got " + (Object)((Object)format));
        }
        AztecCode aztec = Encoder.encode(contents.getBytes(charset), eccPercent);
        return aztec.getMatrix();
    }
}

