/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.collector.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.query.collector.impl.FacetCounter;
import org.hibernate.search.query.collector.impl.IntegerWrapper;
import org.hibernate.search.query.dsl.impl.DiscreteFacetRequest;
import org.hibernate.search.query.dsl.impl.FacetingRequestImpl;
import org.hibernate.search.query.dsl.impl.RangeFacetImpl;
import org.hibernate.search.query.dsl.impl.RangeFacetRequest;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.fieldcache.impl.FieldCacheLoadingType;
import org.hibernate.search.query.fieldcache.impl.FieldLoadingStrategy;
import org.hibernate.search.util.impl.CollectionHelper;

public class FacetCollector
extends Collector {
    private final Collector nextInChainCollector;
    private final FacetingRequestImpl facetRequest;
    private final FieldLoadingStrategy fieldLoader;
    private final FacetCounter facetCounts;
    private boolean initialised = false;

    public FacetCollector(Collector nextInChainCollector, FacetingRequestImpl facetRequest) {
        this.nextInChainCollector = nextInChainCollector;
        this.facetRequest = facetRequest;
        this.facetCounts = this.createFacetCounter(facetRequest);
        this.fieldLoader = FieldCacheLoadingType.getLoadingStrategy(this.facetRequest.getFieldName(), this.facetRequest.getFieldCacheType());
    }

    public void setNextReader(AtomicReaderContext context) throws IOException {
        if (!this.initialised) {
            this.initialiseCollector(context);
        }
        this.initialiseFieldCaches(context);
        this.nextInChainCollector.setNextReader(context);
    }

    public void collect(int doc) throws IOException {
        Object value = this.fieldLoader.collect(doc);
        if (value != null) {
            this.facetCounts.countValue(value);
        }
        this.nextInChainCollector.collect(doc);
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.nextInChainCollector.setScorer(scorer);
    }

    public boolean acceptsDocsOutOfOrder() {
        return this.nextInChainCollector.acceptsDocsOutOfOrder();
    }

    public String getFacetName() {
        return this.facetRequest.getFacetingName();
    }

    public List<Facet> getFacetList() {
        return this.createSortedFacetList(this.facetCounts, this.facetRequest);
    }

    private List<Facet> createSortedFacetList(FacetCounter counter, FacetingRequestImpl request) {
        List<Facet> facetList;
        if (FacetSortOrder.RANGE_DEFINITION_ORDER.equals((Object)request.getSort())) {
            facetList = this.createRangeFacetList(counter.getCounts().entrySet(), request, counter.getCounts().size());
            Collections.sort(facetList, new RangeDefinitionOrderFacetComparator());
            if (this.facetRequest.getMaxNumberOfFacets() > 0) {
                facetList = facetList.subList(0, Math.min(this.facetRequest.getMaxNumberOfFacets(), facetList.size()));
            }
        } else {
            ArrayList<Map.Entry<String, IntegerWrapper>> countEntryList = CollectionHelper.newArrayList(counter.getCounts().size());
            for (Map.Entry<String, IntegerWrapper> stringIntegerEntry : counter.getCounts().entrySet()) {
                countEntryList.add(stringIntegerEntry);
            }
            int facetCount = this.facetRequest.getMaxNumberOfFacets() > 0 ? this.facetRequest.getMaxNumberOfFacets() : countEntryList.size();
            Collections.sort(countEntryList, new FacetEntryComparator(request.getSort()));
            facetList = this.createRangeFacetList(countEntryList, request, facetCount);
        }
        return facetList;
    }

    private List<Facet> createRangeFacetList(Collection<Map.Entry<String, IntegerWrapper>> countEntryList, FacetingRequestImpl request, int count) {
        ArrayList<Facet> facetList = CollectionHelper.newArrayList(countEntryList.size());
        int includedFacetCount = 0;
        for (Map.Entry<String, IntegerWrapper> countEntry : countEntryList) {
            Facet facet = request.createFacet(countEntry.getKey(), countEntry.getValue().getCount());
            if (!request.hasZeroCountsIncluded() && facet.getCount() == 0) continue;
            facetList.add(facet);
            if (++includedFacetCount != count) continue;
            break;
        }
        return facetList;
    }

    private void initialiseCollector(AtomicReaderContext context) throws IOException {
        if (this.facetRequest.hasZeroCountsIncluded() && this.facetRequest instanceof DiscreteFacetRequest) {
            this.initFacetCounts(context);
        }
        this.initialised = true;
    }

    private void initialiseFieldCaches(AtomicReaderContext context) throws IOException {
        this.fieldLoader.loadNewCacheValues(context);
    }

    private <N extends Number> FacetCounter createFacetCounter(FacetingRequestImpl request) {
        if (request instanceof DiscreteFacetRequest) {
            return new FacetCounter.SimpleFacetCounter();
        }
        if (request instanceof RangeFacetRequest) {
            RangeFacetRequest rangeFacetRequest = (RangeFacetRequest)request;
            return new FacetCounter.RangeFacetCounter(rangeFacetRequest);
        }
        throw new IllegalArgumentException("Unsupported cache type");
    }

    private void initFacetCounts(AtomicReaderContext context) throws IOException {
        BytesRef byteRef;
        String fieldName = this.facetRequest.getFieldName();
        AtomicReader atomicReader = context.reader();
        Terms terms = atomicReader.terms(fieldName);
        if (terms == null) {
            return;
        }
        TermsEnum iterator = terms.iterator(null);
        while ((byteRef = iterator.next()) != null) {
            String fieldValue = byteRef.utf8ToString();
            this.facetCounts.initCount(fieldValue);
        }
    }

    public static class RangeDefinitionOrderFacetComparator
    implements Comparator<Facet>,
    Serializable {
        @Override
        public int compare(Facet facet1, Facet facet2) {
            return ((RangeFacetImpl)facet1).getRangeIndex() - ((RangeFacetImpl)facet2).getRangeIndex();
        }
    }

    public static class FacetEntryComparator
    implements Comparator<Map.Entry<String, IntegerWrapper>>,
    Serializable {
        private final FacetSortOrder sortOder;

        public FacetEntryComparator(FacetSortOrder sortOrder) {
            this.sortOder = sortOrder;
        }

        @Override
        public int compare(Map.Entry<String, IntegerWrapper> entry1, Map.Entry<String, IntegerWrapper> entry2) {
            if (FacetSortOrder.COUNT_ASC.equals((Object)this.sortOder)) {
                return entry1.getValue().getCount() - entry2.getValue().getCount();
            }
            if (FacetSortOrder.COUNT_DESC.equals((Object)this.sortOder)) {
                return entry2.getValue().getCount() - entry1.getValue().getCount();
            }
            return entry1.getKey().compareTo(entry2.getKey());
        }
    }
}

