/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.client.j2se.Config;
import com.google.zxing.client.j2se.DecodeWorker;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;

public final class CommandLineRunner {
    private static final String POSSIBLE_FORMATS_ARG = "--possibleFormats=";
    private static final Pattern COMMA = Pattern.compile(",");

    private CommandLineRunner() {
    }

    public static void main(String[] args) throws Exception {
        int total;
        if (args.length == 0) {
            CommandLineRunner.printUsage();
            return;
        }
        Config config = new Config();
        for (String arg : args) {
            if ("--try_harder".equals(arg)) {
                config.setTryHarder(true);
                continue;
            }
            if ("--pure_barcode".equals(arg)) {
                config.setPureBarcode(true);
                continue;
            }
            if ("--products_only".equals(arg)) {
                config.setProductsOnly(true);
                continue;
            }
            if ("--dump_results".equals(arg)) {
                config.setDumpResults(true);
                continue;
            }
            if ("--dump_black_point".equals(arg)) {
                config.setDumpBlackPoint(true);
                continue;
            }
            if ("--multi".equals(arg)) {
                config.setMulti(true);
                continue;
            }
            if ("--brief".equals(arg)) {
                config.setBrief(true);
                continue;
            }
            if ("--recursive".equals(arg)) {
                config.setRecursive(true);
                continue;
            }
            if (arg.startsWith("--crop")) {
                int[] crop = new int[4];
                String[] tokens = COMMA.split(arg.substring(7));
                for (int i = 0; i < crop.length; ++i) {
                    crop[i] = Integer.parseInt(tokens[i]);
                }
                config.setCrop(crop);
                continue;
            }
            if (arg.startsWith(POSSIBLE_FORMATS_ARG)) {
                config.setPossibleFormats(COMMA.split(arg.substring(POSSIBLE_FORMATS_ARG.length())));
                continue;
            }
            if (!arg.startsWith("-")) continue;
            System.err.println("Unknown command line option " + arg);
            CommandLineRunner.printUsage();
            return;
        }
        config.setHints(CommandLineRunner.buildHints(config));
        ConcurrentLinkedQueue<String> inputs = new ConcurrentLinkedQueue<String>();
        for (String arg : args) {
            if (arg.startsWith("--")) continue;
            CommandLineRunner.addArgumentToInputs(arg, config, inputs);
        }
        int numThreads = Math.min(inputs.size(), Runtime.getRuntime().availableProcessors());
        int successful = 0;
        if (numThreads > 1) {
            ExecutorService executor = Executors.newFixedThreadPool(numThreads);
            ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>(numThreads);
            for (int x = 0; x < numThreads; ++x) {
                futures.add(executor.submit(new DecodeWorker(config, inputs)));
            }
            executor.shutdown();
            for (Future future : futures) {
                successful += ((Integer)future.get()).intValue();
            }
        } else {
            successful += new DecodeWorker(config, inputs).call().intValue();
        }
        if ((total = inputs.size()) > 1) {
            System.out.println("\nDecoded " + successful + " files out of " + total + " successfully (" + successful * 100 / total + "%)\n");
        }
    }

    private static void addArgumentToInputs(String argument, Config config, Queue<String> inputs) throws IOException {
        File inputFile = new File(argument);
        if (inputFile.exists()) {
            if (inputFile.isDirectory()) {
                for (File singleFile : inputFile.listFiles()) {
                    String filename = singleFile.getName().toLowerCase(Locale.ENGLISH);
                    if (filename.startsWith(".")) continue;
                    if (singleFile.isDirectory()) {
                        if (!config.isRecursive()) continue;
                        CommandLineRunner.addArgumentToInputs(singleFile.getAbsolutePath(), config, inputs);
                        continue;
                    }
                    if (filename.endsWith(".txt") || filename.contains(".mono.png")) continue;
                    inputs.add(singleFile.getCanonicalPath());
                }
            } else {
                inputs.add(inputFile.getCanonicalPath());
            }
        } else {
            inputs.add(argument);
        }
    }

    private static Map<DecodeHintType, ?> buildHints(Config config) {
        ArrayList<BarcodeFormat> possibleFormats = new ArrayList<BarcodeFormat>();
        String[] possibleFormatsNames = config.getPossibleFormats();
        if (possibleFormatsNames != null && possibleFormatsNames.length > 0) {
            for (String format : possibleFormatsNames) {
                possibleFormats.add(BarcodeFormat.valueOf((String)format));
            }
        } else {
            possibleFormats.add(BarcodeFormat.UPC_A);
            possibleFormats.add(BarcodeFormat.UPC_E);
            possibleFormats.add(BarcodeFormat.EAN_13);
            possibleFormats.add(BarcodeFormat.EAN_8);
            possibleFormats.add(BarcodeFormat.RSS_14);
            possibleFormats.add(BarcodeFormat.RSS_EXPANDED);
            if (!config.isProductsOnly()) {
                possibleFormats.add(BarcodeFormat.CODE_39);
                possibleFormats.add(BarcodeFormat.CODE_93);
                possibleFormats.add(BarcodeFormat.CODE_128);
                possibleFormats.add(BarcodeFormat.ITF);
                possibleFormats.add(BarcodeFormat.QR_CODE);
                possibleFormats.add(BarcodeFormat.DATA_MATRIX);
                possibleFormats.add(BarcodeFormat.AZTEC);
                possibleFormats.add(BarcodeFormat.PDF_417);
                possibleFormats.add(BarcodeFormat.CODABAR);
                possibleFormats.add(BarcodeFormat.MAXICODE);
            }
        }
        EnumMap<DecodeHintType, Serializable> hints = new EnumMap<DecodeHintType, Serializable>(DecodeHintType.class);
        hints.put(DecodeHintType.POSSIBLE_FORMATS, possibleFormats);
        if (config.isTryHarder()) {
            hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        }
        if (config.isPureBarcode()) {
            hints.put(DecodeHintType.PURE_BARCODE, Boolean.TRUE);
        }
        return hints;
    }

    private static void printUsage() {
        System.err.println("Decode barcode images using the ZXing library");
        System.err.println();
        System.err.println("usage: CommandLineRunner { file | dir | url } [ options ]");
        System.err.println("  --try_harder: Use the TRY_HARDER hint, default is normal (mobile) mode");
        System.err.println("  --pure_barcode: Input image is a pure monochrome barcode image, not a photo");
        System.err.println("  --products_only: Only decode the UPC and EAN families of barcodes");
        System.err.println("  --dump_results: Write the decoded contents to input.txt");
        System.err.println("  --dump_black_point: Compare black point algorithms as input.mono.png");
        System.err.println("  --multi: Scans image for multiple barcodes");
        System.err.println("  --brief: Only output one line per file, omitting the contents");
        System.err.println("  --recursive: Descend into subdirectories");
        System.err.println("  --crop=left,top,width,height: Only examine cropped region of input image(s)");
        StringBuilder builder = new StringBuilder("  --possibleFormats=barcodeFormat[,barcodeFormat2...] where barcodeFormat is any of: ");
        for (BarcodeFormat format : BarcodeFormat.values()) {
            builder.append(format).append(',');
        }
        builder.setLength(builder.length() - 1);
        System.err.println(builder);
    }
}

